/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.rendering.celeritas;

import org.embeddedt.embeddium.api.util.NormI8;
import org.embeddedt.embeddium.impl.model.quad.ModelQuadView;
import org.embeddedt.embeddium.impl.model.quad.properties.ModelQuadFacing;
import org.embeddedt.embeddium.impl.model.quad.properties.ModelQuadFlags;
import org.embeddedt.embeddium.impl.render.chunk.vertex.format.ChunkVertexEncoder;
import org.embeddedt.embeddium.impl.util.QuadUtil;

public class VertexArrayQuadView
implements ModelQuadView {
    private final ChunkVertexEncoder.Vertex[] vertices;
    private int trueNormal;
    private int blockX;
    private int blockY;
    private int blockZ;
    private ModelQuadFacing lightFace;
    private int flags;

    public VertexArrayQuadView(ChunkVertexEncoder.Vertex[] vertices) {
        this.vertices = vertices;
    }

    public void setup(int trueNormal, int blockX, int blockY, int blockZ) {
        this.trueNormal = trueNormal;
        this.blockX = blockX;
        this.blockY = blockY;
        this.blockZ = blockZ;
        this.lightFace = null;
        this.flags = 0;
    }

    @Override
    public float getX(int idx) {
        return this.vertices[idx].x - (float)this.blockX;
    }

    @Override
    public float getY(int idx) {
        return this.vertices[idx].y - (float)this.blockY;
    }

    @Override
    public float getZ(int idx) {
        return this.vertices[idx].z - (float)this.blockZ;
    }

    @Override
    public int getColor(int idx) {
        return this.vertices[idx].color;
    }

    @Override
    public float getTexU(int idx) {
        return this.vertices[idx].u;
    }

    @Override
    public float getTexV(int idx) {
        return this.vertices[idx].v;
    }

    @Override
    public int getLight(int idx) {
        return this.vertices[idx].light;
    }

    @Override
    public int getFlags() {
        if (this.flags == 0) {
            this.flags = ModelQuadFlags.getQuadFlags(this, this.getLightFace());
        }
        return this.flags;
    }

    @Override
    public int getColorIndex() {
        return -1;
    }

    @Override
    public Object celeritas$getSprite() {
        return null;
    }

    @Override
    public ModelQuadFacing getLightFace() {
        if (this.lightFace == null) {
            this.lightFace = VertexArrayQuadView.computeLightFace(this.trueNormal);
        }
        return this.lightFace;
    }

    @Override
    public ModelQuadFacing getNormalFace() {
        return QuadUtil.findNormalFace(this.trueNormal);
    }

    @Override
    public int getForgeNormal(int idx) {
        return this.vertices[idx].vanillaNormal;
    }

    @Override
    public int getComputedFaceNormal() {
        return this.trueNormal;
    }

    public ModelQuadFacing getCullFace() {
        if ((this.getFlags() & 4) == 0) {
            return ModelQuadFacing.UNASSIGNED;
        }
        return this.getNormalFace();
    }

    private static ModelQuadFacing computeLightFace(int normal) {
        float nx = NormI8.unpackX(normal);
        float ny = NormI8.unpackY(normal);
        float nz = NormI8.unpackZ(normal);
        float absX = Math.abs(nx);
        float absY = Math.abs(ny);
        float absZ = Math.abs(nz);
        if (absY >= absX && absY >= absZ) {
            return ny >= 0.0f ? ModelQuadFacing.POS_Y : ModelQuadFacing.NEG_Y;
        }
        if (absX >= absZ) {
            return nx >= 0.0f ? ModelQuadFacing.POS_X : ModelQuadFacing.NEG_X;
        }
        return nz >= 0.0f ? ModelQuadFacing.POS_Z : ModelQuadFacing.NEG_Z;
    }
}

