/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.rendering.celeritas;

import com.mitchej123.lwjgl.LWJGLServiceProvider;
import java.util.Arrays;
import java.util.Objects;
import org.embeddedt.embeddium.impl.gl.device.CommandList;
import org.embeddedt.embeddium.impl.gl.device.DrawCommandList;
import org.embeddedt.embeddium.impl.gl.device.MultiDrawBatch;
import org.embeddedt.embeddium.impl.gl.tessellation.GlIndexType;
import org.embeddedt.embeddium.impl.gl.tessellation.GlPrimitiveType;
import org.embeddedt.embeddium.impl.gl.tessellation.GlTessellation;
import org.embeddedt.embeddium.impl.model.quad.properties.ModelQuadFacing;
import org.embeddedt.embeddium.impl.render.chunk.data.SectionRenderDataUnsafe;
import org.embeddedt.embeddium.impl.render.chunk.multidraw.MultiDrawEmitter;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;
import xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@RecordComponents(value={@RecordComponents.Value(name="batch", type=MultiDrawBatch.class)})
public final class IndividualDrawEmitter
extends J_L_Record
implements MultiDrawEmitter {
    private final MultiDrawBatch batch;

    public IndividualDrawEmitter() {
        this(new MultiDrawBatch(MAX_COMMAND_COUNT));
    }

    public IndividualDrawEmitter(MultiDrawBatch batch) {
        this.batch = batch;
    }

    @Override
    public void addDrawCommands(long pMeshData, int mask, int indexPointerMask) {
        MultiDrawBatch batch = this.batch;
        long pBaseVertex = batch.pBaseVertex;
        long pElementCount = batch.pElementCount;
        long pElementPointer = batch.pElementPointer;
        int size = batch.size;
        for (int facing = 0; facing < ModelQuadFacing.COUNT; ++facing) {
            LWJGLServiceProvider.LWJGL.memPutInt(pBaseVertex + (long)(size << 2), SectionRenderDataUnsafe.getVertexOffset(pMeshData, facing));
            LWJGLServiceProvider.LWJGL.memPutInt(pElementCount + (long)(size << 2), SectionRenderDataUnsafe.getElementCount(pMeshData, facing));
            LWJGLServiceProvider.LWJGL.memPutAddress(pElementPointer + (long)(size << 3), SectionRenderDataUnsafe.getIndexOffset(pMeshData, facing) & indexPointerMask);
            size += mask >> facing & 1;
        }
        batch.size = size;
    }

    @Override
    public void executeBatch(CommandList commandList, GlTessellation tessellation, GlPrimitiveType primitiveType) {
        try (DrawCommandList drawCommandList = commandList.beginTessellating(tessellation);){
            int mode = primitiveType.getId();
            int type = GlIndexType.UNSIGNED_INT.getFormatId();
            for (int i = 0; i < this.batch.size; ++i) {
                int count = LWJGLServiceProvider.LWJGL.memGetInt(this.batch.pElementCount + (long)i * 4L);
                if (count <= 0) continue;
                LWJGLServiceProvider.LWJGL.glDrawElementsBaseVertex(mode, count, type, LWJGLServiceProvider.LWJGL.memGetAddress(this.batch.pElementPointer + (long)i * (long)LWJGLServiceProvider.POINTER_SIZE), LWJGLServiceProvider.LWJGL.memGetInt(this.batch.pBaseVertex + (long)i * 4L));
            }
        }
    }

    @Override
    public int getIndexBufferSize() {
        return this.batch.getIndexBufferSize();
    }

    @Override
    public boolean isEmpty() {
        return this.batch.isEmpty();
    }

    @Override
    public void clear() {
        this.batch.clear();
    }

    @Override
    public void delete() {
        this.batch.delete();
    }

    public final String toString() {
        return IndividualDrawEmitter.jvmdowngrader$toString$toString(this);
    }

    public final int hashCode() {
        return IndividualDrawEmitter.jvmdowngrader$hashCode$hashCode(this);
    }

    public final boolean equals(Object o) {
        return IndividualDrawEmitter.jvmdowngrader$equals$equals(this, o);
    }

    public MultiDrawBatch batch() {
        return this.batch;
    }

    private static /* synthetic */ String jvmdowngrader$toString$toString(IndividualDrawEmitter individualDrawEmitter) {
        IndividualDrawEmitter individualDrawEmitter2 = individualDrawEmitter;
        return "IndividualDrawEmitter[" + "batch=" + individualDrawEmitter.batch + "]";
    }

    private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(IndividualDrawEmitter individualDrawEmitter) {
        Object[] objectArray = new Object[]{individualDrawEmitter.batch};
        return Arrays.hashCode(objectArray);
    }

    private static /* synthetic */ boolean jvmdowngrader$equals$equals(IndividualDrawEmitter individualDrawEmitter, Object object) {
        if (individualDrawEmitter == object) {
            return true;
        }
        if (object != null && object instanceof IndividualDrawEmitter) {
            IndividualDrawEmitter individualDrawEmitter2 = (IndividualDrawEmitter)object;
            if (Objects.equals(individualDrawEmitter.batch, individualDrawEmitter2.batch)) {
                return true;
            }
        }
        return false;
    }
}

