/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.rendering.celeritas;

import com.gtnewhorizons.angelica.AngelicaMod;
import com.gtnewhorizons.angelica.mixins.interfaces.RenderSectionManagerAccessor;
import com.gtnewhorizons.angelica.rendering.AngelicaRenderQueue;
import com.gtnewhorizons.angelica.rendering.celeritas.AngelicaChunkBuildContext;
import com.gtnewhorizons.angelica.rendering.celeritas.AngelicaChunkRenderer;
import com.gtnewhorizons.angelica.rendering.celeritas.AngelicaRenderPassConfiguration;
import com.gtnewhorizons.angelica.rendering.celeritas.SpriteExtension;
import com.gtnewhorizons.angelica.rendering.celeritas.api.IrisShaderProviderHolder;
import com.gtnewhorizons.angelica.rendering.celeritas.threading.ChunkTaskProvider;
import com.gtnewhorizons.angelica.rendering.celeritas.threading.ChunkTaskRegistry;
import com.gtnewhorizons.angelica.rendering.celeritas.world.cloned.ClonedChunkSectionCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import org.embeddedt.embeddium.impl.gl.device.CommandList;
import org.embeddedt.embeddium.impl.render.chunk.ChunkRenderMatrices;
import org.embeddedt.embeddium.impl.render.chunk.RenderPassConfiguration;
import org.embeddedt.embeddium.impl.render.chunk.RenderSection;
import org.embeddedt.embeddium.impl.render.chunk.RenderSectionManager;
import org.embeddedt.embeddium.impl.render.chunk.compile.ChunkBuildOutput;
import org.embeddedt.embeddium.impl.render.chunk.compile.executor.ChunkBuilder;
import org.embeddedt.embeddium.impl.render.chunk.compile.tasks.ChunkBuilderTask;
import org.embeddedt.embeddium.impl.render.chunk.lists.SectionTicker;
import org.embeddedt.embeddium.impl.render.chunk.occlusion.AsyncOcclusionMode;
import org.embeddedt.embeddium.impl.render.chunk.sprite.GenericSectionSpriteTicker;
import org.embeddedt.embeddium.impl.render.chunk.terrain.TerrainRenderPass;
import org.embeddedt.embeddium.impl.render.chunk.vertex.format.ChunkVertexType;
import org.embeddedt.embeddium.impl.render.viewport.CameraTransform;
import org.embeddedt.embeddium.impl.render.viewport.Viewport;
import org.embeddedt.embeddium.impl.util.PositionUtil;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3ic;

public class AngelicaRenderSectionManager
extends RenderSectionManager {
    private boolean initialCameraSectionReady = false;
    private final WorldClient world;
    private final ClonedChunkSectionCache sectionCache;
    private final ChunkTaskProvider taskProvider;

    public AngelicaRenderSectionManager(RenderPassConfiguration<?> configuration, WorldClient world, int renderDistance, CommandList commandList, int minSection, int maxSection, int requestedThreads, ChunkTaskProvider taskProvider) {
        super(configuration, () -> new AngelicaChunkBuildContext(configuration, world), AngelicaChunkRenderer::new, renderDistance, commandList, minSection, maxSection, requestedThreads, true);
        this.world = world;
        this.sectionCache = new ClonedChunkSectionCache((World)world);
        this.taskProvider = taskProvider;
    }

    public static AngelicaRenderSectionManager create(ChunkVertexType vertexType, WorldClient world, int renderDistance, CommandList commandList) {
        ChunkTaskProvider provider = ChunkTaskRegistry.getActiveProvider();
        return new AngelicaRenderSectionManager(AngelicaRenderPassConfiguration.build(vertexType), world, renderDistance, commandList, 0, 16, provider.threadCount(), provider);
    }

    public void setCameraPosition(double x, double y, double z) {
        this.cameraPosition.set(x, y, z);
    }

    private boolean isChunkNotLoaded(int chunkX, int chunkZ) {
        return this.world.func_72964_e(chunkX, chunkZ).func_76621_g();
    }

    @Override
    public void onSectionAdded(int x, int y, int z) {
        super.onSectionAdded(x, y, z);
        if (this.isChunkNotLoaded(x, z)) {
            this.renderListManager.updateVisibilityData(x, y, z, 0L);
        }
    }

    @Override
    public void update(Viewport positionedViewport, int frame, boolean spectator) {
        if (!this.isInShadowPass() && !this.initialCameraSectionReady) {
            Vector3ic origin = positionedViewport.getChunkCoord();
            long key = PositionUtil.packSection(origin.x(), origin.y(), origin.z());
            if (!((RenderSectionManagerAccessor)((Object)this)).angelica$getSectionByPosition().containsKey(key)) {
                return;
            }
            this.initialCameraSectionReady = true;
        }
        super.update(positionedViewport, frame, spectator);
    }

    @Override
    protected AsyncOcclusionMode getAsyncOcclusionMode() {
        return AngelicaMod.options().performance.asyncOcclusionMode;
    }

    @Override
    protected boolean shouldRespectUpdateTaskQueueSizeLimit() {
        return true;
    }

    @Override
    protected boolean useFogOcclusion() {
        return AngelicaMod.options().performance.useFogOcclusion && !IrisShaderProviderHolder.isActive();
    }

    @Override
    protected boolean isDebugInfoShown() {
        return Minecraft.func_71410_x().field_71474_y.field_74330_P;
    }

    @Override
    protected boolean shouldUseOcclusionCulling(Viewport positionedViewport, boolean spectator) {
        Vector3ic camBlockPos;
        if (spectator && this.world.func_147439_a((camBlockPos = positionedViewport.getBlockCoord()).x(), camBlockPos.y(), camBlockPos.z()).func_149662_c()) {
            return false;
        }
        return AngelicaMod.options().performance.useOcclusionCulling;
    }

    @Override
    public boolean isSectionVisuallyEmpty(int x, int y, int z) {
        Chunk chunk = this.world.func_72964_e(x, z);
        if (chunk.func_76621_g()) {
            return true;
        }
        ExtendedBlockStorage[] array = chunk.func_76587_i();
        if (y < 0 || y >= array.length) {
            return true;
        }
        return array[y] == null || array[y].func_76663_a();
    }

    @Override
    @Nullable
    protected ChunkBuilderTask<ChunkBuildOutput> createRebuildTask(RenderSection render, int frame) {
        if (this.isSectionVisuallyEmpty(render.getChunkX(), render.getChunkY(), render.getChunkZ())) {
            return null;
        }
        return this.taskProvider.createRebuildTask(render, frame, this.cameraPosition, this.sectionCache);
    }

    @Override
    protected void invalidateCachedSectionData(RenderSection section) {
        super.invalidateCachedSectionData(section);
        this.sectionCache.invalidate(section.getChunkX(), section.getChunkY(), section.getChunkZ());
    }

    @Override
    public void updateChunks(boolean updateImmediately) {
        this.sectionCache.cleanup();
        super.updateChunks(updateImmediately);
    }

    @Override
    protected boolean allowImportantRebuilds() {
        return !AngelicaMod.options().performance.alwaysDeferChunkUpdates;
    }

    @Override
    @Nullable
    protected SectionTicker createSectionTicker() {
        return new GenericSectionSpriteTicker<TextureAtlasSprite>(AngelicaRenderSectionManager::markSpriteActive);
    }

    private static void markSpriteActive(TextureAtlasSprite sprite) {
        ((SpriteExtension)sprite).celeritas$markActive();
    }

    @Override
    public boolean isInShadowPass() {
        return IrisShaderProviderHolder.isShadowPass();
    }

    @Override
    public Collection<String> getDebugStrings() {
        ArrayList<String> list = new ArrayList<String>(super.getDebugStrings());
        ChunkBuilder builder = this.getBuilder();
        int busyThreads = builder.getBusyThreadCount();
        int totalThreads = builder.getTotalThreadCount();
        if (totalThreads > 0) {
            list.add(String.format("Chunk Workers: %d/%d busy", busyThreads, totalThreads));
        } else {
            list.add("Chunk Workers: single-threaded");
        }
        int queueDepth = AngelicaRenderQueue.getQueueDepth();
        int tasksRan = AngelicaRenderQueue.getLastFrameTasksRan();
        double mtTimeMs = (double)AngelicaRenderQueue.getLastFrameTimeNs() / 1000000.0;
        list.add(String.format("MT Queue: %d, ran %d (%.1fms)", queueDepth, tasksRan, mtTimeMs));
        return list;
    }

    @Override
    public void renderLayer(ChunkRenderMatrices matrices, TerrainRenderPass pass, CameraTransform occlusionCamera, CameraTransform camera) {
        if (IrisShaderProviderHolder.isShadowPass()) {
            this.finishAllGraphUpdates();
        }
        super.renderLayer(matrices, pass, occlusionCamera, camera);
    }

    @Override
    public void managedBlock(BooleanSupplier isDone) {
        RenderSectionManagerAccessor accessor = (RenderSectionManagerAccessor)((Object)this);
        while (!isDone.getAsBoolean()) {
            Runnable task = accessor.angelica$getAsyncSubmittedTasks().poll();
            if (task != null) {
                task.run();
                continue;
            }
            if (AngelicaRenderQueue.processTasks(1) > 0) continue;
            LockSupport.parkNanos("Wait", 100000L);
        }
    }
}

