/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.rendering.celeritas;

import com.gtnewhorizons.angelica.rendering.celeritas.AngelicaChunkBuildContext;
import com.gtnewhorizons.angelica.rendering.celeritas.AngelicaChunkBuilderMeshingTask;
import com.gtnewhorizons.angelica.rendering.celeritas.SmoothBiomeColorCache;
import com.gtnewhorizons.angelica.rendering.celeritas.WorldClientExtension;
import com.gtnewhorizons.angelica.rendering.celeritas.threading.RenderPassHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.embeddedt.embeddium.impl.render.chunk.RenderSection;
import org.embeddedt.embeddium.impl.render.chunk.compile.ChunkBuildContext;
import org.embeddedt.embeddium.impl.render.chunk.compile.ChunkBuildOutput;
import org.embeddedt.embeddium.impl.util.position.SectionPos;
import org.embeddedt.embeddium.impl.util.task.CancellationToken;
import org.joml.Vector3d;

public class AngelicaMainThreadMeshingTask
extends AngelicaChunkBuilderMeshingTask {
    private IBlockAccess blockAccess;
    private SmoothBiomeColorCache biomeColorCache;

    public AngelicaMainThreadMeshingTask(RenderSection render, int time, Vector3d camera) {
        super(render, time, camera);
        this.initBlockAccess();
    }

    private void initBlockAccess() {
        int minX = this.render.getOriginX();
        int minY = this.render.getOriginY();
        int minZ = this.render.getOriginZ();
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        this.blockAccess = new ChunkCache((World)world, minX - 1, minY - 1, minZ - 1, minX + 17, minY + 17, minZ + 17, 1);
        this.biomeColorCache = ((WorldClientExtension)world).celeritas$getSmoothBiomeColorCache();
        this.biomeColorCache.update(new SectionPos(this.render.getChunkX(), this.render.getChunkY(), this.render.getChunkZ()));
    }

    @Override
    public ChunkBuildOutput execute(ChunkBuildContext context, CancellationToken cancellationToken) {
        AngelicaChunkBuildContext buildContext = (AngelicaChunkBuildContext)context;
        int minX = this.render.getOriginX();
        int minY = this.render.getOriginY();
        int minZ = this.render.getOriginZ();
        buildContext.setupLightPipeline(this.blockAccess, minX, minY, minZ);
        return super.execute(context, cancellationToken);
    }

    @Override
    protected Tessellator getTessellator() {
        return Tessellator.field_78398_a;
    }

    @Override
    protected void setRenderPass(int pass) {
        RenderPassHelper.setWorldRenderPass(pass);
    }

    @Override
    protected IBlockAccess getBlockAccess() {
        return this.blockAccess;
    }

    @Override
    protected SmoothBiomeColorCache getBiomeColorCache() {
        return this.biomeColorCache;
    }
}

