/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.rendering.celeritas;

import com.gtnewhorizons.angelica.config.AngelicaConfig;
import com.gtnewhorizons.angelica.mixins.interfaces.ChunkTrackerAccessor;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import org.embeddedt.embeddium.impl.render.chunk.map.ChunkTracker;
import org.embeddedt.embeddium.impl.util.PositionUtil;

public class AngelicaChunkTracker
extends ChunkTracker {
    private final LongOpenHashSet chunkReadyForced = new LongOpenHashSet();

    private ChunkTrackerAccessor self() {
        return (ChunkTrackerAccessor)((Object)this);
    }

    @Override
    public void onChunkStatusAdded(int x, int z, int flags) {
        int cur;
        long key = PositionUtil.packChunk(x, z);
        int prev = this.self().angelica$getChunkStatus().get(key);
        if (prev == (cur = prev | flags)) {
            return;
        }
        this.self().angelica$getChunkStatus().put(key, cur);
        this.updateNeighbors(x, z);
    }

    @Override
    public void onChunkStatusRemoved(int x, int z, int flags) {
        int cur;
        long key = PositionUtil.packChunk(x, z);
        int prev = this.self().angelica$getChunkStatus().get(key);
        if (prev == (cur = prev & ~flags)) {
            return;
        }
        if (cur == this.self().angelica$getChunkStatus().defaultReturnValue()) {
            this.self().angelica$getChunkStatus().remove(key);
        } else {
            this.self().angelica$getChunkStatus().put(key, cur);
        }
        this.updateNeighbors(x, z);
    }

    private void updateNeighbors(int x, int z) {
        for (int ox = -1; ox <= 1; ++ox) {
            for (int oz = -1; oz <= 1; ++oz) {
                this.updateMerged(ox + x, oz + z);
            }
        }
    }

    private void updateMerged(int x, int z) {
        long key = PositionUtil.packChunk(x, z);
        int selfFlags = this.self().angelica$getChunkStatus().get(key);
        if (selfFlags != 3) {
            boolean wasReady = this.self().angelica$getChunkReady().remove(key) | this.chunkReadyForced.remove(key);
            if (wasReady && !this.self().angelica$getLoadQueue().remove(key)) {
                this.self().angelica$getUnloadQueue().add(key);
            }
            return;
        }
        int mergedFlags = selfFlags;
        for (int ox = -1; ox <= 1; ++ox) {
            for (int oz = -1; oz <= 1; ++oz) {
                mergedFlags &= this.self().angelica$getChunkStatus().get(PositionUtil.packChunk(ox + x, oz + z));
            }
        }
        if (mergedFlags == 3) {
            if ((this.chunkReadyForced.add(key) || this.self().angelica$getChunkReady().add(key)) && !this.self().angelica$getUnloadQueue().remove(key)) {
                this.self().angelica$getLoadQueue().add(key);
            }
        } else if ((this.chunkReadyForced.add(key) || this.self().angelica$getChunkReady().remove(key)) && !this.self().angelica$getUnloadQueue().remove(key)) {
            this.self().angelica$getLoadQueue().add(key);
        }
    }

    @Override
    public LongCollection getReadyChunks() {
        if (AngelicaConfig.useVanillaChunkTracking) {
            LongOpenHashSet combined = new LongOpenHashSet((LongCollection)this.self().angelica$getChunkReady());
            combined.addAll((LongCollection)this.chunkReadyForced);
            return LongSets.unmodifiable((LongSet)combined);
        }
        return LongSets.unmodifiable((LongSet)this.self().angelica$getChunkReady());
    }

    @Override
    public void forEachEvent(ChunkTracker.ChunkEventHandler loadEventHandler, ChunkTracker.ChunkEventHandler unloadEventHandler) {
        ChunkTracker.forEachChunk((LongCollection)this.self().angelica$getUnloadQueue(), unloadEventHandler);
        this.self().angelica$getUnloadQueue().clear();
        ChunkTracker.forEachChunk((LongCollection)this.self().angelica$getLoadQueue(), loadEventHandler);
        this.self().angelica$getLoadQueue().clear();
    }
}

