/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.rendering.celeritas;

import com.gtnewhorizons.angelica.AngelicaMod;
import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.rendering.celeritas.IndividualDrawEmitter;
import com.gtnewhorizons.angelica.rendering.celeritas.api.IrisShaderProvider;
import com.gtnewhorizons.angelica.rendering.celeritas.api.IrisShaderProviderHolder;
import me.jellysquid.mods.sodium.client.gui.options.named.MultiDrawMode;
import org.embeddedt.embeddium.impl.gl.device.RenderDevice;
import org.embeddedt.embeddium.impl.gl.shader.GlProgram;
import org.embeddedt.embeddium.impl.render.chunk.DefaultChunkRenderer;
import org.embeddedt.embeddium.impl.render.chunk.RenderPassConfiguration;
import org.embeddedt.embeddium.impl.render.chunk.multidraw.DirectMultiDrawEmitter;
import org.embeddedt.embeddium.impl.render.chunk.multidraw.IndirectMultiDrawEmitter;
import org.embeddedt.embeddium.impl.render.chunk.multidraw.MultiDrawEmitter;
import org.embeddedt.embeddium.impl.render.chunk.shader.ChunkShaderInterface;
import org.embeddedt.embeddium.impl.render.chunk.shader.ChunkShaderTextureSlot;
import org.embeddedt.embeddium.impl.render.chunk.terrain.TerrainRenderPass;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j21.stub.java_base.J_L_MatchException;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={1.class})
class AngelicaChunkRenderer
extends DefaultChunkRenderer {
    private GlProgram<? extends ChunkShaderInterface> irisProgram;
    private boolean usingIrisProgram;

    public AngelicaChunkRenderer(RenderDevice device, RenderPassConfiguration<?> renderPassConfiguration) {
        super(device, renderPassConfiguration, AngelicaChunkRenderer.createEmitter());
        IrisShaderProvider provider = IrisShaderProviderHolder.getProvider();
        if (provider != null) {
            provider.setRenderPassConfiguration(renderPassConfiguration);
        }
    }

    private static MultiDrawEmitter createEmitter() {
        MultiDrawEmitter multiDrawEmitter;
        MultiDrawMode mode = AngelicaMod.options().advanced.multiDrawMode;
        if (mode == MultiDrawMode.INDIRECT) {
            boolean supported;
            boolean bl = supported = GLStateManager.capabilities != null && (GLStateManager.capabilities.OpenGL43 || GLStateManager.capabilities.GL_ARB_multi_draw_indirect);
            if (!supported) {
                AngelicaMod.LOGGER.warn("Indirect multi-draw not supported (requires GL 4.3 / ARB_multi_draw_indirect), falling back to Direct");
                mode = MultiDrawMode.DIRECT;
            }
        }
        switch (mode) {
            default: {
                throw new J_L_MatchException(null, null);
            }
            case DIRECT: {
                multiDrawEmitter = new DirectMultiDrawEmitter();
                break;
            }
            case INDIRECT: {
                multiDrawEmitter = new IndirectMultiDrawEmitter();
                break;
            }
            case INDIVIDUAL: {
                multiDrawEmitter = new IndividualDrawEmitter();
            }
        }
        return multiDrawEmitter;
    }

    @Override
    protected void begin(TerrainRenderPass pass) {
        GlProgram<? extends ChunkShaderInterface> override;
        IrisShaderProvider provider = IrisShaderProviderHolder.getProvider();
        if (provider != null && provider.isShadersEnabled() && (override = provider.getShaderOverride(pass)) != null) {
            pass.startDrawing();
            override.bind();
            override.getInterface().setupState(pass);
            this.activeProgram = override;
            this.irisProgram = override;
            this.usingIrisProgram = true;
            return;
        }
        this.usingIrisProgram = false;
        this.irisProgram = null;
        super.begin(pass);
    }

    @Override
    protected void end(TerrainRenderPass pass) {
        if (this.usingIrisProgram && this.irisProgram != null) {
            this.irisProgram.getInterface().restoreState();
            this.irisProgram.unbind();
            this.irisProgram = null;
            this.usingIrisProgram = false;
            this.activeProgram = null;
            pass.endDrawing();
            return;
        }
        super.end(pass);
    }

    @Override
    protected boolean useBlockFaceCulling() {
        return IrisShaderProviderHolder.shouldUseFaceCulling();
    }

    @Override
    protected void configureShaderInterface(ChunkShaderInterface shader) {
        if (!this.usingIrisProgram) {
            shader.setTextureSlot(ChunkShaderTextureSlot.BLOCK, 0);
            shader.setTextureSlot(ChunkShaderTextureSlot.LIGHT, 1);
        }
    }
}

