/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.rendering.celeritas;

import com.gtnewhorizon.gtnhlib.blockpos.BlockPos;
import com.gtnewhorizons.angelica.rendering.AngelicaRenderQueue;
import com.gtnewhorizons.angelica.rendering.celeritas.AngelicaChunkBuildContext;
import com.gtnewhorizons.angelica.rendering.celeritas.AngelicaRenderPassConfiguration;
import com.gtnewhorizons.angelica.rendering.celeritas.BlockRenderLayer;
import com.gtnewhorizons.angelica.rendering.celeritas.CeleritasDebug;
import com.gtnewhorizons.angelica.rendering.celeritas.SmoothBiomeColorCache;
import com.gtnewhorizons.angelica.rendering.celeritas.api.IrisShaderProvider;
import com.gtnewhorizons.angelica.rendering.celeritas.api.IrisShaderProviderHolder;
import com.gtnewhorizons.angelica.rendering.celeritas.iris.BlockRenderContext;
import com.gtnewhorizons.angelica.rendering.celeritas.iris.ContextAwareChunkVertexEncoder;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ReportedException;
import net.minecraft.world.IBlockAccess;
import org.embeddedt.embeddium.impl.render.chunk.RenderSection;
import org.embeddedt.embeddium.impl.render.chunk.compile.ChunkBuildBuffers;
import org.embeddedt.embeddium.impl.render.chunk.compile.ChunkBuildContext;
import org.embeddedt.embeddium.impl.render.chunk.compile.ChunkBuildOutput;
import org.embeddedt.embeddium.impl.render.chunk.compile.tasks.ChunkBuilderTask;
import org.embeddedt.embeddium.impl.render.chunk.data.BuiltSectionMeshParts;
import org.embeddedt.embeddium.impl.render.chunk.data.MinecraftBuiltRenderSectionData;
import org.embeddedt.embeddium.impl.render.chunk.occlusion.SectionVisibilityBuilder;
import org.embeddedt.embeddium.impl.render.chunk.terrain.TerrainRenderPass;
import org.embeddedt.embeddium.impl.render.chunk.vertex.format.ChunkVertexEncoder;
import org.embeddedt.embeddium.impl.util.task.CancellationToken;
import org.joml.Vector3d;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;
import xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={DeferredBlock.class})
public abstract class AngelicaChunkBuilderMeshingTask
extends ChunkBuilderTask<ChunkBuildOutput> {
    protected final RenderSection render;
    protected final int buildTime;
    protected final Vector3d camera;
    private static final long DEFERRED_BLOCK_TIMEOUT_MS = 10000L;
    private static final int MAX_RETRIES = 2;

    public AngelicaChunkBuilderMeshingTask(RenderSection render, int time, Vector3d camera) {
        this.render = render;
        this.buildTime = time;
        this.camera = camera;
    }

    protected abstract Tessellator getTessellator();

    protected abstract void setRenderPass(int var1);

    protected abstract IBlockAccess getBlockAccess();

    protected abstract SmoothBiomeColorCache getBiomeColorCache();

    protected boolean isThreaded() {
        return false;
    }

    protected boolean canRenderOffThread(Block block) {
        return false;
    }

    protected void onEnterExecute() {
    }

    protected void onExitExecute() {
    }

    protected void addExtraCrashInfo(CrashReportCategory category) {
    }

    @Override
    public ChunkBuildOutput execute(ChunkBuildContext context, CancellationToken cancellationToken) {
        AngelicaChunkBuildContext buildContext = (AngelicaChunkBuildContext)context;
        MinecraftBuiltRenderSectionData renderData = new MinecraftBuiltRenderSectionData();
        SectionVisibilityBuilder occluder = new SectionVisibilityBuilder();
        ChunkBuildBuffers buffers = buildContext.buffers;
        buffers.init(renderData, this.render.getSectionIndex());
        int minX = this.render.getOriginX();
        int minY = this.render.getOriginY();
        int minZ = this.render.getOriginZ();
        int maxX = minX + 16;
        int maxY = minY + 16;
        int maxZ = minZ + 16;
        buildContext.setupDynamicLights(minX, minY, minZ);
        BlockPos blockPos = new BlockPos(minX, minY, minZ);
        IBlockAccess region = this.getBlockAccess();
        SmoothBiomeColorCache biomeColorCache = this.getBiomeColorCache();
        this.onEnterExecute();
        Tessellator tessellator = this.getTessellator();
        try {
            Reference2ReferenceMap<TerrainRenderPass, BuiltSectionMeshParts> meshes;
            tessellator.func_78373_b((double)(-minX), (double)(-minY), (double)(-minZ));
            SmoothBiomeColorCache.setActiveCache(biomeColorCache);
            IrisShaderProvider provider = IrisShaderProviderHolder.getProvider();
            Map<Block, BlockRenderLayer> blockTypeIds = provider != null ? provider.getBlockTypeIds() : null;
            BlockRenderContext blockRenderContext = buildContext.getBlockRenderContext();
            boolean threaded = this.isThreaded();
            ArrayList<DeferredBlock> deferredBlocks = threaded ? new ArrayList<DeferredBlock>() : null;
            RenderBlocks renderBlocks = new RenderBlocks(region);
            for (int y = minY; y < maxY; ++y) {
                if (cancellationToken.isCancelled()) {
                    ChunkBuildOutput chunkBuildOutput = null;
                    return chunkBuildOutput;
                }
                for (int z = minZ; z < maxZ; ++z) {
                    for (int x = minX; x < maxX; ++x) {
                        TileEntity tileEntity;
                        blockPos.set(x, y, z);
                        Block block = region.func_147439_a(x, y, z);
                        if (block == Blocks.field_150350_a) continue;
                        int meta = region.func_72805_g(x, y, z);
                        if (block.hasTileEntity(meta) && TileEntityRendererDispatcher.field_147556_a.func_147545_a(tileEntity = region.func_147438_o(x, y, z))) {
                            renderData.globalBlockEntities.add(tileEntity);
                        }
                        boolean canRenderOffThread = !threaded || this.canRenderOffThread(block);
                        BlockRenderLayer override = blockTypeIds != null ? blockTypeIds.get(block) : null;
                        for (int pass = 0; pass < 2; ++pass) {
                            boolean isShaderPackOverride;
                            boolean canRender;
                            org.embeddedt.embeddium.impl.render.chunk.terrain.material.Material materialOverride = null;
                            if (override != null) {
                                boolean bl = canRender = pass == override.toVanillaPass();
                                if (canRender) {
                                    materialOverride = buffers.getRenderPassConfiguration().getMaterialForRenderType((Object)override);
                                }
                            } else {
                                canRender = block.canRenderInPass(pass);
                            }
                            if (!canRender) continue;
                            boolean bl = isShaderPackOverride = materialOverride != null;
                            if (!canRenderOffThread) {
                                deferredBlocks.add(new DeferredBlock(x, y, z, block, meta, pass, materialOverride, isShaderPackOverride));
                                continue;
                            }
                            this.renderBlock(block, meta, x, y, z, pass, tessellator, renderBlocks, buffers, buildContext, blockRenderContext, minX, minY, minZ, materialOverride, isShaderPackOverride);
                        }
                        if (!block.func_149662_c()) continue;
                        occluder.markOpaque(x, y, z);
                    }
                }
            }
            if (deferredBlocks != null && !deferredBlocks.isEmpty()) {
                this.processDeferredBlocks(deferredBlocks, buildContext, buffers, region, minX, minY, minZ);
            }
            if (!(meshes = BuiltSectionMeshParts.groupFromBuildBuffers(buffers, (float)this.camera.x - (float)minX, (float)this.camera.y - (float)minY, (float)this.camera.z - (float)minZ)).isEmpty()) {
                renderData.hasBlockGeometry = true;
            }
            renderData.visibilityData = occluder.computeVisibilityEncoding();
            SmoothBiomeColorCache.clearActiveCache();
            tessellator.func_78373_b(0.0, 0.0, 0.0);
            CeleritasDebug.incrementChunkUpdateCounter();
            ChunkBuildOutput chunkBuildOutput = new ChunkBuildOutput(this.render, renderData, meshes, this.buildTime);
            return chunkBuildOutput;
        }
        catch (ReportedException ex) {
            throw this.fillCrashInfo(ex.func_71575_a(), region, blockPos);
        }
        catch (Throwable ex) {
            throw this.fillCrashInfo(CrashReport.func_85055_a((Throwable)ex, (String)"Encountered exception while building chunk meshes"), region, blockPos);
        }
        finally {
            SmoothBiomeColorCache.clearActiveCache();
            this.onExitExecute();
        }
    }

    protected void renderBlock(Block block, int metadata, int x, int y, int z, int pass, Tessellator tessellator, RenderBlocks renderBlocks, ChunkBuildBuffers buffers, AngelicaChunkBuildContext buildContext, BlockRenderContext blockRenderContext, int originX, int originY, int originZ, org.embeddedt.embeddium.impl.render.chunk.terrain.material.Material materialOverride, boolean isShaderPackOverride) {
        boolean isFluid;
        Material blockMaterial = block.func_149688_o();
        boolean bl = isFluid = blockMaterial == Material.field_151586_h || blockMaterial == Material.field_151587_i;
        org.embeddedt.embeddium.impl.render.chunk.terrain.material.Material passMaterial = materialOverride != null ? materialOverride : (blockMaterial == Material.field_151587_i ? AngelicaRenderPassConfiguration.SOLID_MATERIAL : buffers.getRenderPassConfiguration().getMaterialForRenderType((Object)BlockRenderLayer.fromVanillaPass(pass)));
        ChunkVertexEncoder encoder = buffers.get(passMaterial).getEncoder();
        ContextAwareChunkVertexEncoder contextEncoder = encoder instanceof ContextAwareChunkVertexEncoder ? (ContextAwareChunkVertexEncoder)encoder : null;
        blockRenderContext.localPosX = x & 0xF;
        blockRenderContext.localPosY = y & 0xF;
        blockRenderContext.localPosZ = z & 0xF;
        if (contextEncoder != null) {
            byte lightValue = (byte)block.func_149750_m();
            if (isFluid) {
                contextEncoder.prepareToRenderFluid(blockRenderContext, block, lightValue);
            } else {
                contextEncoder.prepareToRenderBlock(blockRenderContext, block, metadata, (short)-1, lightValue);
            }
        }
        this.setRenderPass(pass);
        block.canRenderInPass(pass);
        tessellator.func_78382_b();
        renderBlocks.func_147805_b(block, x, y, z);
        int vanillaRenderId = block.func_149645_b();
        boolean blockAllowsSmoothLighting = Minecraft.func_71379_u() && block.func_149750_m() == 0 && vanillaRenderId != 1 && vanillaRenderId != 40;
        buildContext.copyRawBuffer(tessellator.field_78405_h, tessellator.field_78406_i, buffers, passMaterial, isShaderPackOverride, blockAllowsSmoothLighting);
        tessellator.func_78379_d();
        tessellator.field_78415_z = false;
        if (contextEncoder != null) {
            contextEncoder.finishRenderingBlock();
        }
    }

    private void processDeferredBlocks(List<DeferredBlock> deferredBlocks, AngelicaChunkBuildContext buildContext, ChunkBuildBuffers buffers, IBlockAccess region, int minX, int minY, int minZ) {
        BlockRenderContext blockRenderContext = buildContext.getBlockRenderContext();
        CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
            RenderBlocks mainThreadRenderBlocks = new RenderBlocks(region);
            Tessellator mainTessellator = Tessellator.field_78398_a;
            mainTessellator.func_78373_b((double)(-minX), (double)(-minY), (double)(-minZ));
            for (DeferredBlock deferred : deferredBlocks) {
                this.renderBlock(deferred.block(), deferred.meta(), deferred.x(), deferred.y(), deferred.z(), deferred.pass(), mainTessellator, mainThreadRenderBlocks, buffers, buildContext, blockRenderContext, minX, minY, minZ, deferred.materialOverride(), deferred.isShaderPackOverride());
            }
            mainTessellator.func_78373_b(0.0, 0.0, 0.0);
        }, AngelicaRenderQueue.executor());
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        for (int retries = 0; retries < 2; ++retries) {
            try {
                future.get(10000L, TimeUnit.MILLISECONDS);
                return;
            }
            catch (TimeoutException e) {
                if (!Thread.currentThread().isInterrupted()) continue;
                return;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            catch (ExecutionException e) {
                throw new RuntimeException("Error during main thread deferred block rendering", e);
            }
        }
    }

    private ReportedException fillCrashInfo(CrashReport report, IBlockAccess slice, BlockPos pos) {
        CrashReportCategory crashReportSection = report.func_85058_a("Block being rendered");
        Block block = Blocks.field_150350_a;
        int meta = 0;
        try {
            block = slice.func_147439_a(pos.x, pos.y, pos.z);
            meta = slice.func_72805_g(pos.x, pos.y, pos.z);
        }
        catch (Exception exception) {
            // empty catch block
        }
        crashReportSection.func_71507_a("Block", (Object)block);
        crashReportSection.func_71507_a("Block location", (Object)String.format("World: (%d,%d,%d)", pos.x, pos.y, pos.z));
        crashReportSection.func_71507_a("Block meta", (Object)meta);
        crashReportSection.func_71507_a("Chunk section", (Object)this.render);
        this.addExtraCrashInfo(crashReportSection);
        return new ReportedException(report);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @RecordComponents(value={@RecordComponents.Value(name="x", type=int.class), @RecordComponents.Value(name="y", type=int.class), @RecordComponents.Value(name="z", type=int.class), @RecordComponents.Value(name="block", type=Block.class), @RecordComponents.Value(name="meta", type=int.class), @RecordComponents.Value(name="pass", type=int.class), @RecordComponents.Value(name="materialOverride", type=org.embeddedt.embeddium.impl.render.chunk.terrain.material.Material.class), @RecordComponents.Value(name="isShaderPackOverride", type=boolean.class)})
    @NestHost(value=AngelicaChunkBuilderMeshingTask.class)
    protected static final class DeferredBlock
    extends J_L_Record {
        private final int x;
        private final int y;
        private final int z;
        private final Block block;
        private final int meta;
        private final int pass;
        private final org.embeddedt.embeddium.impl.render.chunk.terrain.material.Material materialOverride;
        private final boolean isShaderPackOverride;

        protected DeferredBlock(int x, int y, int z, Block block, int meta, int pass, org.embeddedt.embeddium.impl.render.chunk.terrain.material.Material materialOverride, boolean isShaderPackOverride) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.block = block;
            this.meta = meta;
            this.pass = pass;
            this.materialOverride = materialOverride;
            this.isShaderPackOverride = isShaderPackOverride;
        }

        public final String toString() {
            return DeferredBlock.jvmdowngrader$toString$toString(this);
        }

        public final int hashCode() {
            return DeferredBlock.jvmdowngrader$hashCode$hashCode(this);
        }

        public final boolean equals(Object o) {
            return DeferredBlock.jvmdowngrader$equals$equals(this, o);
        }

        public int x() {
            return this.x;
        }

        public int y() {
            return this.y;
        }

        public int z() {
            return this.z;
        }

        public Block block() {
            return this.block;
        }

        public int meta() {
            return this.meta;
        }

        public int pass() {
            return this.pass;
        }

        public org.embeddedt.embeddium.impl.render.chunk.terrain.material.Material materialOverride() {
            return this.materialOverride;
        }

        public boolean isShaderPackOverride() {
            return this.isShaderPackOverride;
        }

        private static /* synthetic */ String jvmdowngrader$toString$toString(DeferredBlock deferredBlock) {
            DeferredBlock deferredBlock2 = deferredBlock;
            return "AngelicaChunkBuilderMeshingTask$DeferredBlock[" + "x=" + deferredBlock.x + ", " + "y=" + deferredBlock.y + ", " + "z=" + deferredBlock.z + ", " + "block=" + deferredBlock.block + ", " + "meta=" + deferredBlock.meta + ", " + "pass=" + deferredBlock.pass + ", " + "materialOverride=" + deferredBlock.materialOverride + ", " + "isShaderPackOverride=" + deferredBlock.isShaderPackOverride + "]";
        }

        private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(DeferredBlock deferredBlock) {
            Object[] objectArray = new Object[]{deferredBlock.x, deferredBlock.y, deferredBlock.z, deferredBlock.block, deferredBlock.meta, deferredBlock.pass, deferredBlock.materialOverride, deferredBlock.isShaderPackOverride};
            return Arrays.hashCode(objectArray);
        }

        private static /* synthetic */ boolean jvmdowngrader$equals$equals(DeferredBlock deferredBlock, Object object) {
            if (deferredBlock == object) {
                return true;
            }
            if (object != null && object instanceof DeferredBlock) {
                DeferredBlock deferredBlock2 = (DeferredBlock)((Object)object);
                if (deferredBlock.x == deferredBlock2.x && deferredBlock.y == deferredBlock2.y && deferredBlock.z == deferredBlock2.z && Objects.equals(deferredBlock.block, deferredBlock2.block) && deferredBlock.meta == deferredBlock2.meta && deferredBlock.pass == deferredBlock2.pass && Objects.equals(deferredBlock.materialOverride, deferredBlock2.materialOverride) && deferredBlock.isShaderPackOverride == deferredBlock2.isShaderPackOverride) {
                    return true;
                }
            }
            return false;
        }
    }
}

