/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.rendering.celeritas;

import com.gtnewhorizons.angelica.AngelicaMod;
import com.gtnewhorizons.angelica.dynamiclights.DynamicLights;
import com.gtnewhorizons.angelica.dynamiclights.IDynamicLightSource;
import com.gtnewhorizons.angelica.rendering.celeritas.AngelicaRenderPassConfiguration;
import com.gtnewhorizons.angelica.rendering.celeritas.SpriteExtension;
import com.gtnewhorizons.angelica.rendering.celeritas.TextureMapExtension;
import com.gtnewhorizons.angelica.rendering.celeritas.VertexArrayQuadView;
import com.gtnewhorizons.angelica.rendering.celeritas.iris.BlockRenderContext;
import com.gtnewhorizons.angelica.rendering.celeritas.iris.IrisExtendedChunkVertexEncoder;
import com.gtnewhorizons.angelica.rendering.celeritas.light.LightDataCache;
import com.gtnewhorizons.angelica.rendering.celeritas.light.QuadLightingHelper;
import com.gtnewhorizons.angelica.rendering.celeritas.light.VanillaDiffuseProvider;
import com.gtnewhorizons.angelica.rendering.celeritas.world.WorldSlice;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import net.coderbot.iris.block_rendering.BlockRenderingSettings;
import net.irisshaders.iris.api.v0.IrisApi;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.IBlockAccess;
import org.embeddedt.embeddium.impl.model.light.LightPipeline;
import org.embeddedt.embeddium.impl.model.light.data.LightDataAccess;
import org.embeddedt.embeddium.impl.model.light.data.QuadLightData;
import org.embeddedt.embeddium.impl.model.light.flat.FlatLightPipeline;
import org.embeddedt.embeddium.impl.model.light.smooth.SmoothLightPipeline;
import org.embeddedt.embeddium.impl.model.quad.properties.ModelQuadFacing;
import org.embeddedt.embeddium.impl.render.chunk.ChunkColorWriter;
import org.embeddedt.embeddium.impl.render.chunk.RenderPassConfiguration;
import org.embeddedt.embeddium.impl.render.chunk.compile.ChunkBuildBuffers;
import org.embeddedt.embeddium.impl.render.chunk.compile.ChunkBuildContext;
import org.embeddedt.embeddium.impl.render.chunk.compile.buffers.ChunkModelBuilder;
import org.embeddedt.embeddium.impl.render.chunk.data.MinecraftBuiltRenderSectionData;
import org.embeddedt.embeddium.impl.render.chunk.sprite.SpriteTransparencyLevel;
import org.embeddedt.embeddium.impl.render.chunk.terrain.material.Material;
import org.embeddedt.embeddium.impl.render.chunk.vertex.format.ChunkVertexEncoder;
import org.embeddedt.embeddium.impl.util.QuadUtil;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class AngelicaChunkBuildContext
extends ChunkBuildContext {
    public static final int NUM_PASSES = 2;
    private final TextureMapExtension textureAtlas;
    private final ChunkVertexEncoder.Vertex[] vertices = ChunkVertexEncoder.Vertex.uninitializedQuad();
    private final WorldSlice worldSlice;
    private final BlockRenderContext blockRenderContext = new BlockRenderContext();
    private List<IDynamicLightSource> chunkLightSources;
    private DynamicLights dynamicLightsInstance;
    private final LightDataCache lightDataCache = new LightDataCache();
    private final SmoothLightPipeline smoothLightPipeline;
    private final FlatLightPipeline flatLightPipeline;
    private final QuadLightData quadLightData = new QuadLightData();
    private final VertexArrayQuadView quadView;
    private boolean lightPipelineReady = false;
    private int originX;
    private int originY;
    private int originZ;
    private IBlockAccess blockAccess;

    public AngelicaChunkBuildContext(RenderPassConfiguration<?> renderPassConfiguration, WorldClient world) {
        super(renderPassConfiguration);
        this.textureAtlas = (TextureMapExtension)Minecraft.func_71410_x().func_147117_R();
        this.worldSlice = new WorldSlice(world);
        this.smoothLightPipeline = new SmoothLightPipeline(this.lightDataCache, VanillaDiffuseProvider.INSTANCE, false);
        this.flatLightPipeline = new FlatLightPipeline(this.lightDataCache, VanillaDiffuseProvider.INSTANCE, false);
        this.quadView = new VertexArrayQuadView(this.vertices);
    }

    public void setupLightPipeline(int minBlockX, int minBlockY, int minBlockZ) {
        this.setupLightPipeline(this.worldSlice, minBlockX, minBlockY, minBlockZ);
    }

    public void setupLightPipeline(IBlockAccess blockAccess, int minBlockX, int minBlockY, int minBlockZ) {
        this.blockAccess = blockAccess;
        this.originX = minBlockX;
        this.originY = minBlockY;
        this.originZ = minBlockZ;
        this.lightDataCache.setWorld(blockAccess);
        this.lightDataCache.reset(minBlockX, minBlockY, minBlockZ);
        this.smoothLightPipeline.reset();
        this.flatLightPipeline.reset();
        this.lightPipelineReady = true;
    }

    public void setupDynamicLights(int chunkOriginX, int chunkOriginY, int chunkOriginZ) {
        if (DynamicLights.isEnabled()) {
            this.dynamicLightsInstance = DynamicLights.get();
            this.chunkLightSources = this.dynamicLightsInstance.getSourcesForChunk(chunkOriginX, chunkOriginY, chunkOriginZ);
        } else {
            this.dynamicLightsInstance = null;
            this.chunkLightSources = null;
        }
    }

    private Material selectMaterial(Material material, TextureAtlasSprite sprite, boolean isShaderPackOverride) {
        if (!AngelicaMod.options().performance.useRenderPassOptimization || isShaderPackOverride) {
            return material;
        }
        if (sprite != null && sprite.getClass() == TextureAtlasSprite.class && !sprite.func_130098_m()) {
            SpriteTransparencyLevel transparencyLevel = ((SpriteExtension)sprite).celeritas$getTransparencyLevel();
            if (transparencyLevel == SpriteTransparencyLevel.OPAQUE && material == AngelicaRenderPassConfiguration.CUTOUT_MIPPED_MATERIAL) {
                return AngelicaRenderPassConfiguration.SOLID_MATERIAL;
            }
            if (material == AngelicaRenderPassConfiguration.TRANSLUCENT_MATERIAL && transparencyLevel != SpriteTransparencyLevel.TRANSLUCENT) {
                return AngelicaRenderPassConfiguration.CUTOUT_MIPPED_MATERIAL;
            }
        }
        return material;
    }

    public void copyRawBuffer(int[] rawBuffer, int vertexCount, ChunkBuildBuffers buffers, Material material, boolean isShaderPackOverride, boolean blockAllowsSmoothLighting) {
        if (vertexCount == 0) {
            return;
        }
        Collection animatedSprites = ((MinecraftBuiltRenderSectionData)buffers.getSectionContextBundle()).animatedSprites;
        if ((vertexCount & 3) != 0) {
            throw new IllegalStateException(AngelicaChunkBuildContext.jvmdowngrader$concat$copyRawBuffer$1(vertexCount));
        }
        boolean hasDynamicLights = this.chunkLightSources != null && !this.chunkLightSources.isEmpty();
        boolean separateAo = BlockRenderingSettings.INSTANCE.shouldUseSeparateAo();
        boolean celeritasSmoothLighting = AngelicaMod.options().quality.useCeleritasSmoothLighting;
        boolean shaderActive = IrisApi.getInstance().isShaderPackInUse();
        boolean useAoCalculation = this.lightPipelineReady && (separateAo || celeritasSmoothLighting || shaderActive);
        boolean stripDiffuse = shaderActive && BlockRenderingSettings.INSTANCE.shouldDisableDirectionalShading();
        boolean shade = false;
        ChunkColorWriter colorEncoder = separateAo ? ChunkColorWriter.SEPARATE_AO : ChunkColorWriter.EMBEDDIUM;
        int ptr = 0;
        int numQuads = vertexCount / 4;
        int blockX = this.blockRenderContext.localPosX;
        int blockY = this.blockRenderContext.localPosY;
        int blockZ = this.blockRenderContext.localPosZ;
        int worldX = this.originX + blockX;
        int worldY = this.originY + blockY;
        int worldZ = this.originZ + blockZ;
        boolean isEmissive = useAoCalculation && QuadLightingHelper.isBlockEmissive(this.blockAccess, worldX, worldY, worldZ);
        for (int quadIdx = 0; quadIdx < numQuads; ++quadIdx) {
            ChunkVertexEncoder chunkVertexEncoder;
            int vIdx;
            float uSum = 0.0f;
            float vSum = 0.0f;
            for (int vIdx2 = 0; vIdx2 < 4; ++vIdx2) {
                ChunkVertexEncoder.Vertex vertex = this.vertices[vIdx2];
                vertex.x = Float.intBitsToFloat(rawBuffer[ptr++]);
                vertex.y = Float.intBitsToFloat(rawBuffer[ptr++]);
                vertex.z = Float.intBitsToFloat(rawBuffer[ptr++]);
                float u = Float.intBitsToFloat(rawBuffer[ptr++]);
                float v = Float.intBitsToFloat(rawBuffer[ptr++]);
                vertex.u = u;
                uSum += u;
                vertex.v = v;
                vSum += v;
                vertex.color = rawBuffer[ptr++];
                vertex.vanillaNormal = rawBuffer[ptr++];
                vertex.light = rawBuffer[ptr++];
            }
            int trueNormal = QuadUtil.calculateNormal(this.vertices);
            ModelQuadFacing facing = QuadUtil.findNormalFace(trueNormal);
            TextureAtlasSprite sprite = this.textureAtlas.celeritas$findFromUV(uSum * 0.25f, vSum * 0.25f);
            if (sprite != null && sprite.func_130098_m()) {
                animatedSprites.add(sprite);
            }
            if (stripDiffuse) {
                float inverseDiffuse = VanillaDiffuseProvider.INSTANCE.getInverseDiffuse(facing);
                for (int vIdx3 = 0; vIdx3 < 4; ++vIdx3) {
                    this.vertices[vIdx3].color = VanillaDiffuseProvider.multiplyColor(this.vertices[vIdx3].color, inverseDiffuse);
                }
            }
            if (useAoCalculation) {
                boolean quadIsFullBright = QuadLightingHelper.isQuadFullBright(this.vertices);
                if (isEmissive || quadIsFullBright) {
                    Arrays.fill(this.quadLightData.br, 1.0f);
                    if (isEmissive) {
                        Arrays.fill(this.quadLightData.lm, LightDataAccess.FULL_BRIGHT);
                    } else {
                        for (int i = 0; i < 4; ++i) {
                            this.quadLightData.lm[i] = this.vertices[i].light;
                        }
                    }
                } else {
                    this.quadView.setup(trueNormal, blockX, blockY, blockZ);
                    ModelQuadFacing lightFace = this.quadView.getLightFace();
                    LightPipeline pipeline = blockAllowsSmoothLighting ? this.smoothLightPipeline : this.flatLightPipeline;
                    ModelQuadFacing cullFace = this.quadView.getCullFace();
                    pipeline.calculate(this.quadView, worldX, worldY, worldZ, this.quadLightData, cullFace, lightFace, false, true);
                }
                for (int vIdx4 = 0; vIdx4 < 4; ++vIdx4) {
                    ChunkVertexEncoder.Vertex vertex = this.vertices[vIdx4];
                    vertex.trueNormal = trueNormal;
                    vertex.color = colorEncoder.writeColor(vertex.color, this.quadLightData.br[vIdx4]);
                    vertex.light = this.quadLightData.lm[vIdx4];
                }
            } else {
                for (vIdx = 0; vIdx < 4; ++vIdx) {
                    this.vertices[vIdx].trueNormal = trueNormal;
                }
            }
            if (hasDynamicLights) {
                for (vIdx = 0; vIdx < 4; ++vIdx) {
                    ChunkVertexEncoder.Vertex vertex = this.vertices[vIdx];
                    double dynamicLevel = this.dynamicLightsInstance.getDynamicLightLevelFromSources((float)this.originX + vertex.x, (float)this.originY + vertex.y, (float)this.originZ + vertex.z, this.chunkLightSources);
                    if (!(dynamicLevel > 0.0)) continue;
                    vertex.light = this.dynamicLightsInstance.getLightmapWithDynamicLight(dynamicLevel, vertex.light);
                }
            }
            Material correctMaterial = this.selectMaterial(material, sprite, isShaderPackOverride);
            ChunkModelBuilder builder = buffers.get(correctMaterial);
            if (correctMaterial != material && (chunkVertexEncoder = builder.getEncoder()) instanceof IrisExtendedChunkVertexEncoder) {
                IrisExtendedChunkVertexEncoder iris = (IrisExtendedChunkVertexEncoder)chunkVertexEncoder;
                iris.setContext(this.blockRenderContext);
            }
            builder.getVertexBuffer(facing).push(this.vertices, correctMaterial);
        }
    }

    @Generated
    public WorldSlice getWorldSlice() {
        return this.worldSlice;
    }

    @Generated
    public BlockRenderContext getBlockRenderContext() {
        return this.blockRenderContext;
    }

    private static /* synthetic */ String jvmdowngrader$concat$copyRawBuffer$1(int n) {
        return "Only quads are supported, got: " + n;
    }
}

