/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.rendering;

import it.unimi.dsi.fastutil.objects.Reference2ByteOpenHashMap;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public final class TileEntityRenderBoundsRegistry {
    private static final byte UNKNOWN = 0;
    private static final byte FINITE = 1;
    private static final byte INFINITE = 2;
    private static final Reference2ByteOpenHashMap<Class<? extends TileEntity>> classRegistry = new Reference2ByteOpenHashMap();

    private TileEntityRenderBoundsRegistry() {
    }

    public static boolean isInfiniteExtentsBox(AxisAlignedBB box) {
        return box == null || Double.isInfinite(box.field_72340_a) || Double.isInfinite(box.field_72338_b) || Double.isInfinite(box.field_72339_c) || Double.isInfinite(box.field_72336_d) || Double.isInfinite(box.field_72337_e) || Double.isInfinite(box.field_72334_f);
    }

    public static boolean isAlwaysInfiniteExtent(TileEntity te) {
        Class<?> clazz = te.getClass();
        byte result = classRegistry.getByte(clazz);
        if (result != 0) {
            return result == 2;
        }
        return TileEntityRenderBoundsRegistry.probeAndCache(te, clazz);
    }

    private static boolean probeAndCache(TileEntity te, Class<? extends TileEntity> clazz) {
        boolean isInfinite = false;
        try {
            AxisAlignedBB aabb = te.getRenderBoundingBox();
            isInfinite = TileEntityRenderBoundsRegistry.isInfiniteExtentsBox(aabb);
        }
        catch (Exception exception) {
            // empty catch block
        }
        classRegistry.put(clazz, isInfinite ? (byte)2 : 1);
        return isInfinite;
    }

    public static void clear() {
        classRegistry.clear();
    }

    static {
        classRegistry.defaultReturnValue((byte)0);
    }
}

