/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.rendering;

import com.gtnewhorizon.gtnhlib.client.renderer.DirectTessellator;
import com.gtnewhorizon.gtnhlib.client.renderer.TessellatorManager;
import com.gtnewhorizon.gtnhlib.client.renderer.vao.IVertexArrayObject;
import com.gtnewhorizon.gtnhlib.client.renderer.vao.IndexBuffer;
import com.gtnewhorizon.gtnhlib.client.renderer.vao.VAOManager;
import com.gtnewhorizon.gtnhlib.client.renderer.vertex.DefaultVertexFormat;
import com.gtnewhorizon.gtnhlib.client.renderer.vertex.VertexFormat;
import com.gtnewhorizons.angelica.config.AngelicaConfig;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={ItemProp.class, CachedVBO.class})
public class ItemRenderListManager {
    private static final Object2ObjectLinkedOpenHashMap<ItemProp, CachedVBO> vboCache = new Object2ObjectLinkedOpenHashMap(64);
    private static final int EXPIRY_TICKS = 1200;
    private static int smallestExpiry;
    private static final ItemProp prop;

    public static CachedVBO pre(float minU, float minV, float maxU, float maxV, int widthSubdivisions, int heightSubdivisions, float thickness) {
        CachedVBO vbo;
        prop.set(minU, minV, maxU, maxV, widthSubdivisions, heightSubdivisions, thickness);
        if (!vboCache.isEmpty() && (vbo = (CachedVBO)vboCache.getAndMoveToLast((Object)prop)) != null) {
            int time = ItemRenderListManager.getElapsedTicks();
            vbo.jvmdowngrader$nest$com_gtnewhorizons_angelica_rendering_ItemRenderListManager$CachedVBO$render(time);
            if (time > smallestExpiry && time > (smallestExpiry = ((CachedVBO)vboCache.get(vboCache.firstKey())).jvmdowngrader$nest$com_gtnewhorizons_angelica_rendering_ItemRenderListManager$CachedVBO$get$expiry() + 20)) {
                ((CachedVBO)vboCache.removeFirst()).jvmdowngrader$nest$com_gtnewhorizons_angelica_rendering_ItemRenderListManager$CachedVBO$delete();
                if (!vboCache.isEmpty()) {
                    smallestExpiry = ((CachedVBO)vboCache.get(vboCache.firstKey())).jvmdowngrader$nest$com_gtnewhorizons_angelica_rendering_ItemRenderListManager$CachedVBO$get$expiry() + 20;
                }
            }
            return null;
        }
        if (vboCache.size() >= AngelicaConfig.itemRendererCacheSize) {
            ItemProp oldestProp = (ItemProp)vboCache.firstKey();
            vbo = (CachedVBO)vboCache.removeFirst();
            oldestProp.set(prop);
            vboCache.put((Object)oldestProp, (Object)vbo);
        } else {
            vbo = new CachedVBO();
            vboCache.put((Object)new ItemProp(prop), (Object)vbo);
        }
        vbo.jvmdowngrader$nest$com_gtnewhorizons_angelica_rendering_ItemRenderListManager$CachedVBO$set$expiry(ItemRenderListManager.getElapsedTicks() + 1200);
        return vbo;
    }

    public static void post(DirectTessellator tessellator, CachedVBO vbo) {
        vbo.jvmdowngrader$nest$com_gtnewhorizons_angelica_rendering_ItemRenderListManager$CachedVBO$allocate(tessellator);
        TessellatorManager.stopCapturingDirect();
        vbo.jvmdowngrader$nest$com_gtnewhorizons_angelica_rendering_ItemRenderListManager$CachedVBO$get$vertexBuffer().render();
    }

    private static int getElapsedTicks() {
        return Minecraft.func_71410_x().field_71439_g.field_70173_aa;
    }

    static {
        prop = new ItemProp();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=ItemRenderListManager.class)
    private static final class ItemProp {
        private float minU;
        private float minV;
        private float maxU;
        private float maxV;
        private int widthSubdivisions;
        private int heightSubdivisions;
        private float thickness;

        public ItemProp(ItemProp old) {
            this.set(old.minU, old.minV, old.maxU, old.maxV, old.widthSubdivisions, old.heightSubdivisions, old.thickness);
        }

        public void set(ItemProp other) {
            this.set(other.minU, other.minV, other.maxU, other.maxV, other.widthSubdivisions, other.heightSubdivisions, other.thickness);
        }

        public void set(float minU, float minV, float maxU, float maxV, int widthSubdivisions, int heightSubdivisions, float thickness) {
            this.minU = minU;
            this.minV = minV;
            this.maxU = maxU;
            this.maxV = maxV;
            this.widthSubdivisions = widthSubdivisions;
            this.heightSubdivisions = heightSubdivisions;
            this.thickness = thickness;
        }

        @Generated
        public ItemProp() {
        }

        @Generated
        public float getMinU() {
            return this.minU;
        }

        @Generated
        public float getMinV() {
            return this.minV;
        }

        @Generated
        public float getMaxU() {
            return this.maxU;
        }

        @Generated
        public float getMaxV() {
            return this.maxV;
        }

        @Generated
        public int getWidthSubdivisions() {
            return this.widthSubdivisions;
        }

        @Generated
        public int getHeightSubdivisions() {
            return this.heightSubdivisions;
        }

        @Generated
        public float getThickness() {
            return this.thickness;
        }

        @Generated
        public void setMinU(float minU) {
            this.minU = minU;
        }

        @Generated
        public void setMinV(float minV) {
            this.minV = minV;
        }

        @Generated
        public void setMaxU(float maxU) {
            this.maxU = maxU;
        }

        @Generated
        public void setMaxV(float maxV) {
            this.maxV = maxV;
        }

        @Generated
        public void setWidthSubdivisions(int widthSubdivisions) {
            this.widthSubdivisions = widthSubdivisions;
        }

        @Generated
        public void setHeightSubdivisions(int heightSubdivisions) {
            this.heightSubdivisions = heightSubdivisions;
        }

        @Generated
        public void setThickness(float thickness) {
            this.thickness = thickness;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ItemProp)) {
                return false;
            }
            ItemProp other = (ItemProp)o;
            if (Float.compare(this.getMinU(), other.getMinU()) != 0) {
                return false;
            }
            if (Float.compare(this.getMinV(), other.getMinV()) != 0) {
                return false;
            }
            if (Float.compare(this.getMaxU(), other.getMaxU()) != 0) {
                return false;
            }
            if (Float.compare(this.getMaxV(), other.getMaxV()) != 0) {
                return false;
            }
            if (this.getWidthSubdivisions() != other.getWidthSubdivisions()) {
                return false;
            }
            if (this.getHeightSubdivisions() != other.getHeightSubdivisions()) {
                return false;
            }
            return Float.compare(this.getThickness(), other.getThickness()) == 0;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Float.floatToIntBits(this.getMinU());
            result = result * 59 + Float.floatToIntBits(this.getMinV());
            result = result * 59 + Float.floatToIntBits(this.getMaxU());
            result = result * 59 + Float.floatToIntBits(this.getMaxV());
            result = result * 59 + this.getWidthSubdivisions();
            result = result * 59 + this.getHeightSubdivisions();
            result = result * 59 + Float.floatToIntBits(this.getThickness());
            return result;
        }

        @Generated
        public String toString() {
            return ItemProp.jvmdowngrader$concat$toString$1(this.getMinU(), this.getMinV(), this.getMaxU(), this.getMaxV(), this.getWidthSubdivisions(), this.getHeightSubdivisions(), this.getThickness());
        }

        private static /* synthetic */ String jvmdowngrader$concat$toString$1(float f, float f2, float f3, float f4, int n, int n2, float f5) {
            return "ItemRenderListManager.ItemProp(minU=" + f + ", minV=" + f2 + ", maxU=" + f3 + ", maxV=" + f4 + ", widthSubdivisions=" + n + ", heightSubdivisions=" + n2 + ", thickness=" + f5 + ")";
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=ItemRenderListManager.class)
    public static final class CachedVBO {
        private final IVertexArrayObject vertexBuffer;
        private final IndexBuffer ebo = new IndexBuffer();
        private int expiry;

        public CachedVBO() {
            this.vertexBuffer = VAOManager.createMutableVAO((VertexFormat)DefaultVertexFormat.POSITION_TEXTURE_NORMAL, (int)4, (IndexBuffer)this.ebo);
        }

        private void allocate(DirectTessellator tessellator) {
            tessellator.allocateToVBO(this.vertexBuffer, this.ebo);
        }

        private void render(int elapsedTicks) {
            this.vertexBuffer.render();
            this.expiry = elapsedTicks + 1200;
        }

        private void delete() {
            this.vertexBuffer.delete();
        }

        public /* synthetic */ IVertexArrayObject jvmdowngrader$nest$com_gtnewhorizons_angelica_rendering_ItemRenderListManager$CachedVBO$get$vertexBuffer() {
            return this.vertexBuffer;
        }

        public /* synthetic */ void jvmdowngrader$nest$com_gtnewhorizons_angelica_rendering_ItemRenderListManager$CachedVBO$set$vertexBuffer(IVertexArrayObject iVertexArrayObject) {
            this.vertexBuffer = iVertexArrayObject;
        }

        public /* synthetic */ void jvmdowngrader$nest$com_gtnewhorizons_angelica_rendering_ItemRenderListManager$CachedVBO$render(int n) {
            this.render(n);
        }

        public /* synthetic */ int jvmdowngrader$nest$com_gtnewhorizons_angelica_rendering_ItemRenderListManager$CachedVBO$get$expiry() {
            return this.expiry;
        }

        public /* synthetic */ void jvmdowngrader$nest$com_gtnewhorizons_angelica_rendering_ItemRenderListManager$CachedVBO$set$expiry(int n) {
            this.expiry = n;
        }

        public /* synthetic */ void jvmdowngrader$nest$com_gtnewhorizons_angelica_rendering_ItemRenderListManager$CachedVBO$allocate(DirectTessellator directTessellator) {
            this.allocate(directTessellator);
        }

        public /* synthetic */ void jvmdowngrader$nest$com_gtnewhorizons_angelica_rendering_ItemRenderListManager$CachedVBO$delete() {
            this.delete();
        }
    }
}

