/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.mixins.early.celeritas.terrain;

import com.gtnewhorizons.angelica.compat.mojang.Camera;
import com.gtnewhorizons.angelica.compat.mojang.GameModeUtil;
import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.mixins.interfaces.IRenderGlobalExt;
import com.gtnewhorizons.angelica.rendering.AngelicaRenderQueue;
import com.gtnewhorizons.angelica.rendering.RenderingState;
import com.gtnewhorizons.angelica.rendering.celeritas.BlockRenderLayer;
import com.gtnewhorizons.angelica.rendering.celeritas.CeleritasSetup;
import com.gtnewhorizons.angelica.rendering.celeritas.CeleritasWorldRenderer;
import net.coderbot.iris.Iris;
import net.coderbot.iris.layer.GbufferPrograms;
import net.coderbot.iris.pipeline.HandRenderer;
import net.coderbot.iris.pipeline.WorldRenderingPhase;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.shadows.ShadowRenderingState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import org.embeddedt.embeddium.impl.gl.device.RenderDevice;
import org.embeddedt.embeddium.impl.render.chunk.shader.ChunkShaderFogComponent;
import org.embeddedt.embeddium.impl.render.terrain.SimpleWorldRenderer;
import org.embeddedt.embeddium.impl.render.viewport.ViewportProvider;
import org.joml.Math;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RenderGlobal.class}, priority=900)
public class MixinRenderGlobal
implements IRenderGlobalExt {
    @Shadow
    public Minecraft field_72777_q;
    @Shadow
    @Final
    private TextureManager field_72770_i;
    @Unique
    private CeleritasWorldRenderer celeritas$renderer;
    @Unique
    private int celeritas$frame;
    @Unique
    private float celeritas$lastFov;
    @Unique
    private int celeritas$lastThirdPersonView = -1;
    @Unique
    private static boolean sortAndRenderLogged = false;

    @Unique
    private boolean angelica$isSpectatorMode() {
        return GameModeUtil.isSpectator();
    }

    @Redirect(method={"<init>(Lnet/minecraft/client/Minecraft;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GLAllocation;generateDisplayLists(I)I", ordinal=0))
    private int celeritas$minimizeDisplayListAllocation(int count) {
        return GLAllocation.func_74526_a((int)3);
    }

    @Redirect(method={"loadRenderers"}, at=@At(value="FIELD", target="Lnet/minecraft/client/renderer/RenderGlobal;renderDistanceChunks:I", opcode=180, ordinal=0))
    private int celeritas$nullifyBuiltChunkStorage(RenderGlobal self) {
        return 0;
    }

    @ModifyConstant(method={"loadRenderers"}, constant={@Constant(intValue=16, ordinal=0)}, require=1)
    private int celeritas$nullifyBuiltChunkStorage2(int constant) {
        return 1;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void celeritas$initRenderer(Minecraft mc, CallbackInfo ci) {
        this.celeritas$renderer = CeleritasWorldRenderer.create(mc);
    }

    @Inject(method={"Lnet/minecraft/client/renderer/RenderGlobal;setWorldAndLoadRenderers(Lnet/minecraft/client/multiplayer/WorldClient;)V"}, at={@At(value="RETURN")})
    private void celeritas$setWorldAndLoadRenderers(WorldClient world, CallbackInfo ci) {
        RenderDevice.enterManagedCode();
        try {
            this.celeritas$renderer.setWorld(world);
        }
        finally {
            RenderDevice.exitManagedCode();
        }
        if (world != null && this.field_72777_q.field_71451_h != null) {
            EntityLivingBase e = this.field_72777_q.field_71451_h;
            Camera.INSTANCE.getPos().set(e.field_70165_t, e.field_70163_u + (double)e.func_70047_e(), e.field_70161_v);
            e.field_70142_S = e.field_70165_t;
            e.field_70137_T = e.field_70163_u;
            e.field_70136_U = e.field_70161_v;
        }
    }

    @Inject(method={"onStaticEntitiesChanged"}, at={@At(value="RETURN")})
    private void onTerrainUpdateScheduled(CallbackInfo ci) {
        this.celeritas$renderer.scheduleTerrainUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    public int func_72719_a(EntityLivingBase entity, int pass, double partialTicks) {
        WorldRenderingPipeline pipeline;
        if (!sortAndRenderLogged && ShadowRenderingState.areShadowsCurrentlyBeingRendered()) {
            Iris.logger.info("[SHADOW DEBUG] sortAndRender called! pass={}", pass);
            sortAndRenderLogged = true;
        }
        if (!Iris.enabled) {
            pipeline = null;
        } else {
            pipeline = Iris.getPipelineManager().getPipelineNullable();
            if (pass == 0) {
                pipeline.setPhase(WorldRenderingPhase.TERRAIN_CUTOUT);
            } else if (pass == 1) {
                if (!ShadowRenderingState.areShadowsCurrentlyBeingRendered()) {
                    this.iris$beginTranslucents(pipeline, Camera.INSTANCE);
                }
                pipeline.setPhase(WorldRenderingPhase.TERRAIN_TRANSLUCENT);
                this.field_72770_i.func_110577_a(TextureMap.field_110575_b);
            }
        }
        RenderDevice.enterManagedCode();
        RenderHelper.func_74518_a();
        GLStateManager.glActiveTexture(33984);
        GLStateManager.glBindTexture(3553, this.field_72777_q.func_147117_R().func_110552_b());
        GLStateManager.glEnable(3553);
        GLStateManager.glEnable(3008);
        GLStateManager.glEnable(2912);
        this.field_72777_q.field_71460_t.func_78463_b(partialTicks);
        double camX = Math.lerp((double)entity.field_70142_S, (double)entity.field_70165_t, (double)partialTicks);
        double camY = Math.lerp((double)entity.field_70137_T, (double)entity.field_70163_u, (double)partialTicks);
        double camZ = Math.lerp((double)entity.field_70136_U, (double)entity.field_70161_v, (double)partialTicks);
        try {
            if (pass == 0) {
                this.field_72777_q.field_71424_I.func_76318_c("draw_chunk_layer_solid");
                this.celeritas$renderer.drawChunkLayer(BlockRenderLayer.SOLID, camX, camY, camZ);
                this.field_72777_q.field_71424_I.func_76318_c("draw_chunk_layer_cutout_mipped");
                this.celeritas$renderer.drawChunkLayer(BlockRenderLayer.CUTOUT_MIPPED, camX, camY, camZ);
            } else {
                this.field_72777_q.field_71424_I.func_76318_c("draw_chunk_layer_translucent");
                this.celeritas$renderer.drawChunkLayer(BlockRenderLayer.TRANSLUCENT, camX, camY, camZ);
            }
        }
        finally {
            RenderDevice.exitManagedCode();
        }
        this.field_72777_q.field_71460_t.func_78483_a(partialTicks);
        if (pipeline != null) {
            pipeline.setPhase(WorldRenderingPhase.NONE);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    public void func_72729_a(ICamera camera, float partialTicks) {
        RenderDevice.enterManagedCode();
        try {
            int currentThirdPerson;
            EntityLivingBase viewEntity = this.field_72777_q.field_71451_h;
            float fogDistance = ChunkShaderFogComponent.FOG_SERVICE.getFogCutoff();
            double camX = Math.lerp((double)viewEntity.field_70142_S, (double)viewEntity.field_70165_t, (double)partialTicks);
            double camY = Math.lerp((double)viewEntity.field_70137_T, (double)viewEntity.field_70163_u, (double)partialTicks) + (double)viewEntity.func_70047_e();
            double camZ = Math.lerp((double)viewEntity.field_70136_U, (double)viewEntity.field_70161_v, (double)partialTicks);
            float currentFov = RenderingState.INSTANCE.getFov();
            if (currentFov != this.celeritas$lastFov) {
                this.celeritas$renderer.scheduleTerrainUpdate();
                this.celeritas$lastFov = currentFov;
            }
            if ((currentThirdPerson = this.field_72777_q.field_71474_y.field_74320_O) != this.celeritas$lastThirdPersonView) {
                this.celeritas$renderer.scheduleTerrainUpdate();
                this.celeritas$lastThirdPersonView = currentThirdPerson;
            }
            SimpleWorldRenderer.CameraState cameraState = new SimpleWorldRenderer.CameraState(camX, camY, camZ, viewEntity.field_70125_A, viewEntity.field_70177_z, fogDistance);
            this.celeritas$renderer.setupTerrain(((ViewportProvider)camera).sodium$createViewport(), cameraState, this.celeritas$frame++, this.angelica$isSpectatorMode(), false);
        }
        finally {
            RenderDevice.exitManagedCode();
        }
    }

    @Overwrite
    public void func_72725_b(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.celeritas$renderer.scheduleRebuildForBlockArea(minX, minY, minZ, maxX, maxY, maxZ, false);
    }

    @Override
    @Unique
    public void angelica$reload() {
        CeleritasSetup.ensureInitialized();
        RenderDevice.enterManagedCode();
        try {
            this.celeritas$renderer.reload();
        }
        finally {
            RenderDevice.exitManagedCode();
        }
    }

    @Inject(method={"loadRenderers"}, at={@At(value="RETURN")})
    private void onReload(CallbackInfo ci) {
        this.angelica$reload();
    }

    @Inject(method={"renderEntities"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/RenderHelper;enableStandardItemLighting()V", shift=At.Shift.AFTER, ordinal=0)}, cancellable=true)
    public void celeritas$renderTileEntities(EntityLivingBase entity, ICamera camera, float partialTicks, CallbackInfo ci) {
        if (Iris.enabled) {
            GbufferPrograms.beginBlockEntities();
            GbufferPrograms.setBlockEntityDefaults();
        }
        this.celeritas$renderer.renderBlockEntities(partialTicks);
        if (Iris.enabled) {
            GbufferPrograms.endBlockEntities();
        }
        this.field_72777_q.field_71460_t.func_78483_a((double)partialTicks);
        this.field_72777_q.field_71424_I.func_76319_b();
        ci.cancel();
    }

    @Overwrite
    public String func_72735_c() {
        return this.celeritas$renderer.getChunksDebugString();
    }

    @Overwrite
    public boolean func_72716_a(EntityLivingBase e, boolean b) {
        int BUDGET_NS = 5000000;
        long startTime = System.nanoTime();
        int tasksRan = 0;
        while (System.nanoTime() - startTime < 5000000L && AngelicaRenderQueue.processTasks(1) != 0) {
            ++tasksRan;
        }
        AngelicaRenderQueue.recordFrameStats(tasksRan, System.nanoTime() - startTime);
        return true;
    }

    @Unique
    private void iris$beginTranslucents(WorldRenderingPipeline pipeline, Camera camera) {
        pipeline.beginHand();
        HandRenderer.INSTANCE.renderSolid(camera.getPartialTicks(), camera, this.field_72777_q.field_71438_f, pipeline);
        this.field_72777_q.field_71424_I.func_76318_c("iris_pre_translucent");
        pipeline.beginTranslucents();
    }

    @Redirect(method={"renderEntities"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;isInRangeToRender3d(DDD)Z"))
    private boolean isInRange(Entity e, double x, double y, double z) {
        return e.func_145770_h(x, y, z) && this.celeritas$renderer.isEntityVisible(e);
    }

    @Override
    public void angelica$scheduleTerrainUpdate() {
        this.celeritas$renderer.scheduleTerrainUpdate();
    }
}

