/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.mixins.early.celeritas.features.mipmaps;

import com.gtnewhorizons.angelica.rendering.celeritas.SpriteExtension;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import org.embeddedt.embeddium.api.util.ColorABGR;
import org.embeddedt.embeddium.impl.render.chunk.sprite.SpriteTransparencyLevel;
import org.embeddedt.embeddium.impl.util.color.ColorSRGB;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TextureAtlasSprite.class})
public abstract class MixinTextureAtlasSprite
implements SpriteExtension {
    @Shadow
    protected List<int[][]> field_110976_a;
    @Shadow
    @Final
    private String field_110984_i;
    @Unique
    private SpriteTransparencyLevel celeritas$transparencyLevel = SpriteTransparencyLevel.TRANSLUCENT;

    @Inject(method={"generateMipmaps"}, at={@At(value="HEAD")})
    private void celeritas$processSprite(int level, CallbackInfo ci) {
        if (this.field_110976_a.isEmpty() || this.field_110976_a.get(0) == null) {
            return;
        }
        this.celeritas$processTransparentImages(this.field_110976_a.get(0)[0], level > 0 && !this.field_110984_i.contains("leaves"));
    }

    @Unique
    private void celeritas$processTransparentImages(int[] nativeImage, boolean shouldRewriteColors) {
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        float totalWeight = 0.0f;
        SpriteTransparencyLevel level = SpriteTransparencyLevel.OPAQUE;
        for (int y = 0; y < nativeImage.length; ++y) {
            int color = nativeImage[y];
            int alpha = ColorABGR.unpackAlpha(color);
            if (alpha > 0) {
                level = alpha < 255 ? level.chooseNextLevel(SpriteTransparencyLevel.TRANSLUCENT) : level.chooseNextLevel(SpriteTransparencyLevel.OPAQUE);
                if (!shouldRewriteColors) continue;
                float weight = alpha;
                r += ColorSRGB.srgbToLinear(ColorABGR.unpackRed(color)) * weight;
                g += ColorSRGB.srgbToLinear(ColorABGR.unpackGreen(color)) * weight;
                b += ColorSRGB.srgbToLinear(ColorABGR.unpackBlue(color)) * weight;
                totalWeight += weight;
                continue;
            }
            level = level.chooseNextLevel(SpriteTransparencyLevel.TRANSPARENT);
        }
        this.celeritas$transparencyLevel = level;
        if (!shouldRewriteColors || totalWeight == 0.0f) {
            return;
        }
        int averageColor = ColorSRGB.linearToSrgb(r /= totalWeight, g /= totalWeight, b /= totalWeight, 0);
        for (int y = 0; y < nativeImage.length; ++y) {
            int color = nativeImage[y];
            int alpha = ColorABGR.unpackAlpha(color);
            if (alpha != 0) continue;
            nativeImage[y] = averageColor;
        }
    }

    @Override
    public SpriteTransparencyLevel celeritas$getTransparencyLevel() {
        return this.celeritas$transparencyLevel;
    }
}

