/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.loading.shared.transformers;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.gtnhlib.asm.ClassConstantPoolParser;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.launchwrapper.Launch;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class SodiumBlockTransform {
    private final boolean IS_OBF;
    private static final boolean LOG_SPAM = Boolean.getBoolean("angelica.redirectorLogspam");
    private static final Logger LOGGER = LogManager.getLogger((String)"SodiumBlockTransformer");
    private static final String BlockClass = "net/minecraft/block/Block";
    private static final String BlockPackage = "net/minecraft/block/Block";
    private static final String ThreadedBlockData = "com/gtnewhorizons/angelica/glsm/ThreadedBlockData";
    private static final List<Pair<String, String>> BlockBoundsFields = ImmutableList.of((Object)Pair.of((Object)"minX", (Object)"field_149759_B"), (Object)Pair.of((Object)"minY", (Object)"field_149760_C"), (Object)Pair.of((Object)"minZ", (Object)"field_149754_D"), (Object)Pair.of((Object)"maxX", (Object)"field_149755_E"), (Object)Pair.of((Object)"maxY", (Object)"field_149756_F"), (Object)Pair.of((Object)"maxZ", (Object)"field_149757_G"));
    private static final String[] VanillaBlockExclusions = new String[]{"net/minecraft/block/IGrowable", "net/minecraft/block/ITileEntityProvider", "net/minecraft/block/BlockEventData", "net/minecraft/block/BlockSourceImpl", "net/minecraft/block/material/"};
    private static final ClassConstantPoolParser cstPoolParser = new ClassConstantPoolParser(new String[]{"net/minecraft/block/Block"});
    private static final Set<String> moddedBlockSubclasses = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final Set<String> blockOwnerExclusions = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final MethodHandle angelicaConfigCeleritasEnabledGetter;
    private static boolean isCeleritasEnabled;

    public SodiumBlockTransform(boolean isObf) {
        this.IS_OBF = isObf;
    }

    private static boolean isCeleritasEnabled() {
        if (isCeleritasEnabled) {
            return true;
        }
        try {
            return angelicaConfigCeleritasEnabledGetter.invokeExact();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isVanillaBlockSubclass(String className) {
        if (className.startsWith("net/minecraft/block/Block")) {
            for (String exclusion : VanillaBlockExclusions) {
                if (!className.startsWith(exclusion)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isBlockSubclass(String className) {
        return this.isVanillaBlockSubclass(className) || moddedBlockSubclasses.contains(className);
    }

    private String getFieldName(Pair<String, String> fieldPair) {
        return this.IS_OBF ? (String)fieldPair.getRight() : (String)fieldPair.getLeft();
    }

    public String[] getTransformerExclusions() {
        return new String[]{"org.lwjgl", "com.gtnewhorizons.angelica.glsm.", "com.gtnewhorizons.angelica.transform", "com.gtnewhorizon.gtnhlib.asm.", "me.eigenraven.lwjgl3ify"};
    }

    public boolean shouldTransform(byte[] basicClass) {
        return cstPoolParser.find(basicClass, true);
    }

    public boolean transformClassNode(String transformedName, ClassNode cn) {
        if (cn == null) {
            return false;
        }
        if ("net.minecraft.block.Block".equals(transformedName) && SodiumBlockTransform.isCeleritasEnabled()) {
            cn.fields.removeIf(field -> BlockBoundsFields.stream().anyMatch(pair -> field.name.equals(pair.getLeft()) || field.name.equals(pair.getRight())));
        }
        if (!this.isVanillaBlockSubclass(cn.name) && this.isBlockSubclass(cn.superName)) {
            moddedBlockSubclasses.add(cn.name);
            cstPoolParser.addString(cn.name);
        }
        if (moddedBlockSubclasses.contains(cn.name)) {
            boolean doWeShadow;
            if (blockOwnerExclusions.contains(cn.superName)) {
                doWeShadow = true;
            } else {
                boolean b = false;
                for (Pair<String, String> pair2 : BlockBoundsFields) {
                    boolean result = false;
                    for (FieldNode field2 : cn.fields) {
                        if (!field2.name.equals(this.getFieldName(pair2))) continue;
                        result = true;
                        break;
                    }
                    if (!result) continue;
                    b = true;
                    break;
                }
                doWeShadow = b;
            }
            if (doWeShadow) {
                LOGGER.info("Class '{}' shadows one or more block bounds fields, these accesses won't be redirected!", new Object[]{cn.name});
                blockOwnerExclusions.add(cn.name);
            }
        }
        boolean changed = false;
        for (MethodNode mn : cn.methods) {
            for (AbstractInsnNode node : mn.instructions.toArray()) {
                Pair fieldToRedirect;
                if (node.getOpcode() != 180 && node.getOpcode() != 181 || !(node instanceof FieldInsnNode)) continue;
                FieldInsnNode fNode = (FieldInsnNode)node;
                if (blockOwnerExclusions.contains(fNode.owner) || !this.isBlockSubclass(fNode.owner) || !SodiumBlockTransform.isCeleritasEnabled() || (fieldToRedirect = (Pair)BlockBoundsFields.stream().filter(pair -> fNode.name.equals(this.getFieldName((Pair<String, String>)pair))).findFirst().orElse(null)) == null) continue;
                if (LOG_SPAM) {
                    LOGGER.info("Redirecting Block.{} in {} to thread-safe wrapper", new Object[]{fNode.name, transformedName});
                }
                fNode.name = (String)fieldToRedirect.getLeft();
                fNode.owner = ThreadedBlockData;
                MethodInsnNode getter = new MethodInsnNode(184, ThreadedBlockData, "get", "(Lnet/minecraft/block/Block;)Lcom/gtnewhorizons/angelica/glsm/ThreadedBlockData;", false);
                if (node.getOpcode() == 180) {
                    mn.instructions.insertBefore((AbstractInsnNode)fNode, (AbstractInsnNode)getter);
                } else if (node.getOpcode() == 181) {
                    InsnList beforePut = new InsnList();
                    beforePut.add((AbstractInsnNode)new InsnNode(93));
                    beforePut.add((AbstractInsnNode)new InsnNode(88));
                    beforePut.add((AbstractInsnNode)getter);
                    beforePut.add((AbstractInsnNode)new InsnNode(91));
                    beforePut.add((AbstractInsnNode)new InsnNode(87));
                    mn.instructions.insertBefore((AbstractInsnNode)fNode, beforePut);
                }
                changed = true;
            }
        }
        return changed;
    }

    public void setCeleritasSetting() {
        isCeleritasEnabled = true;
    }

    static {
        try {
            Class<?> angelicaConfig = Class.forName("com.gtnewhorizons.angelica.config.AngelicaConfig", true, (ClassLoader)Launch.classLoader);
            angelicaConfigCeleritasEnabledGetter = MethodHandles.lookup().findStaticGetter(angelicaConfig, "enableCeleritas", Boolean.TYPE);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

