/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.loading.shared.transformers;

import com.google.common.collect.ImmutableSet;
import com.gtnewhorizon.gtnhlib.asm.ClassConstantPoolParser;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={RedirectMap.class})
public final class AngelicaRedirector {
    private static final boolean ASSERT_MAIN_THREAD = Boolean.getBoolean("angelica.assertMainThread");
    private static final boolean LOG_SPAM = Boolean.getBoolean("angelica.redirectorLogspam");
    private static final Logger LOGGER = LogManager.getLogger((String)"AngelicaRedirector");
    private static final String Drawable = "org/lwjgl/opengl/Drawable";
    private static final String GLStateManager = "com/gtnewhorizons/angelica/glsm/GLStateManager";
    private static final String GL11 = "org/lwjgl/opengl/GL11";
    private static final String GL11C = "org/lwjgl/opengl/GL11C";
    private static final String GL12 = "org/lwjgl/opengl/GL12";
    private static final String GL13 = "org/lwjgl/opengl/GL13";
    private static final String GL14 = "org/lwjgl/opengl/GL14";
    private static final String GL15 = "org/lwjgl/opengl/GL15";
    private static final String GL20 = "org/lwjgl/opengl/GL20";
    private static final String GL30 = "org/lwjgl/opengl/GL30";
    private static final String ARBVertexArrayObject = "org/lwjgl/opengl/ARBVertexArrayObject";
    private static final String APPLEVertexArrayObject = "org/lwjgl/opengl/APPLEVertexArrayObject";
    private static final String Project = "org/lwjgl/util/glu/Project";
    private static final String OpenGlHelper = "net/minecraft/client/renderer/OpenGlHelper";
    private static final String EXTBlendFunc = "org/lwjgl/opengl/EXTBlendFuncSeparate";
    private static final String ARBMultiTexture = "org/lwjgl/opengl/ARBMultitexture";
    private static final String UniversalVAO = "com/gtnewhorizon/gtnhlib/client/opengl/UniversalVAO";
    private static final String UniversalVAODot = "com.gtnewhorizon.gtnhlib.client.opengl.UniversalVAO";
    private static final String VaoFunctions = "com/gtnewhorizon/gtnhlib/client/renderer/vao/VaoFunctions";
    private static final String LWJGLService = "com/mitchej123/lwjgl/LWJGLService";
    private static final Set<String> UniversalVAOSkippedMethods = ImmutableSet.of((Object)"glBindVertexArray", (Object)"glGenVertexArrays", (Object)"glDeleteVertexArrays", (Object)"glIsVertexArray");
    private static final String MinecraftClient = "net.minecraft.client";
    private static final String SplashProgress = "cpw.mods.fml.client.SplashProgress";
    private static final Set<String> ExcludedMinecraftMainThreadChecks = ImmutableSet.of((Object)"startGame", (Object)"func_71384_a", (Object)"initializeTextures", (Object)"func_77474_a");
    private static final ClassConstantPoolParser cstPoolParser = new ClassConstantPoolParser(new String[]{"org/lwjgl/opengl/GL11", "org/lwjgl/opengl/GL12", "org/lwjgl/opengl/GL13", "org/lwjgl/opengl/GL14", "org/lwjgl/opengl/GL20", "net/minecraft/client/renderer/OpenGlHelper", "org/lwjgl/opengl/EXTBlendFuncSeparate", "org/lwjgl/opengl/ARBMultitexture", "org/lwjgl/util/glu/Project"});
    private static final Map<String, Map<String, String>> methodRedirects = new HashMap<String, Map<String, String>>();
    private static final Map<String, Map<String, String>> interfaceRedirects = new HashMap<String, Map<String, String>>();
    private static final Map<Integer, String> glCapRedirects = new HashMap<Integer, String>();

    public String[] getTransformerExclusions() {
        return new String[]{"org.lwjgl", "com.gtnewhorizons.angelica.glsm.", "com.gtnewhorizons.angelica.transform", "com.gtnewhorizon.gtnhlib.asm.", "me.eigenraven.lwjgl3ify"};
    }

    public boolean shouldTransform(byte[] basicClass) {
        return cstPoolParser.find(basicClass, true);
    }

    public boolean transformClassNode(String transformedName, ClassNode cn) {
        if (cn == null) {
            return false;
        }
        boolean changed = false;
        for (MethodNode mn : cn.methods) {
            if (transformedName.equals("net.minecraft.client.renderer.OpenGlHelper") && (mn.name.equals("glBlendFunc") || mn.name.equals("func_148821_a"))) continue;
            boolean redirectInMethod = false;
            for (AbstractInsnNode node : mn.instructions.toArray()) {
                String glsmName;
                Map<String, String> ifaceRedirects;
                String glsmName2;
                if (!(node instanceof MethodInsnNode)) continue;
                MethodInsnNode mNode = (MethodInsnNode)node;
                if ((mNode.owner.equals(GL11) || mNode.owner.equals(GL11C)) && (mNode.name.equals("glEnable") || mNode.name.equals("glDisable")) && mNode.desc.equals("(I)V")) {
                    AbstractInsnNode prevNode = node.getPrevious();
                    String name = null;
                    if (prevNode instanceof LdcInsnNode) {
                        LdcInsnNode ldcNode = (LdcInsnNode)prevNode;
                        name = glCapRedirects.get((Integer)ldcNode.cst);
                    } else if (prevNode instanceof IntInsnNode) {
                        IntInsnNode intNode = (IntInsnNode)prevNode;
                        name = glCapRedirects.get(intNode.operand);
                    }
                    if (name != null) {
                        name = mNode.name.equals("glEnable") ? AngelicaRedirector.jvmdowngrader$concat$transformClassNode$1(name) : AngelicaRedirector.jvmdowngrader$concat$transformClassNode$2(name);
                    }
                    if (LOG_SPAM) {
                        if (name == null) {
                            LOGGER.info("Redirecting call in {} from GL11.{}(I)V to GLStateManager.{}(I)V", new Object[]{transformedName, mNode.name, mNode.name});
                        } else {
                            LOGGER.info("Redirecting call in {} from GL11.{}(I)V to GLStateManager.{}()V", new Object[]{transformedName, mNode.name, name});
                        }
                    }
                    mNode.owner = GLStateManager;
                    if (name != null) {
                        mNode.name = name;
                        mNode.desc = "()V";
                        mn.instructions.remove(prevNode);
                    }
                    changed = true;
                    redirectInMethod = true;
                    continue;
                }
                if (mNode.owner.startsWith(Drawable) && mNode.name.equals("makeCurrent")) {
                    mNode.setOpcode(184);
                    mNode.owner = GLStateManager;
                    mNode.desc = "(Lorg/lwjgl/opengl/Drawable;)V";
                    mNode.itf = false;
                    changed = true;
                    if (!LOG_SPAM) continue;
                    LOGGER.info("Redirecting call in {} to GLStateManager.makeCurrent()", new Object[]{transformedName});
                    continue;
                }
                Map<String, String> redirects = methodRedirects.get(mNode.owner);
                if (!(redirects == null || (glsmName2 = redirects.get(mNode.name)) == null || transformedName.startsWith(UniversalVAODot) && UniversalVAOSkippedMethods.contains(glsmName2))) {
                    if (LOG_SPAM) {
                        String shortOwner = mNode.owner.substring(mNode.owner.lastIndexOf("/") + 1);
                        LOGGER.info("Redirecting call in {} from {}.{}{} to GLStateManager.{}{}", new Object[]{transformedName, shortOwner, mNode.name, mNode.desc, glsmName2, mNode.desc});
                    }
                    mNode.owner = GLStateManager;
                    mNode.name = glsmName2;
                    changed = true;
                    redirectInMethod = true;
                }
                if (mNode.getOpcode() != 185 && mNode.getOpcode() != 182 || !mNode.desc.equals("(I)V") || (ifaceRedirects = interfaceRedirects.get(mNode.owner)) == null || (glsmName = ifaceRedirects.get(mNode.name)) == null || transformedName.startsWith(UniversalVAODot) && UniversalVAOSkippedMethods.contains(glsmName)) continue;
                if (LOG_SPAM) {
                    String shortOwner = mNode.owner.substring(mNode.owner.lastIndexOf("/") + 1);
                    LOGGER.info("Redirecting interface call in {} from {}.{}{} to GLStateManager.{}{}", new Object[]{transformedName, shortOwner, mNode.name, mNode.desc, glsmName, "(I)V"});
                }
                mn.instructions.insertBefore((AbstractInsnNode)mNode, (AbstractInsnNode)new InsnNode(95));
                mn.instructions.insertBefore((AbstractInsnNode)mNode, (AbstractInsnNode)new InsnNode(87));
                mNode.setOpcode(184);
                mNode.owner = GLStateManager;
                mNode.name = glsmName;
                mNode.desc = "(I)V";
                mNode.itf = false;
                changed = true;
                redirectInMethod = true;
            }
            if (!ASSERT_MAIN_THREAD || !redirectInMethod || transformedName.startsWith(SplashProgress) || transformedName.startsWith(MinecraftClient) && ExcludedMinecraftMainThreadChecks.contains(mn.name)) continue;
            mn.instructions.insert((AbstractInsnNode)new MethodInsnNode(184, GLStateManager, "assertMainThread", "()V", false));
        }
        return changed;
    }

    static {
        glCapRedirects.put(3008, "AlphaTest");
        glCapRedirects.put(3042, "Blend");
        glCapRedirects.put(2929, "DepthTest");
        glCapRedirects.put(2884, "Cull");
        glCapRedirects.put(2896, "Lighting");
        glCapRedirects.put(3553, "Texture");
        glCapRedirects.put(2912, "Fog");
        glCapRedirects.put(32826, "RescaleNormal");
        glCapRedirects.put(3089, "ScissorTest");
        methodRedirects.put(GL11, RedirectMap.newMap().add("glAlphaFunc").add("glBegin").add("glBindTexture").add("glBlendFunc").add("glCallList").add("glCallLists").add("glClear").add("glClearColor").add("glClearDepth").add("glClearStencil").add("glClipPlane").add("glColor3b").add("glColor3d").add("glColor3f").add("glColor3ub").add("glColor4b").add("glColor4d").add("glColor4f").add("glColor4ub").add("glColorMask").add("glColorMaterial").add("glDeleteLists").add("glDeleteTextures").add("glDepthFunc").add("glDepthMask").add("glDepthRange").add("glDrawArrays").add("glDrawBuffer").add("glDrawElements").add("glEdgeFlag").add("glEnd").add("glEndList").add("glFog").add("glFogf").add("glFogi").add("glFrustum").add("glGetBoolean").add("glGetFloat").add("glGetInteger").add("glGetLight").add("glGetMaterial").add("glGetTexLevelParameteri").add("glGetTexParameterf").add("glGetTexParameteri").add("glIsEnabled").add("glMaterial").add("glMaterialf").add("glMateriali").add("glLight").add("glLightf").add("glLighti").add("glLightModel").add("glLightModelf").add("glLightModeli").add("glLineStipple").add("glLineWidth").add("glListBase").add("glLoadIdentity").add("glLoadMatrix").add("glLogicOp").add("glMatrixMode").add("glMultMatrix").add("glNewList").add("glNormal3b").add("glNormal3d").add("glNormal3f").add("glNormal3i").add("glOrtho").add("glPopAttrib").add("glPopMatrix").add("glPushAttrib").add("glPushMatrix").add("glRasterPos2d").add("glRasterPos2f").add("glRasterPos2i").add("glRasterPos3d").add("glRasterPos3f").add("glRasterPos3i").add("glRasterPos4d").add("glRasterPos4f").add("glRasterPos4i").add("glRotated").add("glRotatef").add("glScaled").add("glScalef").add("glShadeModel").add("glTexCoord1d").add("glTexCoord1f").add("glTexCoord2d").add("glTexCoord2f").add("glTexCoord3d").add("glTexCoord3f").add("glTexCoord4d").add("glTexCoord4f").add("glTexImage1D").add("glTexImage2D").add("glTexImage3D").add("glTexSubImage1D").add("glTexSubImage2D").add("glCopyTexImage1D").add("glCopyTexImage2D").add("glCopyTexSubImage1D").add("glCopyTexSubImage2D").add("glPixelStoref").add("glPixelStorei").add("glTexParameter").add("glTexParameterf").add("glTexParameteri").add("glTexParameteri").add("glCullFace").add("glFrontFace").add("glHint").add("glLineStipple").add("glLineWidth").add("glPointSize").add("glPolygonMode").add("glPolygonOffset").add("glReadBuffer").add("glSampleCoverage").add("glScissor").add("glStencilFunc").add("glStencilFuncSeparate").add("glStencilMask").add("glStencilMaskSeparate").add("glStencilOp").add("glStencilOpSeparate").add("glTranslated").add("glTranslatef").add("glVertex2d").add("glVertex2f").add("glVertex3d").add("glVertex3f").add("glVertexPointer").add("glColorPointer").add("glEnableClientState").add("glDisableClientState").add("glViewport"));
        methodRedirects.put(GL12, RedirectMap.newMap().add("glTexImage3D").add("glTexSubImage3D").add("glCopyTexSubImage3D"));
        methodRedirects.put(GL13, RedirectMap.newMap().add("glActiveTexture").add("glSampleCoverage"));
        methodRedirects.put(GL14, RedirectMap.newMap().add("glBlendFuncSeparate", "tryBlendFuncSeparate").add("glBlendColor").add("glBlendEquation"));
        methodRedirects.put(GL15, RedirectMap.newMap().add("glBindBuffer"));
        methodRedirects.put(GL20, RedirectMap.newMap().add("glBlendEquationSeparate").add("glDrawBuffers").add("glStencilFuncSeparate").add("glStencilMaskSeparate").add("glStencilOpSeparate").add("glUseProgram"));
        methodRedirects.put(GL30, RedirectMap.newMap().add("glBindVertexArray").add("glBindFramebuffer"));
        methodRedirects.put(OpenGlHelper, RedirectMap.newMap().add("glBlendFunc", "tryBlendFuncSeparate").add("func_148821_a", "tryBlendFuncSeparate").add("func_153171_g", "glBindFramebuffer").add("func_153174_h", "glDeleteFramebuffers").add("func_153165_e", "glGenFramebuffers").add("func_153167_i", "glCheckFramebufferStatus").add("func_153188_a", "glFramebufferTexture2D").add("setActiveTexture").add("setLightmapTextureCoords").add("isFramebufferEnabled"));
        methodRedirects.put(EXTBlendFunc, RedirectMap.newMap().add("glBlendFuncSeparateEXT", "tryBlendFuncSeparate"));
        methodRedirects.put(ARBMultiTexture, RedirectMap.newMap().add("glActiveTextureARB"));
        methodRedirects.put(ARBVertexArrayObject, RedirectMap.newMap().add("glBindVertexArray"));
        methodRedirects.put(APPLEVertexArrayObject, RedirectMap.newMap().add("glBindVertexArrayAPPLE", "glBindVertexArray"));
        methodRedirects.put(UniversalVAO, RedirectMap.newMap().add("bindVertexArray", "glBindVertexArray"));
        methodRedirects.put(Project, RedirectMap.newMap().add("gluPerspective"));
        interfaceRedirects.put(VaoFunctions, RedirectMap.newMap().add("glBindVertexArray"));
        interfaceRedirects.put(LWJGLService, RedirectMap.newMap().add("glBindVertexArray"));
        cstPoolParser.addString(UniversalVAO);
        cstPoolParser.addString(VaoFunctions);
        cstPoolParser.addString(LWJGLService);
        String glPrefix = "org/lwjgl/opengl/GL";
        for (Map.Entry<String, Map<String, String>> entry : new HashMap<String, Map<String, String>>(methodRedirects).entrySet()) {
            if (!entry.getKey().startsWith("org/lwjgl/opengl/GL")) continue;
            methodRedirects.put(AngelicaRedirector.jvmdowngrader$concat$$clinit$$1(entry.getKey()), entry.getValue());
            cstPoolParser.addString(AngelicaRedirector.jvmdowngrader$concat$$clinit$$1(entry.getKey()));
        }
    }

    private static /* synthetic */ String jvmdowngrader$concat$transformClassNode$1(String string) {
        return "enable" + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$transformClassNode$2(String string) {
        return "disable" + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$$clinit$$1(String string) {
        return string + "C";
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=AngelicaRedirector.class)
    private static final class RedirectMap<K>
    extends HashMap<K, K> {
        private RedirectMap() {
        }

        public static RedirectMap<String> newMap() {
            return new RedirectMap<String>();
        }

        public RedirectMap<K> add(K name) {
            this.put(name, name);
            return this;
        }

        public RedirectMap<K> add(K name, K newName) {
            this.put(name, newName);
            return this;
        }
    }
}

