/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.loading.fml.transformers;

import com.gtnewhorizons.angelica.loading.shared.AngelicaClassDump;
import com.gtnewhorizons.angelica.loading.shared.transformers.AngelicaRedirector;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class AngelicaRedirectorTransformer
implements IClassTransformer {
    private final AngelicaRedirector inner = new AngelicaRedirector();
    private final String[] exclusions = this.inner.getTransformerExclusions();

    public byte[] transform(String className, String transformedName, byte[] basicClass) {
        if (basicClass == null) {
            return null;
        }
        for (String exclusion : this.exclusions) {
            if (!transformedName.startsWith(exclusion)) continue;
            return basicClass;
        }
        if (!this.inner.shouldTransform(basicClass)) {
            return basicClass;
        }
        ClassReader cr = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        boolean changed = this.inner.transformClassNode(transformedName, cn);
        if (changed) {
            ClassWriter cw = new ClassWriter(1);
            cn.accept((ClassVisitor)cw);
            byte[] bytes = cw.toByteArray();
            AngelicaClassDump.dumpClass(transformedName, basicClass, bytes, this);
            return bytes;
        }
        return basicClass;
    }
}

