/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.loading.fml.compat.transformers.specific;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizons.angelica.loading.AngelicaTweaker;
import com.gtnewhorizons.angelica.loading.shared.AngelicaClassDump;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import org.spongepowered.asm.lib.ClassReader;
import org.spongepowered.asm.lib.ClassVisitor;
import org.spongepowered.asm.lib.ClassWriter;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.FieldNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.InsnNode;
import org.spongepowered.asm.lib.tree.LabelNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.lib.tree.TypeInsnNode;
import org.spongepowered.asm.lib.tree.VarInsnNode;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class StacksOnStacksTransformer
implements IClassTransformer {
    private static final String RenderTilePile = "com.tierzero.stacksonstacks.client.render.RenderTilePile";
    private static final List<String> staticRemovers = ImmutableList.of((Object)"ingotRender", (Object)"gemRender", (Object)"dustRender");
    private static final String ClientUtils = "com.tierzero.stacksonstacks.util.ClientUtils";

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null) {
            return null;
        }
        if (!transformedName.equals(RenderTilePile) && !transformedName.equals(ClientUtils)) {
            return basicClass;
        }
        ClassReader cr = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        if (transformedName.equals(RenderTilePile)) {
            StacksOnStacksTransformer.transformRenderTilePile(cn);
        } else {
            StacksOnStacksTransformer.transformClientUtils(cn);
        }
        ClassWriter cw = new ClassWriter(0);
        cn.accept((ClassVisitor)cw);
        byte[] bytes = cw.toByteArray();
        AngelicaTweaker.LOGGER.info("[AngelicaCompat]Extra Transformers: Applied StacksOnStacksTransformer");
        AngelicaClassDump.dumpClass(transformedName, basicClass, bytes, this);
        return bytes;
    }

    private static InsnList buildPilerRenderInitializer(String type) {
        LabelNode start = new LabelNode();
        LabelNode end = new LabelNode();
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)start);
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new TypeInsnNode(187, StacksOnStacksTransformer.jvmdowngrader$concat$buildPilerRenderInitializer$1(type)));
        list.add((AbstractInsnNode)new InsnNode(89));
        list.add((AbstractInsnNode)new MethodInsnNode(183, StacksOnStacksTransformer.jvmdowngrader$concat$buildPilerRenderInitializer$1(type), "<init>", "()V"));
        list.add((AbstractInsnNode)new FieldInsnNode(181, "com/tierzero/stacksonstacks/client/render/RenderTilePile", StacksOnStacksTransformer.jvmdowngrader$concat$buildPilerRenderInitializer$2(type.toLowerCase()), "Lcom/tierzero/stacksonstacks/client/render/PileRender;"));
        list.add((AbstractInsnNode)end);
        return list;
    }

    private static void transformRenderTilePile(ClassNode cn) {
        MethodNode clinit = null;
        for (MethodNode mn : cn.methods) {
            if (mn.name.equals("<init>")) {
                AbstractInsnNode objectInsn = null;
                for (int i = 0; i < mn.instructions.size(); ++i) {
                    AbstractInsnNode ain = mn.instructions.get(i);
                    if (ain.getOpcode() == 177) {
                        mn.instructions.remove(ain);
                    }
                    if (ain.getOpcode() != 183) continue;
                    objectInsn = mn.instructions.get(i);
                }
                InsnList ingotRender = StacksOnStacksTransformer.buildPilerRenderInitializer("Ingot");
                InsnList gemRender = StacksOnStacksTransformer.buildPilerRenderInitializer("Gem");
                InsnList dustRender = StacksOnStacksTransformer.buildPilerRenderInitializer("Dust");
                dustRender.add((AbstractInsnNode)new InsnNode(177));
                mn.instructions.insert(objectInsn, dustRender);
                mn.instructions.insert(objectInsn, gemRender);
                mn.instructions.insert(objectInsn, ingotRender);
            }
            if (mn.name.equals("<clinit>")) {
                clinit = mn;
            }
            if (!mn.name.equals("renderWorldBlock")) continue;
            for (int i = 0; i < mn.instructions.size(); ++i) {
                FieldInsnNode fin;
                AbstractInsnNode in = mn.instructions.get(i);
                if (!(in instanceof FieldInsnNode) || (fin = (FieldInsnNode)in).getOpcode() != 178 || !staticRemovers.contains(fin.name)) continue;
                FieldInsnNode nonStatic = new FieldInsnNode(180, "com/tierzero/stacksonstacks/client/render/RenderTilePile", fin.name, "Lcom/tierzero/stacksonstacks/client/render/PileRender;");
                mn.instructions.insertBefore((AbstractInsnNode)fin, (AbstractInsnNode)new VarInsnNode(25, 0));
                mn.instructions.insertBefore((AbstractInsnNode)fin, (AbstractInsnNode)nonStatic);
                mn.instructions.remove((AbstractInsnNode)fin);
            }
        }
        if (clinit != null) {
            cn.methods.remove(clinit);
        }
        for (FieldNode fn : cn.fields) {
            if (!staticRemovers.contains(fn.name)) continue;
            fn.access &= 0xFFFFFFF7;
        }
    }

    private static void transformClientUtils(ClassNode cn) {
        for (MethodNode mn : cn.methods) {
            AbstractInsnNode in;
            int i;
            if (mn.name.equals("pushMatrix")) {
                for (i = 0; i < mn.instructions.size(); ++i) {
                    in = mn.instructions.get(i);
                    if (in.getOpcode() != 184) continue;
                    mn.instructions.remove(in);
                }
                continue;
            }
            if (!mn.name.equals("popMatrix")) continue;
            for (i = 0; i < mn.instructions.size(); ++i) {
                in = mn.instructions.get(i);
                if (in.getOpcode() != 184) continue;
                mn.instructions.remove(in);
            }
        }
    }

    private static /* synthetic */ String jvmdowngrader$concat$buildPilerRenderInitializer$1(String string) {
        return "com/tierzero/stacksonstacks/client/render/PileRender" + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$buildPilerRenderInitializer$2(String string) {
        return string + "Render";
    }
}

