/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.hudcaching;

import com.gtnewhorizon.gtnhlib.client.renderer.DirectTessellator;
import com.gtnewhorizon.gtnhlib.client.renderer.TessellatorManager;
import com.gtnewhorizon.gtnhlib.client.renderer.postprocessing.SharedDepthFramebuffer;
import com.gtnewhorizon.gtnhlib.client.renderer.vao.IVertexArrayObject;
import com.gtnewhorizon.gtnhlib.client.renderer.vao.VertexBufferType;
import com.gtnewhorizon.gtnhlib.client.renderer.vertex.DefaultVertexFormat;
import com.gtnewhorizon.gtnhlib.client.renderer.vertex.VertexFormat;
import com.gtnewhorizons.angelica.compat.ModStatus;
import com.gtnewhorizons.angelica.compat.holoinventory.HoloInventoryReflectionCompat;
import com.gtnewhorizons.angelica.config.AngelicaConfig;
import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.mixins.interfaces.GuiIngameAccessor;
import com.gtnewhorizons.angelica.mixins.interfaces.GuiIngameForgeAccessor;
import com.gtnewhorizons.angelica.mixins.interfaces.RenderGameOverlayEventAccessor;
import com.kentington.thaumichorizons.common.ThaumicHorizons;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import thaumcraft.common.Thaumcraft;
import xaero.common.core.XaeroMinimapCore;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={HUDCachingHooks.class})
public class HUDCaching {
    private static final Minecraft mc = Minecraft.func_71410_x();
    public static SharedDepthFramebuffer framebuffer;
    private static boolean dirty;
    private static long nextHudRefresh;
    private static IVertexArrayObject quadVAO;
    private static float quadWidth;
    private static float quadHeight;
    public static boolean renderingCacheOverride;
    public static boolean renderVignetteCaptured;
    public static boolean renderHelmetCaptured;
    public static float renderPortalCapturedTicks;
    public static boolean renderCrosshairsCaptured;
    private static final RenderGameOverlayEvent fakeTextEvent;
    private static final RenderGameOverlayEvent.Post fakePostEvent;

    public static void init() {
        framebuffer = new SharedDepthFramebuffer(5);
    }

    public static void renderCachedHud(EntityRenderer renderer, GuiIngame ingame, float partialTicks, boolean hasScreen, int mouseX, int mouseY) {
        if (ModStatus.isXaerosMinimapLoaded && ingame instanceof GuiIngameForge) {
            XaeroMinimapCore.beforeIngameGuiRender((float)partialTicks);
        }
        if (!AngelicaConfig.hudCachingActive || !GLStateManager.isFramebufferEnabled()) {
            ingame.func_73830_a(partialTicks, hasScreen, mouseX, mouseY);
            return;
        }
        if (System.currentTimeMillis() > nextHudRefresh) {
            dirty = true;
        }
        if (dirty) {
            dirty = false;
            nextHudRefresh = System.currentTimeMillis() + (long)(1000 / AngelicaConfig.hudCachingFPS);
            if (HUDCaching.framebuffer.framebufferWidth != HUDCaching.mc.field_71443_c || HUDCaching.framebuffer.framebufferHeight != HUDCaching.mc.field_71440_d) {
                framebuffer.createBindFramebuffer(HUDCaching.mc.field_71443_c, HUDCaching.mc.field_71440_d);
            } else {
                framebuffer.clearBindFramebuffer();
            }
            renderingCacheOverride = true;
            ingame.func_73830_a(partialTicks, hasScreen, mouseX, mouseY);
            renderingCacheOverride = false;
            mc.func_147110_a().func_147610_a(false);
        } else {
            renderer.func_78478_c();
        }
        ScaledResolution resolution = new ScaledResolution(mc, HUDCaching.mc.field_71443_c, HUDCaching.mc.field_71440_d);
        int width = resolution.func_78326_a();
        int height = resolution.func_78328_b();
        GLStateManager.enableBlend();
        GLStateManager.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GuiIngameAccessor gui = (GuiIngameAccessor)ingame;
        if (renderVignetteCaptured) {
            gui.callRenderVignette(HUDCaching.mc.field_71439_g.func_70013_c(partialTicks), width, height);
        } else {
            GLStateManager.tryBlendFuncSeparate(770, 771, 1, 0);
        }
        if (ingame instanceof GuiIngameForge) {
            GuiIngameForgeAccessor guiForge = (GuiIngameForgeAccessor)ingame;
            if (renderHelmetCaptured) {
                guiForge.callRenderHelmet(resolution, partialTicks, hasScreen, mouseX, mouseY);
                if (ModStatus.isHoloInventoryLoaded) {
                    HoloInventoryReflectionCompat.setAngelicaOverride(false);
                    ((RenderGameOverlayEventAccessor)fakePostEvent).setPartialTicks(partialTicks);
                    HoloInventoryReflectionCompat.renderEvent((RenderGameOverlayEvent)fakePostEvent);
                }
            }
            if (renderPortalCapturedTicks > 0.0f) {
                guiForge.callRenderPortal(width, height, partialTicks);
            }
            if (renderCrosshairsCaptured) {
                if (ModStatus.isXaerosMinimapLoaded) {
                    GLStateManager.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                }
                guiForge.callRenderCrosshairs(width, height);
            }
            if (ModStatus.isThaumcraftLoaded || ModStatus.isThaumicHorizonsLoaded) {
                ((RenderGameOverlayEventAccessor)fakeTextEvent).setPartialTicks(partialTicks);
                ((RenderGameOverlayEventAccessor)fakeTextEvent).setResolution(resolution);
                ((RenderGameOverlayEventAccessor)fakeTextEvent).setMouseX(mouseX);
                ((RenderGameOverlayEventAccessor)fakeTextEvent).setMouseY(mouseY);
                if (ModStatus.isThaumcraftLoaded) {
                    Thaumcraft.instance.renderEventHandler.renderOverlay(fakeTextEvent);
                }
                if (ModStatus.isThaumicHorizonsLoaded) {
                    ThaumicHorizons.instance.renderEventHandler.renderOverlay(fakeTextEvent);
                }
            }
        } else {
            if (renderHelmetCaptured) {
                gui.callRenderPumpkinBlur(width, height);
            }
            if (renderPortalCapturedTicks > 0.0f) {
                gui.callRenderPortal(renderPortalCapturedTicks, width, height);
            }
        }
        GLStateManager.enableBlend();
        GLStateManager.tryBlendFuncSeparate(1, 771, 1, 771);
        GLStateManager.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        framebuffer.bindFramebufferTexture();
        HUDCaching.drawTexturedRect((float)resolution.func_78327_c(), (float)resolution.func_78324_d());
        GLStateManager.tryBlendFuncSeparate(1, 771, 1, 0);
        mc.func_110434_K().func_110577_a(Gui.field_110324_m);
    }

    public static void fixGLStateBeforeRenderingCache() {
        GLStateManager.glDepthMask(true);
        GLStateManager.enableDepthTest();
        GLStateManager.enableAlphaTest();
        GLStateManager.tryBlendFuncSeparate(770, 771, 1, 0);
        GLStateManager.disableBlend();
    }

    private static void drawTexturedRect(float width, float height) {
        if (quadWidth != width || quadHeight != height) {
            quadWidth = width;
            quadHeight = height;
            HUDCaching.rebuildVAO(width, height);
        }
        GLStateManager.disableDepthTest();
        GLStateManager.enableTexture();
        quadVAO.render();
        GLStateManager.enableDepthTest();
    }

    private static void rebuildVAO(float width, float height) {
        DirectTessellator tessellator = TessellatorManager.startCapturingDirect((VertexFormat)DefaultVertexFormat.POSITION_TEXTURE);
        tessellator.func_78382_b();
        tessellator.func_78374_a(0.0, (double)height, 0.0, 0.0, 0.0);
        tessellator.func_78374_a((double)width, (double)height, 0.0, 1.0, 0.0);
        tessellator.func_78374_a((double)width, 0.0, 0.0, 1.0, 1.0);
        tessellator.func_78374_a(0.0, 0.0, 0.0, 0.0, 1.0);
        tessellator.func_78381_a();
        if (quadVAO == null) {
            quadVAO = tessellator.uploadToVBO(VertexBufferType.MUTABLE);
        } else {
            tessellator.updateToVBO(quadVAO.getVBO());
        }
        TessellatorManager.stopCapturingDirect();
    }

    public static void disableHoloInventory() {
        if (ModStatus.isHoloInventoryLoaded) {
            HoloInventoryReflectionCompat.setAngelicaOverride(true);
        }
    }

    static {
        dirty = true;
        fakeTextEvent = new RenderGameOverlayEvent.Text(new RenderGameOverlayEvent(0.0f, null, 0, 0), null, null);
        fakePostEvent = new RenderGameOverlayEvent.Post(new RenderGameOverlayEvent(0.0f, null, 0, 0), RenderGameOverlayEvent.ElementType.HELMET);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=HUDCaching.class)
    public static class HUDCachingHooks {
        public static boolean shouldReturnEarly() {
            return renderingCacheOverride;
        }
    }
}

