/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.glsm.texture;

import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.glsm.RenderSystem;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.coderbot.iris.Iris;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.minecraft.client.renderer.texture.AbstractTexture;
import org.jetbrains.annotations.Nullable;

public class TextureTracker {
    public static final TextureTracker INSTANCE = new TextureTracker();
    private final Int2ObjectMap<AbstractTexture> textures = new Int2ObjectOpenHashMap();
    private boolean lockBindCallback;

    private TextureTracker() {
    }

    public void trackTexture(int id, AbstractTexture texture) {
        this.textures.put(id, (Object)texture);
    }

    @Nullable
    public AbstractTexture getTexture(int id) {
        return (AbstractTexture)this.textures.get(id);
    }

    public void onBindTexture(int id) {
        if (this.lockBindCallback) {
            return;
        }
        if (GLStateManager.getActiveTextureUnit() == 0) {
            WorldRenderingPipeline pipeline;
            this.lockBindCallback = true;
            if (Iris.enabled && (pipeline = Iris.getPipelineManager().getPipelineNullable()) != null) {
                pipeline.onBindTexture(id);
            }
            RenderSystem.bindTextureToUnit(0, id);
            this.lockBindCallback = false;
        }
    }

    public void onDeleteTexture(int id) {
        this.textures.remove(id);
    }
}

