/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.glsm.stacks;

import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.glsm.stacks.BooleanStateStack;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;

public class TextureUnitBooleanStateStack
extends BooleanStateStack {
    private final int unitIndex;

    public TextureUnitBooleanStateStack(int glCap, int unitIndex) {
        super(glCap);
        this.unitIndex = unitIndex;
    }

    public TextureUnitBooleanStateStack(int glCap, int unitIndex, boolean initialState) {
        super(glCap, initialState);
        this.unitIndex = unitIndex;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.beforeModify();
        this.setEnabledWithUnitSwitch(enabled);
    }

    @Override
    public TextureUnitBooleanStateStack popDepth() {
        if (this.savedDepth > 0) {
            boolean oldValue = this.stack[--this.savedDepth];
            this.setEnabledWithUnitSwitch(oldValue);
        }
        return this;
    }

    private void setEnabledWithUnitSwitch(boolean enabled) {
        boolean bypass = GLStateManager.shouldBypassCache();
        if (bypass || enabled != this.enabled) {
            int currentUnit;
            boolean needsSwitch;
            if (!bypass) {
                this.enabled = enabled;
            }
            boolean bl = needsSwitch = (currentUnit = GLStateManager.getActiveTextureUnit()) != this.unitIndex;
            if (needsSwitch) {
                GL13.glActiveTexture((int)(33984 + this.unitIndex));
            }
            if (enabled) {
                GL11.glEnable((int)this.glCap);
            } else {
                GL11.glDisable((int)this.glCap);
            }
            if (needsSwitch) {
                GL13.glActiveTexture((int)(33984 + currentUnit));
            }
        }
    }

    public int getUnitIndex() {
        return this.unitIndex;
    }
}

