/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.glsm.stacks;

import com.gtnewhorizon.gtnhlib.client.renderer.stacks.IStateStack;
import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.glsm.states.BooleanState;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class BooleanStateStack
extends BooleanState
implements IStateStack<BooleanStateStack> {
    protected final boolean[] stack;
    protected int savedDepth;

    public BooleanStateStack(int glCap) {
        this(glCap, false);
    }

    public BooleanStateStack(int glCap, boolean initialState) {
        super(glCap);
        this.enabled = initialState;
        this.stack = new boolean[GLStateManager.MAX_ATTRIB_STACK_DEPTH];
    }

    public BooleanStateStack push() {
        if (this.savedDepth >= this.stack.length) {
            throw new IllegalStateException(BooleanStateStack.jvmdowngrader$concat$push$1(this.savedDepth + 1));
        }
        this.stack[this.savedDepth++] = this.enabled;
        return this;
    }

    public BooleanStateStack pop() {
        if (this.savedDepth == 0) {
            throw new IllegalStateException("Stack underflow");
        }
        boolean oldValue = this.stack[--this.savedDepth];
        this.setEnabledDirect(oldValue);
        return this;
    }

    public boolean isEmpty() {
        return this.savedDepth == 0;
    }

    public int pushDepth() {
        return GLStateManager.getAttribDepth();
    }

    public BooleanStateStack popDepth() {
        if (this.savedDepth > 0) {
            boolean oldValue = this.stack[--this.savedDepth];
            this.setEnabledDirect(oldValue);
        }
        return this;
    }

    public void beforeModify() {
        int globalDepth = GLStateManager.getAttribDepth();
        if (this.savedDepth < globalDepth) {
            this.stack[this.savedDepth++] = this.enabled;
            GLStateManager.registerModifiedState(this);
        }
    }

    public int getDepth() {
        return GLStateManager.getAttribDepth();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.beforeModify();
        super.setEnabled(enabled);
    }

    private void setEnabledDirect(boolean enabled) {
        super.setEnabled(enabled);
    }

    private static /* synthetic */ String jvmdowngrader$concat$push$1(int n) {
        return "Stack overflow size " + n + " reached";
    }
}

