/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.glsm.recording.commands;

import com.gtnewhorizons.angelica.glsm.GLDebug;
import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.glsm.recording.commands.DisplayListCommand;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;
import xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;
import xyz.wagyourtail.jvmdg.j9.stub.java_base.J_N_Buffer;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@RecordComponents(value={@RecordComponents.Value(name="target", type=int.class), @RecordComponents.Value(name="level", type=int.class), @RecordComponents.Value(name="internalformat", type=int.class), @RecordComponents.Value(name="width", type=int.class), @RecordComponents.Value(name="height", type=int.class), @RecordComponents.Value(name="border", type=int.class), @RecordComponents.Value(name="format", type=int.class), @RecordComponents.Value(name="type", type=int.class), @RecordComponents.Value(name="pixelData", type=byte[].class)})
public final class TexImage2DCmd
extends J_L_Record
implements DisplayListCommand {
    private final int target;
    private final int level;
    private final int internalformat;
    private final int width;
    private final int height;
    private final int border;
    private final int format;
    private final int type;
    @Nullable
    private final byte[] pixelData;

    public TexImage2DCmd(int target, int level, int internalformat, int width, int height, int border, int format, int type, @Nullable byte[] pixelData) {
        this.target = target;
        this.level = level;
        this.internalformat = internalformat;
        this.width = width;
        this.height = height;
        this.border = border;
        this.format = format;
        this.type = type;
        this.pixelData = pixelData;
    }

    public static TexImage2DCmd fromIntBuffer(int target, int level, int internalformat, int width, int height, int border, int format, int type, @Nullable IntBuffer pixels) {
        byte[] data = null;
        if (pixels != null) {
            int pos = pixels.position();
            int limit = pixels.limit();
            int size = (limit - pos) * 4;
            data = new byte[size];
            ByteBuffer bb = ByteBuffer.wrap(data).order(ByteOrder.nativeOrder());
            bb.asIntBuffer().put(pixels);
            IntBuffer cfr_ignored_0 = (IntBuffer)J_N_Buffer.position((Buffer)pixels, (int)pos);
        }
        return new TexImage2DCmd(target, level, internalformat, width, height, border, format, type, data);
    }

    public static TexImage2DCmd fromFloatBuffer(int target, int level, int internalformat, int width, int height, int border, int format, int type, @Nullable FloatBuffer pixels) {
        byte[] data = null;
        if (pixels != null) {
            int pos = pixels.position();
            int limit = pixels.limit();
            int size = (limit - pos) * 4;
            data = new byte[size];
            ByteBuffer bb = ByteBuffer.wrap(data).order(ByteOrder.nativeOrder());
            bb.asFloatBuffer().put(pixels);
            FloatBuffer cfr_ignored_0 = (FloatBuffer)J_N_Buffer.position((Buffer)pixels, (int)pos);
        }
        return new TexImage2DCmd(target, level, internalformat, width, height, border, format, type, data);
    }

    public static TexImage2DCmd fromDoubleBuffer(int target, int level, int internalformat, int width, int height, int border, int format, int type, @Nullable DoubleBuffer pixels) {
        byte[] data = null;
        if (pixels != null) {
            int pos = pixels.position();
            int limit = pixels.limit();
            int size = (limit - pos) * 8;
            data = new byte[size];
            ByteBuffer bb = ByteBuffer.wrap(data).order(ByteOrder.nativeOrder());
            bb.asDoubleBuffer().put(pixels);
            DoubleBuffer cfr_ignored_0 = (DoubleBuffer)J_N_Buffer.position((Buffer)pixels, (int)pos);
        }
        return new TexImage2DCmd(target, level, internalformat, width, height, border, format, type, data);
    }

    public static TexImage2DCmd fromByteBuffer(int target, int level, int internalformat, int width, int height, int border, int format, int type, @Nullable ByteBuffer pixels) {
        byte[] data = null;
        if (pixels != null) {
            int pos = pixels.position();
            int limit = pixels.limit();
            int size = limit - pos;
            data = new byte[size];
            pixels.get(data);
            ByteBuffer cfr_ignored_0 = (ByteBuffer)J_N_Buffer.position((Buffer)pixels, (int)pos);
        }
        return new TexImage2DCmd(target, level, internalformat, width, height, border, format, type, data);
    }

    @Override
    public void execute() {
        ByteBuffer buffer = null;
        if (this.pixelData != null) {
            buffer = ByteBuffer.allocateDirect(this.pixelData.length).order(ByteOrder.nativeOrder());
            buffer.put(this.pixelData);
            ByteBuffer cfr_ignored_0 = (ByteBuffer)J_N_Buffer.flip((Buffer)buffer);
        }
        GLStateManager.glTexImage2D(this.target, this.level, this.internalformat, this.width, this.height, this.border, this.format, this.type, buffer);
    }

    @NotNull
    public String toString() {
        String dataStr = this.pixelData != null ? TexImage2DCmd.jvmdowngrader$concat$toString$1(this.pixelData.length) : "null";
        return String.format("TexImage2D(target=%s, level=%d, internalformat=%s, %dx%d, border=%d, format=%s, type=%s, data=%s)", GLDebug.getTextureTargetName(this.target), this.level, GLDebug.getTextureFormatName(this.internalformat), this.width, this.height, this.border, GLDebug.getTextureFormatName(this.format), GLDebug.getDataTypeName(this.type), dataStr);
    }

    public final int hashCode() {
        return TexImage2DCmd.jvmdowngrader$hashCode$hashCode(this);
    }

    public final boolean equals(Object o) {
        return TexImage2DCmd.jvmdowngrader$equals$equals(this, o);
    }

    public int target() {
        return this.target;
    }

    public int level() {
        return this.level;
    }

    public int internalformat() {
        return this.internalformat;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public int border() {
        return this.border;
    }

    public int format() {
        return this.format;
    }

    public int type() {
        return this.type;
    }

    @Nullable
    public byte[] pixelData() {
        return this.pixelData;
    }

    private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(TexImage2DCmd texImage2DCmd) {
        Object[] objectArray = new Object[]{texImage2DCmd.target, texImage2DCmd.level, texImage2DCmd.internalformat, texImage2DCmd.width, texImage2DCmd.height, texImage2DCmd.border, texImage2DCmd.format, texImage2DCmd.type, texImage2DCmd.pixelData};
        return Arrays.hashCode(objectArray);
    }

    private static /* synthetic */ boolean jvmdowngrader$equals$equals(TexImage2DCmd texImage2DCmd, Object object) {
        if (texImage2DCmd == object) {
            return true;
        }
        if (object != null && object instanceof TexImage2DCmd) {
            TexImage2DCmd texImage2DCmd2 = (TexImage2DCmd)object;
            if (texImage2DCmd.target == texImage2DCmd2.target && texImage2DCmd.level == texImage2DCmd2.level && texImage2DCmd.internalformat == texImage2DCmd2.internalformat && texImage2DCmd.width == texImage2DCmd2.width && texImage2DCmd.height == texImage2DCmd2.height && texImage2DCmd.border == texImage2DCmd2.border && texImage2DCmd.format == texImage2DCmd2.format && texImage2DCmd.type == texImage2DCmd2.type && Objects.equals(texImage2DCmd.pixelData, texImage2DCmd2.pixelData)) {
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ String jvmdowngrader$concat$toString$1(int n) {
        return n + " bytes";
    }
}

