/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.glsm.recording.commands;

import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.glsm.recording.commands.DisplayListCommand;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.lwjgl.BufferUtils;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;
import xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;
import xyz.wagyourtail.jvmdg.j9.stub.java_base.J_N_Buffer;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@RecordComponents(value={@RecordComponents.Value(name="matrix", type=Matrix4f.class), @RecordComponents.Value(name="buffer", type=FloatBuffer.class)})
public final class MultMatrixCmd
extends J_L_Record
implements DisplayListCommand {
    private final Matrix4f matrix;
    private final FloatBuffer buffer;

    public MultMatrixCmd(Matrix4f matrix, FloatBuffer buffer) {
        this.matrix = matrix;
        this.buffer = buffer;
    }

    public static MultMatrixCmd create(Matrix4f matrix) {
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)16);
        matrix.get(buffer);
        FloatBuffer cfr_ignored_0 = (FloatBuffer)J_N_Buffer.rewind((Buffer)buffer);
        return new MultMatrixCmd(new Matrix4f((Matrix4fc)matrix), buffer);
    }

    @Override
    public void execute() {
        FloatBuffer cfr_ignored_0 = (FloatBuffer)J_N_Buffer.rewind((Buffer)this.buffer);
        GLStateManager.glMultMatrix(this.buffer);
    }

    @NotNull
    public String toString() {
        return String.format("MultMatrix(%s)", this.matrix);
    }

    public final int hashCode() {
        return MultMatrixCmd.jvmdowngrader$hashCode$hashCode(this);
    }

    public final boolean equals(Object o) {
        return MultMatrixCmd.jvmdowngrader$equals$equals(this, o);
    }

    public Matrix4f matrix() {
        return this.matrix;
    }

    public FloatBuffer buffer() {
        return this.buffer;
    }

    private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(MultMatrixCmd multMatrixCmd) {
        Object[] objectArray = new Object[]{multMatrixCmd.matrix, multMatrixCmd.buffer};
        return Arrays.hashCode(objectArray);
    }

    private static /* synthetic */ boolean jvmdowngrader$equals$equals(MultMatrixCmd multMatrixCmd, Object object) {
        if (multMatrixCmd == object) {
            return true;
        }
        if (object != null && object instanceof MultMatrixCmd) {
            MultMatrixCmd multMatrixCmd2 = (MultMatrixCmd)object;
            if (Objects.equals(multMatrixCmd.matrix, multMatrixCmd2.matrix) && Objects.equals(multMatrixCmd.buffer, multMatrixCmd2.buffer)) {
                return true;
            }
        }
        return false;
    }
}

