/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.glsm.recording;

import com.gtnewhorizon.gtnhlib.client.renderer.DirectTessellator;
import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.glsm.states.ClientArrayState;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={VertexReader.class, ColorReader.class})
public final class ImmediateModeRecorder {
    private static final DirectTessellator tessellator = new DirectTessellator(32768);

    private ImmediateModeRecorder() {
    }

    public static DirectTessellator getInternalTessellator() {
        return tessellator;
    }

    public static void setTexCoord(float s, float t) {
        tessellator.func_78385_a((double)s, (double)t);
    }

    public static void setNormal(float x, float y, float z) {
        tessellator.func_78375_b(x, y, z);
    }

    public static void begin(int primitiveType) {
        tessellator.func_78371_b(primitiveType);
    }

    public static DirectTessellator end() {
        if (!ImmediateModeRecorder.tessellator.field_78415_z) {
            throw new IllegalStateException("glEnd called without glBegin");
        }
        ImmediateModeRecorder.tessellator.field_78415_z = false;
        if (tessellator.isEmpty()) {
            return null;
        }
        return tessellator;
    }

    public static void vertex(float x, float y, float z) {
        if (!ImmediateModeRecorder.tessellator.field_78415_z) {
            throw new IllegalStateException("glVertex called outside glBegin/glEnd");
        }
        tessellator.func_78377_a((double)x, (double)y, (double)z);
    }

    public static boolean hasGeometry() {
        return ImmediateModeRecorder.tessellator.field_78406_i != 0;
    }

    public static void reset() {
        tessellator.func_78379_d();
    }

    public static DirectTessellator processDrawArrays(int mode, int first, int count) {
        ClientArrayState cas = GLStateManager.getClientArrayState();
        Buffer vertexPointer = cas.isVertexArrayEnabled() ? cas.getVertexPointer() : null;
        Buffer colorPointer = cas.isColorArrayEnabled() ? cas.getColorPointer() : null;
        return ImmediateModeRecorder.convertClientArrays(mode, first, count, vertexPointer, cas.getVertexPointerType(), cas.getVertexPointerSize(), cas.getVertexPointerStride(), colorPointer, cas.getColorPointerType(), cas.getColorPointerSize(), cas.getColorPointerStride());
    }

    public static DirectTessellator convertClientArrays(int mode, int first, int count, Buffer vertexPointer, int vertexType, int vertexSize, int vertexStride, Buffer colorPointer, int colorType, int colorSize, int colorStride) {
        int effectiveStride;
        VertexReader vertexReader;
        int colorEffectiveStride;
        ColorReader colorReader;
        ImmediateModeRecorder.begin(mode);
        if (colorPointer == null) {
            colorReader = null;
        } else if (colorType == 5126 && colorPointer instanceof FloatBuffer) {
            FloatBuffer fb = (FloatBuffer)colorPointer;
            colorEffectiveStride = colorStride == 0 ? colorSize * 4 : colorStride;
            int strideInFloats = colorEffectiveStride / 4;
            colorReader = idx -> {
                int offset = idx * strideInFloats;
                float r = fb.get(offset);
                float g = fb.get(offset + 1);
                float b = fb.get(offset + 2);
                float a = colorSize == 4 ? fb.get(offset + 3) : 1.0f;
                GLStateManager.glColor4f(r, g, b, a);
            };
        } else if ((colorType == 5121 || colorType == 5120) && colorPointer instanceof ByteBuffer) {
            ByteBuffer bb = (ByteBuffer)colorPointer;
            colorEffectiveStride = colorStride == 0 ? colorSize : colorStride;
            colorReader = idx -> {
                int offset = idx * colorEffectiveStride;
                float r = (float)(bb.get(offset) & 0xFF) / 255.0f;
                float g = (float)(bb.get(offset + 1) & 0xFF) / 255.0f;
                float b = (float)(bb.get(offset + 2) & 0xFF) / 255.0f;
                float a = colorSize == 4 ? (float)(bb.get(offset + 3) & 0xFF) / 255.0f : 1.0f;
                GLStateManager.glColor4f(r, g, b, a);
            };
        } else {
            colorReader = idx -> GLStateManager.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (vertexPointer == null) {
            vertexReader = null;
        } else if (vertexType == 5126 && vertexPointer instanceof FloatBuffer) {
            FloatBuffer fb = (FloatBuffer)vertexPointer;
            effectiveStride = vertexStride == 0 ? vertexSize * 4 : vertexStride;
            int strideInFloats = effectiveStride / 4;
            vertexReader = idx -> {
                int offset = idx * strideInFloats;
                float x = fb.get(offset);
                float y = fb.get(offset + 1);
                float z = vertexSize >= 3 ? fb.get(offset + 2) : 0.0f;
                ImmediateModeRecorder.vertex(x, y, z);
            };
        } else if (vertexType == 5130 && vertexPointer instanceof DoubleBuffer) {
            DoubleBuffer db = (DoubleBuffer)vertexPointer;
            effectiveStride = vertexStride == 0 ? vertexSize * 8 : vertexStride;
            int strideInDoubles = effectiveStride / 8;
            vertexReader = idx -> {
                int offset = idx * strideInDoubles;
                float x = (float)db.get(offset);
                float y = (float)db.get(offset + 1);
                float z = vertexSize >= 3 ? (float)db.get(offset + 2) : 0.0f;
                ImmediateModeRecorder.vertex(x, y, z);
            };
        } else if (vertexType == 5124 && vertexPointer instanceof IntBuffer) {
            IntBuffer ib = (IntBuffer)vertexPointer;
            effectiveStride = vertexStride == 0 ? vertexSize * 4 : vertexStride;
            int strideInInts = effectiveStride / 4;
            vertexReader = idx -> {
                int offset = idx * strideInInts;
                float x = ib.get(offset);
                float y = ib.get(offset + 1);
                float z = vertexSize >= 3 ? (float)ib.get(offset + 2) : 0.0f;
                ImmediateModeRecorder.vertex(x, y, z);
            };
        } else if (vertexType == 5122 && vertexPointer instanceof ShortBuffer) {
            ShortBuffer sb = (ShortBuffer)vertexPointer;
            effectiveStride = vertexStride == 0 ? vertexSize * 2 : vertexStride;
            int strideInShorts = effectiveStride / 2;
            vertexReader = idx -> {
                int offset = idx * strideInShorts;
                float x = sb.get(offset);
                float y = sb.get(offset + 1);
                float z = vertexSize >= 3 ? (float)sb.get(offset + 2) : 0.0f;
                ImmediateModeRecorder.vertex(x, y, z);
            };
        } else {
            vertexReader = null;
        }
        for (int i = first; i < first + count; ++i) {
            if (colorReader != null) {
                colorReader.read(i);
            }
            if (vertexReader == null) continue;
            vertexReader.read(i);
        }
        return ImmediateModeRecorder.end();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @FunctionalInterface
    @NestHost(value=ImmediateModeRecorder.class)
    private static interface ColorReader {
        public void read(int var1);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @FunctionalInterface
    @NestHost(value=ImmediateModeRecorder.class)
    private static interface VertexReader {
        public void read(int var1);
    }
}

