/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.glsm.recording;

import com.gtnewhorizon.gtnhlib.bytebuf.MemoryUtilities;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class GLCommand {
    public static final int ENABLE = 1;
    public static final int DISABLE = 2;
    public static final int CLEAR = 3;
    public static final int CLEAR_STENCIL = 4;
    public static final int CULL_FACE = 5;
    public static final int DEPTH_FUNC = 6;
    public static final int SHADE_MODEL = 7;
    public static final int LOGIC_OP = 8;
    public static final int MATRIX_MODE = 9;
    public static final int ACTIVE_TEXTURE = 10;
    public static final int USE_PROGRAM = 11;
    public static final int PUSH_ATTRIB = 12;
    public static final int POP_ATTRIB = 13;
    public static final int LOAD_IDENTITY = 14;
    public static final int PUSH_MATRIX = 15;
    public static final int POP_MATRIX = 16;
    public static final int STENCIL_MASK = 17;
    public static final int DEPTH_MASK = 18;
    public static final int FRONT_FACE = 19;
    public static final int BIND_TEXTURE = 20;
    public static final int POLYGON_MODE = 21;
    public static final int COLOR_MATERIAL = 22;
    public static final int LINE_STIPPLE = 23;
    public static final int STENCIL_MASK_SEPARATE = 24;
    public static final int FOGI = 25;
    public static final int HINT = 26;
    public static final int STENCIL_FUNC = 30;
    public static final int STENCIL_OP = 31;
    public static final int TEX_PARAMETERI = 32;
    public static final int VIEWPORT = 40;
    public static final int BLEND_FUNC = 41;
    public static final int COLOR_MASK = 42;
    public static final int STENCIL_FUNC_SEPARATE = 43;
    public static final int STENCIL_OP_SEPARATE = 44;
    public static final int POINT_SIZE = 50;
    public static final int LINE_WIDTH = 51;
    public static final int POLYGON_OFFSET = 52;
    public static final int NORMAL = 53;
    public static final int COLOR = 54;
    public static final int CLEAR_COLOR = 55;
    public static final int BLEND_COLOR = 56;
    public static final int ALPHA_FUNC = 60;
    public static final int FOGF = 61;
    public static final int LIGHTF = 62;
    public static final int LIGHT_MODELF = 63;
    public static final int LIGHTI = 64;
    public static final int LIGHT_MODELI = 65;
    public static final int MATERIALF = 66;
    public static final int TEX_PARAMETERF = 67;
    public static final int TRANSLATE = 70;
    public static final int ROTATE = 71;
    public static final int SCALE = 72;
    public static final int ORTHO = 73;
    public static final int FRUSTUM = 74;
    public static final int CLEAR_DEPTH = 75;
    public static final int MULT_MATRIX = 80;
    public static final int LOAD_MATRIX = 81;
    public static final int FOG = 90;
    public static final int LIGHT = 91;
    public static final int LIGHT_MODEL = 92;
    public static final int MATERIAL = 93;
    public static final int DRAW_RANGE = 100;
    public static final int DRAW_RANGE_RESTORE = 101;
    public static final int CALL_LIST = 102;
    public static final int DRAW_ARRAYS = 110;
    public static final int DRAW_ELEMENTS = 111;
    public static final int DRAW_BUFFER = 112;
    public static final int DRAW_BUFFERS = 113;
    public static final int BIND_VBO = 120;
    public static final int BIND_VAO = 121;
    public static final int COMPLEX_REF = 255;

    private GLCommand() {
    }

    public static String getName(int opcode) {
        String string;
        switch (opcode) {
            case 1: {
                string = "ENABLE";
                break;
            }
            case 2: {
                string = "DISABLE";
                break;
            }
            case 3: {
                string = "CLEAR";
                break;
            }
            case 4: {
                string = "CLEAR_STENCIL";
                break;
            }
            case 5: {
                string = "CULL_FACE";
                break;
            }
            case 6: {
                string = "DEPTH_FUNC";
                break;
            }
            case 7: {
                string = "SHADE_MODEL";
                break;
            }
            case 8: {
                string = "LOGIC_OP";
                break;
            }
            case 9: {
                string = "MATRIX_MODE";
                break;
            }
            case 10: {
                string = "ACTIVE_TEXTURE";
                break;
            }
            case 11: {
                string = "USE_PROGRAM";
                break;
            }
            case 12: {
                string = "PUSH_ATTRIB";
                break;
            }
            case 13: {
                string = "POP_ATTRIB";
                break;
            }
            case 14: {
                string = "LOAD_IDENTITY";
                break;
            }
            case 15: {
                string = "PUSH_MATRIX";
                break;
            }
            case 16: {
                string = "POP_MATRIX";
                break;
            }
            case 17: {
                string = "STENCIL_MASK";
                break;
            }
            case 18: {
                string = "DEPTH_MASK";
                break;
            }
            case 19: {
                string = "FRONT_FACE";
                break;
            }
            case 20: {
                string = "BIND_TEXTURE";
                break;
            }
            case 21: {
                string = "POLYGON_MODE";
                break;
            }
            case 22: {
                string = "COLOR_MATERIAL";
                break;
            }
            case 23: {
                string = "LINE_STIPPLE";
                break;
            }
            case 24: {
                string = "STENCIL_MASK_SEPARATE";
                break;
            }
            case 25: {
                string = "FOGI";
                break;
            }
            case 26: {
                string = "HINT";
                break;
            }
            case 30: {
                string = "STENCIL_FUNC";
                break;
            }
            case 31: {
                string = "STENCIL_OP";
                break;
            }
            case 32: {
                string = "TEX_PARAMETERI";
                break;
            }
            case 40: {
                string = "VIEWPORT";
                break;
            }
            case 41: {
                string = "BLEND_FUNC";
                break;
            }
            case 42: {
                string = "COLOR_MASK";
                break;
            }
            case 43: {
                string = "STENCIL_FUNC_SEPARATE";
                break;
            }
            case 44: {
                string = "STENCIL_OP_SEPARATE";
                break;
            }
            case 50: {
                string = "POINT_SIZE";
                break;
            }
            case 51: {
                string = "LINE_WIDTH";
                break;
            }
            case 52: {
                string = "POLYGON_OFFSET";
                break;
            }
            case 54: {
                string = "COLOR";
                break;
            }
            case 55: {
                string = "CLEAR_COLOR";
                break;
            }
            case 56: {
                string = "BLEND_COLOR";
                break;
            }
            case 60: {
                string = "ALPHA_FUNC";
                break;
            }
            case 61: {
                string = "FOGF";
                break;
            }
            case 62: {
                string = "LIGHTF";
                break;
            }
            case 63: {
                string = "LIGHT_MODELF";
                break;
            }
            case 64: {
                string = "LIGHTI";
                break;
            }
            case 65: {
                string = "LIGHT_MODELI";
                break;
            }
            case 66: {
                string = "MATERIALF";
                break;
            }
            case 67: {
                string = "TEX_PARAMETERF";
                break;
            }
            case 70: {
                string = "TRANSLATE";
                break;
            }
            case 71: {
                string = "ROTATE";
                break;
            }
            case 72: {
                string = "SCALE";
                break;
            }
            case 73: {
                string = "ORTHO";
                break;
            }
            case 74: {
                string = "FRUSTUM";
                break;
            }
            case 75: {
                string = "CLEAR_DEPTH";
                break;
            }
            case 80: {
                string = "MULT_MATRIX";
                break;
            }
            case 81: {
                string = "LOAD_MATRIX";
                break;
            }
            case 90: {
                string = "FOG";
                break;
            }
            case 91: {
                string = "LIGHT";
                break;
            }
            case 92: {
                string = "LIGHT_MODEL";
                break;
            }
            case 93: {
                string = "MATERIAL";
                break;
            }
            case 100: {
                string = "DRAW_RANGE";
                break;
            }
            case 102: {
                string = "CALL_LIST";
                break;
            }
            case 112: {
                string = "DRAW_BUFFER";
                break;
            }
            case 113: {
                string = "DRAW_BUFFERS";
                break;
            }
            case 255: {
                string = "COMPLEX_REF";
                break;
            }
            case 101: {
                string = "DRAW_RANGE_RESTORE";
                break;
            }
            case 121: {
                string = "BIND_VAO";
                break;
            }
            case 120: {
                string = "BIND_VBO";
                break;
            }
            default: {
                string = GLCommand.jvmdowngrader$concat$getName$1(opcode);
            }
        }
        return string;
    }

    public static int getCommandSize(int cmd, long ptr) {
        int n;
        switch (cmd) {
            case 14: 
            case 15: 
            case 16: {
                n = 4;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 50: 
            case 51: 
            case 100: 
            case 102: 
            case 120: 
            case 121: 
            case 255: {
                n = 8;
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 52: 
            case 60: 
            case 61: 
            case 63: 
            case 65: {
                n = 12;
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 62: 
            case 64: 
            case 66: 
            case 67: 
            case 110: {
                n = 16;
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 54: 
            case 55: 
            case 56: {
                n = 20;
                break;
            }
            case 111: {
                n = 24;
                break;
            }
            case 101: {
                n = 28;
                break;
            }
            case 112: {
                n = 8;
                break;
            }
            case 113: {
                n = 40;
                break;
            }
            case 70: 
            case 72: {
                n = 28;
                break;
            }
            case 75: {
                n = 12;
                break;
            }
            case 71: {
                n = 36;
                break;
            }
            case 73: 
            case 74: {
                n = 52;
                break;
            }
            case 80: 
            case 81: {
                n = 68;
                break;
            }
            case 90: 
            case 92: {
                int count = MemoryUtilities.memGetInt((long)(ptr + 8L));
                n = 12 + count * 4;
                break;
            }
            case 91: 
            case 93: {
                int count = MemoryUtilities.memGetInt((long)(ptr + 12L));
                n = 16 + count * 4;
                break;
            }
            default: {
                throw new IllegalStateException(GLCommand.jvmdowngrader$concat$getCommandSize$1(cmd));
            }
        }
        return n;
    }

    private static /* synthetic */ String jvmdowngrader$concat$getName$1(int n) {
        return "UNKNOWN(" + n + ")";
    }

    private static /* synthetic */ String jvmdowngrader$concat$getCommandSize$1(int n) {
        return "Unknown command: " + n;
    }
}

