/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.glsm.recording;

import com.gtnewhorizon.gtnhlib.bytebuf.MemoryUtilities;
import com.gtnewhorizon.gtnhlib.client.renderer.vao.IVertexArrayObject;
import com.gtnewhorizon.gtnhlib.client.renderer.vao.IndexBuffer;
import com.gtnewhorizon.gtnhlib.client.renderer.vao.IndexedVAO;
import com.gtnewhorizon.gtnhlib.client.renderer.vao.VAOManager;
import com.gtnewhorizon.gtnhlib.client.renderer.vbo.IVertexBuffer;
import com.gtnewhorizon.gtnhlib.client.renderer.vertex.DefaultVertexFormat;
import com.gtnewhorizon.gtnhlib.client.renderer.vertex.VertexFormat;
import com.gtnewhorizons.angelica.glsm.recording.AccumulatedDraw;
import com.gtnewhorizons.angelica.glsm.recording.DisplayListVBO;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j9.stub.java_base.J_N_Buffer;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={FormatData.class})
public final class DisplayListVBOBuilder {
    private final List<FormatData>[] formats = new List[16];
    private int count;

    public DisplayListVBOBuilder addDraw(VertexFormat format, int drawMode, List<ByteBuffer> buffers) {
        List<FormatData> data = this.formats[format.getVertexFlags()];
        if (data == null) {
            this.formats[format.getVertexFlags()] = data = new ArrayList<FormatData>();
        }
        data.add(new FormatData(buffers, drawMode, this.count));
        ++this.count;
        return this;
    }

    public DisplayListVBOBuilder addDraws(List<AccumulatedDraw> draws) {
        for (AccumulatedDraw draw : draws) {
            this.addDraw(draw.format, draw.drawMode, draw.drawBuffers);
        }
        return this;
    }

    public DisplayListVBO build() {
        DisplayListVBO.SubVBO[] vbos = new DisplayListVBO.SubVBO[this.count];
        ArrayList<ByteBuffer> allBuffers = new ArrayList<ByteBuffer>();
        for (int i = 0; i < 16; ++i) {
            List<FormatData> formatData = this.formats[i];
            if (formatData == null) continue;
            VertexFormat format = DefaultVertexFormat.ALL_FORMATS[i];
            int start = 0;
            IVertexArrayObject vao = VAOManager.createStorageVAO((VertexFormat)format, (int)-1, (int)0);
            IVertexBuffer vbo = vao.getVBO();
            for (FormatData data : formatData) {
                int vertexCount;
                List drawBuffers = data.jvmdowngrader$nest$com_gtnewhorizons_angelica_glsm_recording_DisplayListVBOBuilder$FormatData$get$buffers();
                if (drawBuffers.size() == 1) {
                    ByteBuffer buffer = (ByteBuffer)drawBuffers.get(0);
                    allBuffers.add(buffer);
                    vertexCount = format.getVertexCount(buffer);
                } else {
                    allBuffers.addAll(drawBuffers);
                    int size = 0;
                    for (ByteBuffer buffer : drawBuffers) {
                        size += buffer.remaining();
                    }
                    vertexCount = format.getVertexCount(size);
                }
                if (data.jvmdowngrader$nest$com_gtnewhorizons_angelica_glsm_recording_DisplayListVBOBuilder$FormatData$get$drawMode() == 7) {
                    IndexedVAO indexedVAO = new IndexedVAO(vbo, IndexBuffer.convertQuadsToTrigs((int)start, (int)(start + vertexCount)));
                    vbos[data.jvmdowngrader$nest$com_gtnewhorizons_angelica_glsm_recording_DisplayListVBOBuilder$FormatData$get$drawIndex()] = new DisplayListVBO.SubVBO((IVertexArrayObject)indexedVAO, 4, 0, vertexCount / 4 * 6);
                } else {
                    vbos[data.jvmdowngrader$nest$com_gtnewhorizons_angelica_glsm_recording_DisplayListVBOBuilder$FormatData$get$drawIndex()] = new DisplayListVBO.SubVBO(vao, data.jvmdowngrader$nest$com_gtnewhorizons_angelica_glsm_recording_DisplayListVBOBuilder$FormatData$get$drawMode(), start, vertexCount);
                }
                start += vertexCount;
            }
            ByteBuffer bigBuffer = DisplayListVBOBuilder.mergeAndDelete(allBuffers);
            vbo.allocate(bigBuffer, start);
            MemoryUtilities.memFree((ByteBuffer)bigBuffer);
            allBuffers.clear();
        }
        return new DisplayListVBO(vbos);
    }

    private static ByteBuffer mergeAndDelete(List<ByteBuffer> buffers) {
        if (buffers.size() == 1) {
            return buffers.get(0);
        }
        int needed = 0;
        for (ByteBuffer buffer : buffers) {
            needed += buffer.remaining();
        }
        ByteBuffer out = MemoryUtilities.memAlloc((int)needed);
        long dst = MemoryUtilities.memAddress0((ByteBuffer)out);
        for (ByteBuffer buffer : buffers) {
            int len = buffer.limit();
            long address = MemoryUtilities.memAddress0((ByteBuffer)buffer);
            MemoryUtilities.memCopy((long)address, (long)dst, (long)len);
            dst += (long)len;
            MemoryUtilities.nmemFree((long)address);
        }
        ByteBuffer cfr_ignored_0 = (ByteBuffer)J_N_Buffer.limit((Buffer)out, (int)needed);
        return out;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=DisplayListVBOBuilder.class)
    private static final class FormatData {
        private final List<ByteBuffer> buffers;
        private final int drawMode;
        private final int drawIndex;

        public FormatData(List<ByteBuffer> buffers, int drawMode, int drawIndex) {
            this.buffers = buffers;
            this.drawMode = drawMode;
            this.drawIndex = drawIndex;
        }

        public /* synthetic */ int jvmdowngrader$nest$com_gtnewhorizons_angelica_glsm_recording_DisplayListVBOBuilder$FormatData$get$drawMode() {
            return this.drawMode;
        }

        public /* synthetic */ void jvmdowngrader$nest$com_gtnewhorizons_angelica_glsm_recording_DisplayListVBOBuilder$FormatData$set$drawMode(int n) {
            this.drawMode = n;
        }

        public /* synthetic */ int jvmdowngrader$nest$com_gtnewhorizons_angelica_glsm_recording_DisplayListVBOBuilder$FormatData$get$drawIndex() {
            return this.drawIndex;
        }

        public /* synthetic */ void jvmdowngrader$nest$com_gtnewhorizons_angelica_glsm_recording_DisplayListVBOBuilder$FormatData$set$drawIndex(int n) {
            this.drawIndex = n;
        }

        public /* synthetic */ List jvmdowngrader$nest$com_gtnewhorizons_angelica_glsm_recording_DisplayListVBOBuilder$FormatData$get$buffers() {
            return this.buffers;
        }

        public /* synthetic */ void jvmdowngrader$nest$com_gtnewhorizons_angelica_glsm_recording_DisplayListVBOBuilder$FormatData$set$buffers(List list) {
            this.buffers = list;
        }
    }
}

