/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.glsm.recording;

import com.gtnewhorizon.gtnhlib.bytebuf.MemoryUtilities;
import com.gtnewhorizons.angelica.glsm.DisplayListManager;
import com.gtnewhorizons.angelica.glsm.recording.CommandBufferExecutor;
import com.gtnewhorizons.angelica.glsm.recording.DisplayListVBO;
import com.gtnewhorizons.angelica.glsm.recording.GLCommand;
import com.gtnewhorizons.angelica.glsm.recording.commands.DisplayListCommand;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.nio.ByteBuffer;

public final class CompiledDisplayList {
    public static final CompiledDisplayList EMPTY = new CompiledDisplayList(null, null, null);
    private final ByteBuffer commandBuffer;
    private final Object[] complexObjects;
    private final DisplayListVBO ownedVbos;

    public CompiledDisplayList(ByteBuffer commandBuffer, Object[] complexObjects, DisplayListVBO ownedVbos) {
        this.commandBuffer = commandBuffer;
        this.complexObjects = complexObjects;
        this.ownedVbos = ownedVbos;
    }

    public void render() {
        if (this.commandBuffer != null && this.commandBuffer.limit() > 0) {
            CommandBufferExecutor.execute(this.commandBuffer, this.complexObjects, this.ownedVbos);
        }
    }

    public void delete() {
        if (this.complexObjects != null) {
            for (Object obj : this.complexObjects) {
                if (!(obj instanceof DisplayListCommand)) continue;
                DisplayListCommand cmd = (DisplayListCommand)obj;
                cmd.delete();
            }
        }
        if (this.ownedVbos != null) {
            this.ownedVbos.delete();
        }
        if (this.commandBuffer != null) {
            MemoryUtilities.memFree((ByteBuffer)this.commandBuffer);
        }
    }

    public ByteBuffer getCommandBuffer() {
        return this.commandBuffer;
    }

    public Object[] getComplexObjects() {
        return this.complexObjects;
    }

    public DisplayListVBO getOwnedVbos() {
        return this.ownedVbos;
    }

    public Int2IntMap getCommandCounts() {
        int cmd;
        long ptr;
        Int2IntOpenHashMap counts = new Int2IntOpenHashMap();
        if (this.commandBuffer == null || this.commandBuffer.limit() == 0) {
            return counts;
        }
        long end = ptr + (long)this.commandBuffer.limit();
        for (ptr = MemoryUtilities.memAddress((ByteBuffer)this.commandBuffer); ptr < end; ptr += (long)GLCommand.getCommandSize(cmd, ptr)) {
            cmd = MemoryUtilities.memGetInt((long)ptr);
            counts.mergeInt(cmd, 1, Integer::sum);
        }
        return counts;
    }

    public IntList getCommandOpcodes() {
        int cmd;
        long ptr;
        IntArrayList opcodes = new IntArrayList();
        if (this.commandBuffer == null || this.commandBuffer.limit() == 0) {
            return opcodes;
        }
        long end = ptr + (long)this.commandBuffer.limit();
        for (ptr = MemoryUtilities.memAddress((ByteBuffer)this.commandBuffer); ptr < end; ptr += (long)GLCommand.getCommandSize(cmd, ptr)) {
            cmd = MemoryUtilities.memGetInt((long)ptr);
            opcodes.add(cmd);
        }
        return opcodes;
    }

    public String toString() {
        return DisplayListManager.getCompiledDisplayListString(0, this, null);
    }
}

