/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.glsm.recording;

import com.gtnewhorizons.angelica.glsm.recording.CommandBuffer;
import com.gtnewhorizons.angelica.glsm.recording.commands.DisplayListCommand;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.joml.Matrix4f;

public final class CommandRecorder {
    private final CommandBuffer buffer = new CommandBuffer();
    private int commandCount = 0;

    public CommandBuffer getBuffer() {
        return this.buffer;
    }

    public int getCommandCount() {
        return this.commandCount;
    }

    public void free() {
        this.buffer.free();
    }

    public void recordEnable(int cap) {
        this.buffer.writeEnable(cap);
        ++this.commandCount;
    }

    public void recordDisable(int cap) {
        this.buffer.writeDisable(cap);
        ++this.commandCount;
    }

    public void recordClear(int mask) {
        this.buffer.writeClear(mask);
        ++this.commandCount;
    }

    public void recordClearColor(float r, float g, float b, float a) {
        this.buffer.writeClearColor(r, g, b, a);
        ++this.commandCount;
    }

    public void recordClearDepth(double depth) {
        this.buffer.writeClearDepth(depth);
        ++this.commandCount;
    }

    public void recordBlendColor(float r, float g, float b, float a) {
        this.buffer.writeBlendColor(r, g, b, a);
        ++this.commandCount;
    }

    public void recordClearStencil(int s) {
        this.buffer.writeClearStencil(s);
        ++this.commandCount;
    }

    public void recordColor(float r, float g, float b, float a) {
        this.buffer.writeColor(r, g, b, a);
        ++this.commandCount;
    }

    public void recordColorMask(boolean r, boolean g, boolean b, boolean a) {
        this.buffer.writeColorMask(r, g, b, a);
        ++this.commandCount;
    }

    public void recordDepthMask(boolean flag) {
        this.buffer.writeDepthMask(flag);
        ++this.commandCount;
    }

    public void recordFrontFace(int mode) {
        this.buffer.writeFrontFace(mode);
        ++this.commandCount;
    }

    public void recordDepthFunc(int func) {
        this.buffer.writeDepthFunc(func);
        ++this.commandCount;
    }

    public void recordBlendFunc(int srcRgb, int dstRgb, int srcAlpha, int dstAlpha) {
        this.buffer.writeBlendFunc(srcRgb, dstRgb, srcAlpha, dstAlpha);
        ++this.commandCount;
    }

    public void recordAlphaFunc(int func, float ref) {
        this.buffer.writeAlphaFunc(func, ref);
        ++this.commandCount;
    }

    public void recordCullFace(int mode) {
        this.buffer.writeCullFace(mode);
        ++this.commandCount;
    }

    public void recordShadeModel(int mode) {
        this.buffer.writeShadeModel(mode);
        ++this.commandCount;
    }

    public void recordBindTexture(int target, int texture) {
        this.buffer.writeBindTexture(target, texture);
        ++this.commandCount;
    }

    public void recordTexParameteri(int target, int pname, int param) {
        this.buffer.writeTexParameteri(target, pname, param);
        ++this.commandCount;
    }

    public void recordTexParameterf(int target, int pname, float param) {
        this.buffer.writeTexParameterf(target, pname, param);
        ++this.commandCount;
    }

    public void recordMatrixMode(int mode) {
        this.buffer.writeMatrixMode(mode);
        ++this.commandCount;
    }

    public void recordLoadIdentity() {
        this.buffer.writeLoadIdentity();
        ++this.commandCount;
    }

    public void recordPushMatrix() {
        this.buffer.writePushMatrix();
        ++this.commandCount;
    }

    public void recordPopMatrix() {
        this.buffer.writePopMatrix();
        ++this.commandCount;
    }

    public void recordMultMatrix(Matrix4f matrix) {
        this.buffer.writeMultMatrix(matrix);
        ++this.commandCount;
    }

    public void recordLoadMatrix(Matrix4f matrix) {
        this.buffer.writeLoadMatrix(matrix);
        ++this.commandCount;
    }

    public void recordOrtho(double left, double right, double bottom, double top, double zNear, double zFar) {
        this.buffer.writeOrtho(left, right, bottom, top, zNear, zFar);
        ++this.commandCount;
    }

    public void recordFrustum(double left, double right, double bottom, double top, double zNear, double zFar) {
        this.buffer.writeFrustum(left, right, bottom, top, zNear, zFar);
        ++this.commandCount;
    }

    public void recordViewport(int x, int y, int width, int height) {
        this.buffer.writeViewport(x, y, width, height);
        ++this.commandCount;
    }

    public void recordPointSize(float size) {
        this.buffer.writePointSize(size);
        ++this.commandCount;
    }

    public void recordLineWidth(float width) {
        this.buffer.writeLineWidth(width);
        ++this.commandCount;
    }

    public void recordLineStipple(int factor, int pattern) {
        this.buffer.writeLineStipple(factor, pattern);
        ++this.commandCount;
    }

    public void recordPolygonOffset(float factor, float units) {
        this.buffer.writePolygonOffset(factor, units);
        ++this.commandCount;
    }

    public void recordPolygonMode(int face, int mode) {
        this.buffer.writePolygonMode(face, mode);
        ++this.commandCount;
    }

    public void recordColorMaterial(int face, int mode) {
        this.buffer.writeColorMaterial(face, mode);
        ++this.commandCount;
    }

    public void recordLogicOp(int opcode) {
        this.buffer.writeLogicOp(opcode);
        ++this.commandCount;
    }

    public void recordActiveTexture(int texture) {
        this.buffer.writeActiveTexture(texture);
        ++this.commandCount;
    }

    public void recordUseProgram(int program) {
        this.buffer.writeUseProgram(program);
        ++this.commandCount;
    }

    public void recordPushAttrib(int mask) {
        this.buffer.writePushAttrib(mask);
        ++this.commandCount;
    }

    public void recordPopAttrib() {
        this.buffer.writePopAttrib();
        ++this.commandCount;
    }

    public void recordFogf(int pname, float param) {
        this.buffer.writeFogf(pname, param);
        ++this.commandCount;
    }

    public void recordFogi(int pname, int param) {
        this.buffer.writeFogi(pname, param);
        ++this.commandCount;
    }

    public void recordHint(int target, int mode) {
        this.buffer.writeHint(target, mode);
        ++this.commandCount;
    }

    public void recordFog(int pname, FloatBuffer params) {
        this.buffer.writeFog(pname, params);
        ++this.commandCount;
    }

    public void recordLightf(int light, int pname, float param) {
        this.buffer.writeLightf(light, pname, param);
        ++this.commandCount;
    }

    public void recordLighti(int light, int pname, int param) {
        this.buffer.writeLighti(light, pname, param);
        ++this.commandCount;
    }

    public void recordLight(int light, int pname, FloatBuffer params) {
        this.buffer.writeLight(light, pname, params);
        ++this.commandCount;
    }

    public void recordLightModelf(int pname, float param) {
        this.buffer.writeLightModelf(pname, param);
        ++this.commandCount;
    }

    public void recordLightModeli(int pname, int param) {
        this.buffer.writeLightModeli(pname, param);
        ++this.commandCount;
    }

    public void recordLightModel(int pname, FloatBuffer params) {
        this.buffer.writeLightModel(pname, params);
        ++this.commandCount;
    }

    public void recordMaterialf(int face, int pname, float val) {
        this.buffer.writeMaterialf(face, pname, val);
        ++this.commandCount;
    }

    public void recordMaterial(int face, int pname, FloatBuffer params) {
        this.buffer.writeMaterial(face, pname, params);
        ++this.commandCount;
    }

    public void recordStencilFunc(int func, int ref, int mask) {
        this.buffer.writeStencilFunc(func, ref, mask);
        ++this.commandCount;
    }

    public void recordStencilFuncSeparate(int face, int func, int ref, int mask) {
        this.buffer.writeStencilFuncSeparate(face, func, ref, mask);
        ++this.commandCount;
    }

    public void recordStencilOp(int fail, int zfail, int zpass) {
        this.buffer.writeStencilOp(fail, zfail, zpass);
        ++this.commandCount;
    }

    public void recordStencilOpSeparate(int face, int sfail, int dpfail, int dppass) {
        this.buffer.writeStencilOpSeparate(face, sfail, dpfail, dppass);
        ++this.commandCount;
    }

    public void recordStencilMask(int mask) {
        this.buffer.writeStencilMask(mask);
        ++this.commandCount;
    }

    public void recordStencilMaskSeparate(int face, int mask) {
        this.buffer.writeStencilMaskSeparate(face, mask);
        ++this.commandCount;
    }

    public void recordCallList(int listId) {
        this.buffer.writeCallList(listId);
        ++this.commandCount;
    }

    public void recordDrawBuffer(int mode) {
        this.buffer.writeDrawBuffer(mode);
        ++this.commandCount;
    }

    public void recordDrawBuffers(int count, int buf) {
        this.buffer.writeDrawBuffers(count, buf);
        ++this.commandCount;
    }

    public void recordDrawBuffers(int count, IntBuffer bufs) {
        this.buffer.writeDrawBuffers(count, bufs);
        ++this.commandCount;
    }

    public void recordDrawArrays(int mode, int start, int count) {
        this.buffer.writeDrawArrays(mode, start, count);
        ++this.commandCount;
    }

    public void recordDrawElements(int mode, int indices_count, int type, long indices_buffer_offset) {
        this.buffer.writeDrawElements(mode, indices_count, type, indices_buffer_offset);
        ++this.commandCount;
    }

    public void recordBindVBO(int vbo) {
        this.buffer.writeBindVBO(vbo);
        ++this.commandCount;
    }

    public void recordBindVAO(int vao) {
        this.buffer.writeBindVAO(vao);
        ++this.commandCount;
    }

    public void recordComplexCommand(DisplayListCommand cmd) {
        this.buffer.writeComplexRef(cmd);
        ++this.commandCount;
    }
}

