/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.glsm.recording;

import com.gtnewhorizon.gtnhlib.bytebuf.MemoryUtilities;
import com.gtnewhorizons.angelica.glsm.recording.AccumulatedDraw;
import com.gtnewhorizons.angelica.glsm.recording.commands.DisplayListCommand;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import org.joml.Matrix4f;
import xyz.wagyourtail.jvmdg.j9.stub.java_base.J_N_Buffer;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class CommandBuffer {
    private static final int DEFAULT_CAPACITY = 4096;
    private ByteBuffer buffer;
    private long basePointer;
    private long writePointer;
    private final List<Object> complexObjects = new ArrayList<Object>();
    private static final int MAX_DRAW_BUFFERS = 8;
    private static final int DRAW_BUFFERS_SIZE = 40;
    private long readPointer = 0L;

    public CommandBuffer() {
        this(4096);
    }

    public CommandBuffer(int initialCapacity) {
        this.buffer = MemoryUtilities.memAlloc((int)initialCapacity);
        this.writePointer = this.basePointer = MemoryUtilities.memAddress((ByteBuffer)this.buffer);
    }

    private void writeInt(int value) {
        MemoryUtilities.memPutInt((long)this.writePointer, (int)value);
        this.writePointer += 4L;
    }

    private void writeLong(long value) {
        MemoryUtilities.memPutLong((long)this.writePointer, (long)value);
        this.writePointer += 8L;
    }

    private void writeFloat(float value) {
        MemoryUtilities.memPutFloat((long)this.writePointer, (float)value);
        this.writePointer += 4L;
    }

    private void writeDouble(double value) {
        MemoryUtilities.memPutDouble((long)this.writePointer, (double)value);
        this.writePointer += 8L;
    }

    private void ensureCapacity(int needed) {
        int size = this.size();
        int remaining = this.buffer.capacity() - size;
        if (remaining < needed) {
            int newCapacity = Math.max(this.buffer.capacity() * 2, this.buffer.capacity() + needed);
            this.buffer = MemoryUtilities.memRealloc((ByteBuffer)this.buffer, (int)newCapacity);
            this.basePointer = MemoryUtilities.memAddress((ByteBuffer)this.buffer);
            this.writePointer = this.basePointer + (long)size;
        }
    }

    public void writeEnable(int cap) {
        this.ensureCapacity(8);
        this.writeInt(1);
        this.writeInt(cap);
    }

    public void writeDisable(int cap) {
        this.ensureCapacity(8);
        this.writeInt(2);
        this.writeInt(cap);
    }

    public void writeClear(int mask) {
        this.ensureCapacity(8);
        this.writeInt(3);
        this.writeInt(mask);
    }

    public void writeClearStencil(int s) {
        this.ensureCapacity(8);
        this.writeInt(4);
        this.writeInt(s);
    }

    public void writeCullFace(int mode) {
        this.ensureCapacity(8);
        this.writeInt(5);
        this.writeInt(mode);
    }

    public void writeDepthFunc(int func) {
        this.ensureCapacity(8);
        this.writeInt(6);
        this.writeInt(func);
    }

    public void writeShadeModel(int mode) {
        this.ensureCapacity(8);
        this.writeInt(7);
        this.writeInt(mode);
    }

    public void writeLogicOp(int opcode) {
        this.ensureCapacity(8);
        this.writeInt(8);
        this.writeInt(opcode);
    }

    public void writeMatrixMode(int mode) {
        this.ensureCapacity(8);
        this.writeInt(9);
        this.writeInt(mode);
    }

    public void writeActiveTexture(int texture) {
        this.ensureCapacity(8);
        this.writeInt(10);
        this.writeInt(texture);
    }

    public void writeUseProgram(int program) {
        this.ensureCapacity(8);
        this.writeInt(11);
        this.writeInt(program);
    }

    public void writePushAttrib(int mask) {
        this.ensureCapacity(8);
        this.writeInt(12);
        this.writeInt(mask);
    }

    public void writePopAttrib() {
        this.ensureCapacity(8);
        this.writeInt(13);
        this.writeInt(0);
    }

    public void writeLoadIdentity() {
        this.ensureCapacity(4);
        this.writeInt(14);
    }

    public void writePushMatrix() {
        this.ensureCapacity(4);
        this.writeInt(15);
    }

    public void writePopMatrix() {
        this.ensureCapacity(4);
        this.writeInt(16);
    }

    public void writeStencilMask(int mask) {
        this.ensureCapacity(8);
        this.writeInt(17);
        this.writeInt(mask);
    }

    public void writeDepthMask(boolean flag) {
        this.ensureCapacity(8);
        this.writeInt(18);
        this.writeInt(flag ? 1 : 0);
    }

    public void writeFrontFace(int mode) {
        this.ensureCapacity(8);
        this.writeInt(19);
        this.writeInt(mode);
    }

    public void writeBindTexture(int target, int texture) {
        this.ensureCapacity(12);
        this.writeInt(20);
        this.writeInt(target);
        this.writeInt(texture);
    }

    public void writePolygonMode(int face, int mode) {
        this.ensureCapacity(12);
        this.writeInt(21);
        this.writeInt(face);
        this.writeInt(mode);
    }

    public void writeColorMaterial(int face, int mode) {
        this.ensureCapacity(12);
        this.writeInt(22);
        this.writeInt(face);
        this.writeInt(mode);
    }

    public void writeLineStipple(int factor, int pattern) {
        this.ensureCapacity(12);
        this.writeInt(23);
        this.writeInt(factor);
        this.writeInt(pattern);
    }

    public void writeStencilMaskSeparate(int face, int mask) {
        this.ensureCapacity(12);
        this.writeInt(24);
        this.writeInt(face);
        this.writeInt(mask);
    }

    public void writeFogi(int pname, int param) {
        this.ensureCapacity(12);
        this.writeInt(25);
        this.writeInt(pname);
        this.writeInt(param);
    }

    public void writeHint(int target, int mode) {
        this.ensureCapacity(12);
        this.writeInt(26);
        this.writeInt(target);
        this.writeInt(mode);
    }

    public void writeStencilFunc(int func, int ref, int mask) {
        this.ensureCapacity(16);
        this.writeInt(30);
        this.writeInt(func);
        this.writeInt(ref);
        this.writeInt(mask);
    }

    public void writeStencilOp(int fail, int zfail, int zpass) {
        this.ensureCapacity(16);
        this.writeInt(31);
        this.writeInt(fail);
        this.writeInt(zfail);
        this.writeInt(zpass);
    }

    public void writeTexParameteri(int target, int pname, int param) {
        this.ensureCapacity(16);
        this.writeInt(32);
        this.writeInt(target);
        this.writeInt(pname);
        this.writeInt(param);
    }

    public void writeViewport(int x, int y, int width, int height) {
        this.ensureCapacity(20);
        this.writeInt(40);
        this.writeInt(x);
        this.writeInt(y);
        this.writeInt(width);
        this.writeInt(height);
    }

    public void writeBlendFunc(int srcRgb, int dstRgb, int srcAlpha, int dstAlpha) {
        this.ensureCapacity(20);
        this.writeInt(41);
        this.writeInt(srcRgb);
        this.writeInt(dstRgb);
        this.writeInt(srcAlpha);
        this.writeInt(dstAlpha);
    }

    public void writeColorMask(boolean red, boolean green, boolean blue, boolean alpha) {
        this.ensureCapacity(20);
        this.writeInt(42);
        this.writeInt(red ? 1 : 0);
        this.writeInt(green ? 1 : 0);
        this.writeInt(blue ? 1 : 0);
        this.writeInt(alpha ? 1 : 0);
    }

    public void writeStencilFuncSeparate(int face, int func, int ref, int mask) {
        this.ensureCapacity(20);
        this.writeInt(43);
        this.writeInt(face);
        this.writeInt(func);
        this.writeInt(ref);
        this.writeInt(mask);
    }

    public void writeStencilOpSeparate(int face, int sfail, int dpfail, int dppass) {
        this.ensureCapacity(20);
        this.writeInt(44);
        this.writeInt(face);
        this.writeInt(sfail);
        this.writeInt(dpfail);
        this.writeInt(dppass);
    }

    public void writePointSize(float size) {
        this.ensureCapacity(8);
        this.writeInt(50);
        this.writeFloat(size);
    }

    public void writeLineWidth(float width) {
        this.ensureCapacity(8);
        this.writeInt(51);
        this.writeFloat(width);
    }

    public void writePolygonOffset(float factor, float units) {
        this.ensureCapacity(12);
        this.writeInt(52);
        this.writeFloat(factor);
        this.writeFloat(units);
    }

    public void writeColor(float r, float g, float b, float a) {
        this.ensureCapacity(20);
        this.writeInt(54);
        this.writeFloat(r);
        this.writeFloat(g);
        this.writeFloat(b);
        this.writeFloat(a);
    }

    public void writeClearColor(float r, float g, float b, float a) {
        this.ensureCapacity(20);
        this.writeInt(55);
        this.writeFloat(r);
        this.writeFloat(g);
        this.writeFloat(b);
        this.writeFloat(a);
    }

    public void writeClearDepth(double depth) {
        this.ensureCapacity(12);
        this.writeInt(75);
        this.writeDouble(depth);
    }

    public void writeBlendColor(float r, float g, float b, float a) {
        this.ensureCapacity(20);
        this.writeInt(56);
        this.writeFloat(r);
        this.writeFloat(g);
        this.writeFloat(b);
        this.writeFloat(a);
    }

    public void writeAlphaFunc(int func, float ref) {
        this.ensureCapacity(12);
        this.writeInt(60);
        this.writeInt(func);
        this.writeFloat(ref);
    }

    public void writeFogf(int pname, float param) {
        this.ensureCapacity(12);
        this.writeInt(61);
        this.writeInt(pname);
        this.writeFloat(param);
    }

    public void writeLightf(int light, int pname, float param) {
        this.ensureCapacity(16);
        this.writeInt(62);
        this.writeInt(light);
        this.writeInt(pname);
        this.writeFloat(param);
    }

    public void writeLightModelf(int pname, float param) {
        this.ensureCapacity(12);
        this.writeInt(63);
        this.writeInt(pname);
        this.writeFloat(param);
    }

    public void writeLighti(int light, int pname, int param) {
        this.ensureCapacity(16);
        this.writeInt(64);
        this.writeInt(light);
        this.writeInt(pname);
        this.writeInt(param);
    }

    public void writeLightModeli(int pname, int param) {
        this.ensureCapacity(12);
        this.writeInt(65);
        this.writeInt(pname);
        this.writeInt(param);
    }

    public void writeMaterialf(int face, int pname, float param) {
        this.ensureCapacity(16);
        this.writeInt(66);
        this.writeInt(face);
        this.writeInt(pname);
        this.writeFloat(param);
    }

    public void writeTexParameterf(int target, int pname, float param) {
        this.ensureCapacity(16);
        this.writeInt(67);
        this.writeInt(target);
        this.writeInt(pname);
        this.writeFloat(param);
    }

    public void writeTranslate(double x, double y, double z) {
        this.ensureCapacity(28);
        this.writeInt(70);
        this.writeDouble(x);
        this.writeDouble(y);
        this.writeDouble(z);
    }

    public void writeRotate(double angle, double x, double y, double z) {
        this.ensureCapacity(36);
        this.writeInt(71);
        this.writeDouble(angle);
        this.writeDouble(x);
        this.writeDouble(y);
        this.writeDouble(z);
    }

    public void writeScale(double x, double y, double z) {
        this.ensureCapacity(28);
        this.writeInt(72);
        this.writeDouble(x);
        this.writeDouble(y);
        this.writeDouble(z);
    }

    public void writeOrtho(double left, double right, double bottom, double top, double zNear, double zFar) {
        this.ensureCapacity(52);
        this.writeInt(73);
        this.writeDouble(left);
        this.writeDouble(right);
        this.writeDouble(bottom);
        this.writeDouble(top);
        this.writeDouble(zNear);
        this.writeDouble(zFar);
    }

    public void writeFrustum(double left, double right, double bottom, double top, double zNear, double zFar) {
        this.ensureCapacity(52);
        this.writeInt(74);
        this.writeDouble(left);
        this.writeDouble(right);
        this.writeDouble(bottom);
        this.writeDouble(top);
        this.writeDouble(zNear);
        this.writeDouble(zFar);
    }

    public void writeMultMatrix(Matrix4f matrix) {
        this.ensureCapacity(68);
        this.writeInt(80);
        this.writeMatrix4f(matrix);
    }

    public void writeLoadMatrix(Matrix4f matrix) {
        this.ensureCapacity(68);
        this.writeInt(81);
        this.writeMatrix4f(matrix);
    }

    private void writeMatrix4f(Matrix4f m) {
        this.writeFloat(m.m00());
        this.writeFloat(m.m01());
        this.writeFloat(m.m02());
        this.writeFloat(m.m03());
        this.writeFloat(m.m10());
        this.writeFloat(m.m11());
        this.writeFloat(m.m12());
        this.writeFloat(m.m13());
        this.writeFloat(m.m20());
        this.writeFloat(m.m21());
        this.writeFloat(m.m22());
        this.writeFloat(m.m23());
        this.writeFloat(m.m30());
        this.writeFloat(m.m31());
        this.writeFloat(m.m32());
        this.writeFloat(m.m33());
    }

    public void writeFog(int pname, FloatBuffer params) {
        int count = Math.min(params.remaining(), 4);
        this.ensureCapacity(12 + count * 4);
        this.writeInt(90);
        this.writeInt(pname);
        this.writeInt(count);
        int pos = params.position();
        for (int i = 0; i < count; ++i) {
            this.writeFloat(params.get(pos + i));
        }
    }

    public void writeLight(int light, int pname, FloatBuffer params) {
        int count = Math.min(params.remaining(), 4);
        this.ensureCapacity(16 + count * 4);
        this.writeInt(91);
        this.writeInt(light);
        this.writeInt(pname);
        this.writeInt(count);
        int pos = params.position();
        for (int i = 0; i < count; ++i) {
            this.writeFloat(params.get(pos + i));
        }
    }

    public void writeLightModel(int pname, FloatBuffer params) {
        int count = Math.min(params.remaining(), 4);
        this.ensureCapacity(12 + count * 4);
        this.writeInt(92);
        this.writeInt(pname);
        this.writeInt(count);
        int pos = params.position();
        for (int i = 0; i < count; ++i) {
            this.writeFloat(params.get(pos + i));
        }
    }

    public void writeMaterial(int face, int pname, FloatBuffer params) {
        int count = Math.min(params.remaining(), 4);
        this.ensureCapacity(16 + count * 4);
        this.writeInt(93);
        this.writeInt(face);
        this.writeInt(pname);
        this.writeInt(count);
        int pos = params.position();
        for (int i = 0; i < count; ++i) {
            this.writeFloat(params.get(pos + i));
        }
    }

    public void writeDrawRange(int vboIndex) {
        this.ensureCapacity(8);
        this.writeInt(100);
        this.writeInt(vboIndex);
    }

    public void writeDrawRangeRestore(int vboIndex, AccumulatedDraw.RestoreData restoreData) {
        this.ensureCapacity(28);
        this.writeInt(101);
        this.writeInt(vboIndex);
        this.writeInt(restoreData.flags);
        this.writeInt(restoreData.lastColor);
        this.writeInt(restoreData.lastNormal);
        this.writeFloat(restoreData.lastTexCoordU);
        this.writeFloat(restoreData.lastTexCoordV);
    }

    public void writeCallList(int listId) {
        this.ensureCapacity(8);
        this.writeInt(102);
        this.writeInt(listId);
    }

    public void writeDrawArrays(int mode, int start, int count) {
        this.ensureCapacity(16);
        this.writeInt(110);
        this.writeInt(mode);
        this.writeInt(start);
        this.writeInt(count);
    }

    public void writeDrawElements(int mode, int indices_count, int type, long indices_buffer_offset) {
        this.ensureCapacity(24);
        this.writeInt(111);
        this.writeInt(mode);
        this.writeInt(indices_count);
        this.writeInt(type);
        this.writeLong(indices_buffer_offset);
    }

    public void writeBindVBO(int vbo) {
        this.ensureCapacity(8);
        this.writeInt(120);
        this.writeInt(vbo);
    }

    public void writeBindVAO(int vao) {
        this.ensureCapacity(8);
        this.writeInt(121);
        this.writeInt(vao);
    }

    public void writeDrawBuffer(int mode) {
        this.ensureCapacity(8);
        this.writeInt(112);
        this.writeInt(mode);
    }

    public void writeDrawBuffers(int count, int buffer) {
        this.ensureCapacity(40);
        this.writeInt(113);
        this.writeInt(count);
        this.writeInt(buffer);
        for (int i = 1; i < 8; ++i) {
            this.writeInt(0);
        }
    }

    public void writeDrawBuffers(int count, IntBuffer bufs) {
        int i;
        this.ensureCapacity(40);
        this.writeInt(113);
        this.writeInt(count);
        int pos = bufs.position();
        for (i = 0; i < count && i < 8; ++i) {
            this.writeInt(bufs.get(pos + i));
        }
        for (i = count; i < 8; ++i) {
            this.writeInt(0);
        }
    }

    public void writeComplexRef(DisplayListCommand cmd) {
        this.ensureCapacity(8);
        int index = this.complexObjects.size();
        this.complexObjects.add(cmd);
        this.writeInt(255);
        this.writeInt(index);
    }

    public void resetRead() {
        this.readPointer = this.basePointer;
    }

    public boolean hasRemaining() {
        return this.readPointer < this.writePointer;
    }

    public int readInt() {
        int value = MemoryUtilities.memGetInt((long)this.readPointer);
        this.readPointer += 4L;
        return value;
    }

    public long readLong() {
        long value = MemoryUtilities.memGetLong((long)this.readPointer);
        this.readPointer += 8L;
        return value;
    }

    public float readFloat() {
        float value = MemoryUtilities.memGetFloat((long)this.readPointer);
        this.readPointer += 4L;
        return value;
    }

    public double readDouble() {
        double value = MemoryUtilities.memGetDouble((long)this.readPointer);
        this.readPointer += 8L;
        return value;
    }

    public Matrix4f readMatrix4f(Matrix4f dest) {
        dest.m00(this.readFloat());
        dest.m01(this.readFloat());
        dest.m02(this.readFloat());
        dest.m03(this.readFloat());
        dest.m10(this.readFloat());
        dest.m11(this.readFloat());
        dest.m12(this.readFloat());
        dest.m13(this.readFloat());
        dest.m20(this.readFloat());
        dest.m21(this.readFloat());
        dest.m22(this.readFloat());
        dest.m23(this.readFloat());
        dest.m30(this.readFloat());
        dest.m31(this.readFloat());
        dest.m32(this.readFloat());
        dest.m33(this.readFloat());
        return dest;
    }

    public int size() {
        return (int)(this.writePointer - this.basePointer);
    }

    public long address() {
        return this.basePointer;
    }

    public ByteBuffer toBuffer() {
        ByteBuffer cfr_ignored_0 = (ByteBuffer)J_N_Buffer.limit((Buffer)this.buffer, (int)this.size());
        ByteBuffer cfr_ignored_1 = (ByteBuffer)J_N_Buffer.position((Buffer)this.buffer, (int)0);
        return this.buffer;
    }

    public Object[] getComplexObjects() {
        return this.complexObjects.toArray();
    }

    public Object getComplexObject(int index) {
        return this.complexObjects.get(index);
    }

    public boolean isEmpty() {
        return this.size() == 0 && this.complexObjects.isEmpty();
    }

    public void clear() {
        this.writePointer = this.basePointer;
        this.complexObjects.clear();
    }

    public void free() {
        if (this.buffer != null) {
            MemoryUtilities.memFree((ByteBuffer)this.buffer);
            this.buffer = null;
            this.basePointer = 0L;
            this.writePointer = 0L;
        }
    }
}

