/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.glsm.recording;

import com.gtnewhorizon.gtnhlib.client.renderer.DirectTessellator;
import com.gtnewhorizon.gtnhlib.client.renderer.vertex.VertexFormat;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={RestoreData.class})
public final class AccumulatedDraw {
    public final VertexFormat format;
    public final List<ByteBuffer> drawBuffers;
    public final int drawMode;
    public final int commandIndex;
    public final int stateGeneration;
    public RestoreData restoreData;

    public AccumulatedDraw(DirectTessellator tessellator, int commandIndex, int stateGeneration, boolean copyLast) {
        this.format = tessellator.getVertexFormat();
        this.drawMode = tessellator.field_78409_u;
        this.drawBuffers = new ArrayList<ByteBuffer>();
        this.drawBuffers.add(tessellator.allocateBufferCopy());
        this.commandIndex = commandIndex;
        this.stateGeneration = stateGeneration;
        if (copyLast) {
            this.restoreData = new RestoreData(tessellator);
        }
    }

    public void mergeDraw(DirectTessellator tessellator, boolean copyLast) {
        this.drawBuffers.add(tessellator.allocateBufferCopy());
        if (copyLast) {
            this.restoreData = new RestoreData(tessellator);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=AccumulatedDraw.class)
    public static final class RestoreData {
        public final int lastColor;
        public final int lastNormal;
        public final float lastTexCoordU;
        public final float lastTexCoordV;
        public final int flags;

        public RestoreData(DirectTessellator tessellator) {
            this.lastColor = tessellator.getPackedColor();
            this.lastNormal = tessellator.getPackedNormal();
            this.lastTexCoordU = (float)tessellator.getLastTextureU();
            this.lastTexCoordV = (float)tessellator.getLastTextureV();
            this.flags = tessellator.getVertexFormat().getVertexFlags();
        }
    }
}

