/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.glsm;

import com.gtnewhorizons.angelica.glsm.DisplayListManager;
import com.gtnewhorizons.angelica.glsm.recording.commands.DisplayListCommand;
import com.gtnewhorizons.angelica.glsm.recording.commands.MultMatrixCmd;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

class TransformOptimizer {
    private static final Logger LOGGER = LogManager.getLogger((String)"TransformOptimizer");
    private final Matrix4f accumulated = new Matrix4f();
    private final Matrix4f lastEmitted = new Matrix4f();
    private final Deque<Matrix4f> stack = new ArrayDeque<Matrix4f>();
    private final int listId;
    private boolean absoluteMatrixFlag = false;

    TransformOptimizer(int listId) {
        this.listId = listId;
        this.accumulated.identity();
        this.lastEmitted.identity();
    }

    Matrix4f getAccumulated() {
        return this.accumulated;
    }

    void loadIdentity() {
        this.accumulated.identity();
    }

    void pushTransform() {
        this.stack.push(new Matrix4f((Matrix4fc)this.accumulated));
    }

    void popTransform() {
        if (!this.stack.isEmpty()) {
            Matrix4f popped = this.stack.pop();
            this.accumulated.set((Matrix4fc)popped);
            this.lastEmitted.set((Matrix4fc)this.accumulated);
        } else {
            LOGGER.warn("[TransformOptimizer] list={} Pop with empty stack - resetting to identity", new Object[]{this.listId});
            this.accumulated.identity();
            this.lastEmitted.identity();
        }
    }

    boolean isIdentity() {
        return DisplayListManager.isIdentity(this.accumulated);
    }

    boolean hasPendingTransform() {
        return !this.accumulated.equals((Object)this.lastEmitted);
    }

    void emitPendingTransform(List<DisplayListCommand> output) {
        if (!this.accumulated.equals((Object)this.lastEmitted)) {
            this.emitTransformTo(output, this.accumulated);
        }
    }

    void emitTransformTo(List<DisplayListCommand> output, Matrix4f target) {
        if (target.equals((Object)this.lastEmitted)) {
            return;
        }
        if (DisplayListManager.isIdentity(this.lastEmitted)) {
            output.add(MultMatrixCmd.create(target));
        } else {
            Matrix4f delta = new Matrix4f((Matrix4fc)this.lastEmitted).invert().mul((Matrix4fc)target);
            output.add(MultMatrixCmd.create(delta));
        }
        this.lastEmitted.set((Matrix4fc)target);
    }

    boolean needsTransformForDraw(Matrix4f drawTransform) {
        return !drawTransform.equals((Object)this.lastEmitted);
    }

    void markAbsoluteMatrix() {
        this.absoluteMatrixFlag = true;
    }

    boolean checkAndClearAbsoluteMatrix() {
        boolean was = this.absoluteMatrixFlag;
        this.absoluteMatrixFlag = false;
        return was;
    }
}

