/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.glsm;

import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.glsm.dsa.DSAARB;
import com.gtnewhorizons.angelica.glsm.dsa.DSAAccess;
import com.gtnewhorizons.angelica.glsm.dsa.DSACore;
import com.gtnewhorizons.angelica.glsm.dsa.DSAUnsupported;
import com.gtnewhorizons.angelica.glsm.texture.TextureInfoCache;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import net.coderbot.iris.gl.shader.StandardMacros;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3i;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBBufferStorage;
import org.lwjgl.opengl.ARBClearBufferObject;
import org.lwjgl.opengl.ARBClearTexture;
import org.lwjgl.opengl.EXTShaderImageLoadStore;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL33;
import org.lwjgl.opengl.GL40;
import org.lwjgl.opengl.GL42;
import org.lwjgl.opengl.GL43;
import org.lwjgl.opengl.GL44;

public class RenderSystem {
    private static final Logger LOGGER = LogManager.getLogger((String)"RenderSystem");
    private static DSAAccess dsaState;
    private static boolean supportsCompute;
    private static boolean supportsImageLoadStore;
    private static boolean supportsSSBO;
    private static boolean supportsBufferStorage;
    private static boolean supportsClearTexture;
    private static boolean supportsTesselation;
    private static boolean supportsSamplerObjects;
    private static int maxImageUnits;
    private static int maxSSBOBindings;
    private static int maxGlslVersion;
    private static boolean supportsGpuShader4;
    private static int[] samplers;
    public static final FloatBuffer PROJECTION_MATRIX_BUFFER;

    private RenderSystem() {
    }

    public static void initRenderer() {
        try {
            if (GLStateManager.capabilities.OpenGL45) {
                dsaState = new DSACore();
                LOGGER.info("OpenGL 4.5 detected, enabling DSA.");
            }
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        try {
            if (dsaState == null && GLStateManager.capabilities.GL_ARB_direct_state_access) {
                dsaState = new DSAARB();
                LOGGER.info("ARB_direct_state_access detected, enabling DSA.");
            }
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        if (dsaState == null) {
            dsaState = new DSAUnsupported();
            LOGGER.info("No DSA support detected, falling back to legacy OpenGL.");
        }
        supportsCompute = RenderSystem.supportsCompute();
        supportsTesselation = GLStateManager.capabilities.GL_ARB_tessellation_shader || GLStateManager.capabilities.OpenGL40;
        supportsImageLoadStore = GLStateManager.capabilities.OpenGL42 || GLStateManager.capabilities.GL_ARB_shader_image_load_store || GLStateManager.capabilities.GL_EXT_shader_image_load_store;
        supportsSSBO = GLStateManager.capabilities.OpenGL43 || GLStateManager.capabilities.GL_ARB_shader_storage_buffer_object;
        supportsBufferStorage = GLStateManager.capabilities.OpenGL44 || GLStateManager.capabilities.GL_ARB_buffer_storage;
        boolean bl = supportsClearTexture = GLStateManager.capabilities.OpenGL44 || GLStateManager.capabilities.GL_ARB_clear_texture;
        maxImageUnits = supportsImageLoadStore ? (GLStateManager.capabilities.OpenGL42 ? GL11.glGetInteger((int)36664) : (GLStateManager.capabilities.GL_ARB_shader_image_load_store ? GL11.glGetInteger((int)36664) : GL11.glGetInteger((int)36664))) : 0;
        maxSSBOBindings = supportsSSBO ? (GLStateManager.capabilities.OpenGL43 ? GL11.glGetInteger((int)37085) : GL11.glGetInteger((int)37085)) : 0;
        boolean bl2 = supportsSamplerObjects = GLStateManager.capabilities.OpenGL33 || GLStateManager.capabilities.GL_ARB_sampler_objects;
        if (supportsSamplerObjects) {
            samplers = new int[GL11.glGetInteger((int)35661)];
        }
        maxGlslVersion = Integer.parseInt(StandardMacros.getGlVersion(35724));
        supportsGpuShader4 = GLStateManager.capabilities.GL_EXT_gpu_shader4;
        LOGGER.info("Max GLSL version: {}, GPU Shader4: {}", new Object[]{maxGlslVersion, supportsGpuShader4});
        LOGGER.info("Image Load/Store: {}, Max Image Units: {}", new Object[]{supportsImageLoadStore, maxImageUnits});
        LOGGER.info("SSBO: {}, Max SSBO Bindings: {}", new Object[]{supportsSSBO, maxSSBOBindings});
        LOGGER.info("Buffer Storage: {}, Clear Texture: {}, Sampler Objects: {}", new Object[]{supportsBufferStorage, supportsClearTexture, supportsSamplerObjects});
    }

    public static void generateMipmaps(int texture, int mipmapTarget) {
        dsaState.generateMipmaps(texture, mipmapTarget);
    }

    public static void bindAttributeLocation(int program, int index, CharSequence name) {
        GL20.glBindAttribLocation((int)program, (int)index, (CharSequence)name);
    }

    public static void texImage2D(int texture, int target, int level, int internalformat, int width, int height, int border, int format, int type, @Nullable ByteBuffer pixels) {
        GLStateManager.glBindTexture(target, texture);
        GL11.glTexImage2D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)format, (int)type, (ByteBuffer)pixels);
        if (target == 3553 && level == 0) {
            TextureInfoCache.INSTANCE.onTexImage2D(target, level, internalformat, width, height, border, format, type, pixels);
        }
    }

    public static void uniformMatrix4fv(int location, boolean transpose, FloatBuffer matrix) {
        GL20.glUniformMatrix4((int)location, (boolean)transpose, (FloatBuffer)matrix);
    }

    public static void copyTexImage2D(int target, int level, int internalFormat, int x, int y, int width, int height, int border) {
        GLStateManager.glCopyTexImage2D(target, level, internalFormat, x, y, width, height, border);
    }

    public static void uniform1f(int location, float v0) {
        GL20.glUniform1f((int)location, (float)v0);
    }

    public static void uniform1i(int location, int v0) {
        GL20.glUniform1i((int)location, (int)v0);
    }

    public static void uniform2f(int location, float v0, float v1) {
        GL20.glUniform2f((int)location, (float)v0, (float)v1);
    }

    public static void uniform2i(int location, int v0, int v1) {
        GL20.glUniform2i((int)location, (int)v0, (int)v1);
    }

    public static void uniform3f(int location, float v0, float v1, float v2) {
        GL20.glUniform3f((int)location, (float)v0, (float)v1, (float)v2);
    }

    public static void uniform3i(int location, int v0, int v1, int v2) {
        GL20.glUniform3i((int)location, (int)v0, (int)v1, (int)v2);
    }

    public static void uniform4f(int location, float v0, float v1, float v2, float v3) {
        GL20.glUniform4f((int)location, (float)v0, (float)v1, (float)v2, (float)v3);
    }

    public static void uniform4i(int location, int v0, int v1, int v2, int v3) {
        GL20.glUniform4i((int)location, (int)v0, (int)v1, (int)v2, (int)v3);
    }

    public static int getAttribLocation(int programId, String name) {
        return GL20.glGetAttribLocation((int)programId, (CharSequence)name);
    }

    public static int getUniformLocation(int programId, String name) {
        return GL20.glGetUniformLocation((int)programId, (CharSequence)name);
    }

    public static void texParameteriv(int texture, int target, int pname, IntBuffer params) {
        dsaState.texParameteriv(texture, target, pname, params);
    }

    public static void copyTexSubImage2D(int destTexture, int target, int i, int i1, int i2, int i3, int i4, int width, int height) {
        dsaState.copyTexSubImage2D(destTexture, target, i, i1, i2, i3, i4, width, height);
    }

    public static void texParameteri(int texture, int target, int pname, int param) {
        dsaState.texParameteri(texture, target, pname, param);
    }

    public static void texParameterf(int texture, int target, int pname, float param) {
        dsaState.texParameterf(texture, target, pname, param);
    }

    public static void textureImage2D(int texture, int target, int level, int internalformat, int width, int height, int border, int format, int type, ByteBuffer pixels) {
        dsaState.textureImage2D(texture, target, level, internalformat, width, height, border, format, type, pixels);
    }

    public static void textureImage2D(int texture, int target, int level, int internalformat, int width, int height, int border, int format, int type, IntBuffer pixels) {
        dsaState.textureImage2D(texture, target, level, internalformat, width, height, border, format, type, pixels);
    }

    public static void textureSubImage2D(int texture, int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, ByteBuffer pixels) {
        dsaState.textureSubImage2D(texture, target, level, xoffset, yoffset, width, height, format, type, pixels);
    }

    public static void textureSubImage2D(int texture, int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, IntBuffer pixels) {
        dsaState.textureSubImage2D(texture, target, level, xoffset, yoffset, width, height, format, type, pixels);
    }

    public static void texImage1D(int texture, int target, int level, int internalformat, int width, int border, int format, int type, ByteBuffer pixels) {
        GL11.glBindTexture((int)target, (int)texture);
        GL11.glTexImage1D((int)target, (int)level, (int)internalformat, (int)width, (int)border, (int)format, (int)type, (ByteBuffer)pixels);
    }

    public static void texImage3D(int texture, int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, ByteBuffer pixels) {
        GL11.glBindTexture((int)target, (int)texture);
        GL12.glTexImage3D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)depth, (int)border, (int)format, (int)type, (ByteBuffer)pixels);
    }

    public static String getProgramInfoLog(int program) {
        return GL20.glGetProgramInfoLog((int)program, (int)GL20.glGetProgrami((int)program, (int)35716));
    }

    public static String getShaderInfoLog(int shader) {
        return GL20.glGetShaderInfoLog((int)shader, (int)GL20.glGetShaderi((int)shader, (int)35716));
    }

    public static void drawBuffers(int framebuffer, IntBuffer buffers) {
        dsaState.drawBuffers(framebuffer, buffers);
    }

    public static void readBuffer(int framebuffer, int buffer) {
        dsaState.readBuffer(framebuffer, buffer);
    }

    public static String getActiveUniform(int program, int index, int maxLength, IntBuffer sizeType) {
        return GL20.glGetActiveUniform((int)program, (int)index, (int)maxLength, (IntBuffer)sizeType);
    }

    public static void readPixels(int x, int y, int width, int height, int format, int type, FloatBuffer pixels) {
        GL11.glReadPixels((int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (FloatBuffer)pixels);
    }

    public static void bufferData(int target, FloatBuffer data, int usage) {
        GL15.glBufferData((int)target, (FloatBuffer)data, (int)usage);
    }

    public static int bufferStorage(int target, FloatBuffer data, int usage) {
        return dsaState.bufferStorage(target, data, usage);
    }

    public static void vertexAttrib4f(int index, float v0, float v1, float v2, float v3) {
        GL20.glVertexAttrib4f((int)index, (float)v0, (float)v1, (float)v2, (float)v3);
    }

    public static void detachShader(int program, int shader) {
        GL20.glDetachShader((int)program, (int)shader);
    }

    public static void framebufferTexture2D(int fb, int fbtarget, int attachment, int target, int texture, int levels) {
        dsaState.framebufferTexture2D(fb, fbtarget, attachment, target, texture, levels);
    }

    public static int getTexParameteri(int texture, int target, int pname) {
        return dsaState.getTexParameteri(texture, target, pname);
    }

    public static int getTexLevelParameteri(int texture, int level, int pname) {
        return dsaState.getTexLevelParameteri(texture, level, pname);
    }

    public static void bindImageTexture(int unit, int texture, int level, boolean layered, int layer, int access, int format) {
        if (GLStateManager.capabilities.OpenGL42) {
            GL42.glBindImageTexture((int)unit, (int)texture, (int)level, (boolean)layered, (int)layer, (int)access, (int)format);
        } else {
            EXTShaderImageLoadStore.glBindImageTextureEXT((int)unit, (int)texture, (int)level, (boolean)layered, (int)layer, (int)access, (int)format);
        }
    }

    public static int getMaxImageUnits() {
        return maxImageUnits;
    }

    public static boolean supportsImageLoadStore() {
        return supportsImageLoadStore;
    }

    public static boolean supportsSSBO() {
        return supportsSSBO;
    }

    public static boolean supportsBufferStorage() {
        return supportsBufferStorage;
    }

    public static boolean supportsClearTexture() {
        return supportsClearTexture;
    }

    public static int getMaxSSBOBindings() {
        return maxSSBOBindings;
    }

    public static void getProgramiv(int program, int value, IntBuffer storage) {
        GL20.glGetProgram((int)program, (int)value, (IntBuffer)storage);
    }

    public static void dispatchCompute(int workX, int workY, int workZ) {
        GL43.glDispatchCompute((int)workX, (int)workY, (int)workZ);
    }

    public static void dispatchCompute(Vector3i workGroups) {
        GL43.glDispatchCompute((int)workGroups.x, (int)workGroups.y, (int)workGroups.z);
    }

    public static void dispatchComputeIndirect(long offset) {
        GL43.glDispatchComputeIndirect((long)offset);
    }

    public static void bindBuffer(int target, int buffer) {
        GLStateManager.glBindBuffer(target, buffer);
    }

    public static void memoryBarrier(int barriers) {
        if (supportsCompute) {
            GL42.glMemoryBarrier((int)barriers);
        }
    }

    public static boolean supportsBufferBlending() {
        return GLStateManager.capabilities.GL_ARB_draw_buffers_blend || GLStateManager.capabilities.OpenGL40;
    }

    public static void disableBufferBlend(int buffer) {
        GL30.glDisablei((int)3042, (int)buffer);
    }

    public static void enableBufferBlend(int buffer) {
        GL30.glEnablei((int)3042, (int)buffer);
    }

    public static void blendFuncSeparatei(int buffer, int srcRGB, int dstRGB, int srcAlpha, int dstAlpha) {
        GL40.glBlendFuncSeparatei((int)buffer, (int)srcRGB, (int)dstRGB, (int)srcAlpha, (int)dstAlpha);
    }

    public static void bindTextureToUnit(int unit, int texture) {
        dsaState.bindTextureToUnit(unit, texture);
    }

    public static void bindTextureToUnit(int target, int unit, int texture) {
        dsaState.bindTextureToUnit(target, unit, texture);
    }

    public static void setupProjectionMatrix(Matrix4f matrix) {
        GLStateManager.glMatrixMode(5889);
        GLStateManager.glPushMatrix();
        matrix.get(0, PROJECTION_MATRIX_BUFFER);
        GLStateManager.glLoadMatrix(PROJECTION_MATRIX_BUFFER);
        GLStateManager.glMatrixMode(5888);
    }

    public static void restoreProjectionMatrix() {
        GLStateManager.glMatrixMode(5889);
        GLStateManager.glPopMatrix();
        GLStateManager.glMatrixMode(5888);
    }

    public static void blitFramebuffer(int source, int dest, int offsetX, int offsetY, int width, int height, int offsetX2, int offsetY2, int width2, int height2, int bufferChoice, int filter) {
        dsaState.blitFramebuffer(source, dest, offsetX, offsetY, width, height, offsetX2, offsetY2, width2, height2, bufferChoice, filter);
    }

    public static int createFramebuffer() {
        return dsaState.createFramebuffer();
    }

    public static int createTexture(int target) {
        return dsaState.createTexture(target);
    }

    public static boolean supportsCompute() {
        try {
            return GLStateManager.capabilities.GL_ARB_compute_shader;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public static int createBuffers() {
        return GL15.glGenBuffers();
    }

    public static void bindBufferBase(int target, int index, int buffer) {
        GL30.glBindBufferBase((int)target, (int)index, (int)buffer);
    }

    public static void bufferStorage(int target, long size, int flags) {
        if (GLStateManager.capabilities.OpenGL44) {
            GL44.glBufferStorage((int)target, (long)size, (int)flags);
        } else if (GLStateManager.capabilities.GL_ARB_buffer_storage) {
            ARBBufferStorage.glBufferStorage((int)target, (long)size, (int)flags);
        } else {
            GL15.glBufferData((int)target, (long)size, (int)35048);
        }
    }

    public static void clearBufferSubData(int target, int internalFormat, long offset, long size, int format, int type, int[] data) {
        ByteBuffer buf = BufferUtils.createByteBuffer((int)(data.length * 4));
        buf.asIntBuffer().put(data);
        if (GLStateManager.capabilities.OpenGL43) {
            GL43.glClearBufferSubData((int)target, (int)internalFormat, (long)offset, (long)size, (int)format, (int)type, (ByteBuffer)buf);
        } else if (GLStateManager.capabilities.GL_ARB_clear_buffer_object) {
            ARBClearBufferObject.glClearBufferSubData((int)target, (int)internalFormat, (long)offset, (long)size, (int)format, (int)type, (ByteBuffer)buf);
        }
    }

    public static void deleteBuffers(int buffer) {
        GL15.glDeleteBuffers((int)buffer);
    }

    public static long getVRAM() {
        if (GLStateManager.capabilities.GL_NVX_gpu_memory_info) {
            return (long)GL11.glGetInteger((int)36937) * 1024L;
        }
        return 0x100000000L;
    }

    public static void clearTexImage(int texture, int target, int level, int format, int type) {
        if (GLStateManager.capabilities.OpenGL44) {
            GL44.glClearTexImage((int)texture, (int)level, (int)format, (int)type, (ByteBuffer)null);
        } else {
            ARBClearTexture.glClearTexImage((int)texture, (int)level, (int)format, (int)type, (ByteBuffer)null);
        }
    }

    public static void textureStorage1D(int texture, int target, int levels, int internalFormat, int width) {
        dsaState.textureStorage1D(texture, target, levels, internalFormat, width);
    }

    public static void textureStorage2D(int texture, int target, int levels, int internalFormat, int width, int height) {
        dsaState.textureStorage2D(texture, target, levels, internalFormat, width, height);
    }

    public static void textureStorage3D(int texture, int target, int levels, int internalFormat, int width, int height, int depth) {
        dsaState.textureStorage3D(texture, target, levels, internalFormat, width, height, depth);
    }

    public static int getMaxGlslVersion() {
        return maxGlslVersion;
    }

    public static boolean supportsGpuShader4() {
        return supportsGpuShader4;
    }

    public static boolean supportsSnormFormats() {
        return GLStateManager.capabilities.OpenGL31;
    }

    public static boolean supportsPackedFloatRenderable() {
        return GLStateManager.capabilities.OpenGL30 && maxGlslVersion >= 130;
    }

    public static boolean supportsTesselation() {
        return supportsTesselation;
    }

    public static boolean supportsSamplerObjects() {
        return supportsSamplerObjects;
    }

    public static int genSampler() {
        if (!supportsSamplerObjects) {
            return 0;
        }
        return GL33.glGenSamplers();
    }

    public static void destroySampler(int sampler) {
        if (!supportsSamplerObjects || sampler == 0) {
            return;
        }
        GL33.glDeleteSamplers((int)sampler);
    }

    public static void samplerParameteri(int sampler, int pname, int param) {
        if (!supportsSamplerObjects || sampler == 0) {
            return;
        }
        GL33.glSamplerParameteri((int)sampler, (int)pname, (int)param);
    }

    public static void bindSamplerToUnit(int unit, int sampler) {
        if (!supportsSamplerObjects) {
            return;
        }
        if (samplers[unit] == sampler) {
            return;
        }
        GL33.glBindSampler((int)unit, (int)sampler);
        RenderSystem.samplers[unit] = sampler;
    }

    public static void unbindAllSamplers() {
        if (!supportsSamplerObjects) {
            return;
        }
        for (int i = 0; i < samplers.length; ++i) {
            if (samplers[i] == 0) continue;
            GL33.glBindSampler((int)i, (int)0);
            RenderSystem.samplers[i] = 0;
        }
    }

    static {
        PROJECTION_MATRIX_BUFFER = BufferUtils.createFloatBuffer((int)16);
    }
}

