/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.glsm;

import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.loading.AngelicaTweaker;
import org.lwjgl.opengl.AMDDebugOutput;
import org.lwjgl.opengl.AMDDebugOutputCallback;
import org.lwjgl.opengl.ARBDebugOutput;
import org.lwjgl.opengl.ARBDebugOutputCallback;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL43;
import org.lwjgl.opengl.KHRDebug;
import org.lwjgl.opengl.KHRDebugCallback;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={UnsupportedDebugState.class, KHRDebugState.class, DebugState.class})
public final class GLDebug {
    private static DebugState debugState;

    public static int setupDebugMessageCallback() {
        if (Thread.currentThread() != GLStateManager.getMainThread()) {
            AngelicaTweaker.LOGGER.warn("setupDebugMessageCallback called from non-main thread!");
            return 0;
        }
        return GLDebug.setupDebugMessageCallbackImpl();
    }

    public static Throwable filterStackTrace(Throwable throwable, int offset) {
        StackTraceElement[] elems = throwable.getStackTrace();
        StackTraceElement[] filtered = new StackTraceElement[elems.length];
        int j = 0;
        for (int i = offset; i < elems.length; ++i) {
            String className = elems[i].getClassName();
            if (className == null) {
                className = "";
            }
            filtered[j++] = elems[i];
        }
        StackTraceElement[] newElems = new StackTraceElement[j];
        System.arraycopy(filtered, 0, newElems, 0, j);
        throwable.setStackTrace(newElems);
        return throwable;
    }

    private static String buildStackTrace() {
        StackTraceElement[] elems = GLDebug.filterStackTrace(new Throwable(), 4).getStackTrace();
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement elem : elems) {
            sb.append("\n\t").append(elem.toString());
        }
        return sb.toString();
    }

    private static void logDebugMessage(int id, String source, String type, String severity, String message) {
        String fullMessage = String.format("[GL] %s %s (0x%X) from %s: %s%s", severity, type, id, source, message, GLDebug.buildStackTrace());
        if ("HIGH".equals(severity)) {
            AngelicaTweaker.LOGGER.error(fullMessage);
        } else if ("MEDIUM".equals(severity)) {
            AngelicaTweaker.LOGGER.warn(fullMessage);
        } else {
            AngelicaTweaker.LOGGER.info(fullMessage);
        }
    }

    private static void logDebugMessageAMD(int id, String category, String severity, String message) {
        String fullMessage = String.format("[GL] %s %s (0x%X): %s%s", severity, category, id, message, GLDebug.buildStackTrace());
        if ("HIGH".equals(severity)) {
            AngelicaTweaker.LOGGER.error(fullMessage);
        } else if ("MEDIUM".equals(severity)) {
            AngelicaTweaker.LOGGER.warn(fullMessage);
        } else {
            AngelicaTweaker.LOGGER.info(fullMessage);
        }
    }

    private static int setupDebugMessageCallbackImpl() {
        if (GLStateManager.capabilities.OpenGL43 || GLStateManager.capabilities.GL_KHR_debug) {
            AngelicaTweaker.LOGGER.info("[GL] Using OpenGL 4.3 for error logging.");
            KHRDebugCallback proc = new KHRDebugCallback((source, type, id, severity, message) -> GLDebug.logDebugMessage(id, GLDebug.getDebugSource(source), GLDebug.getDebugType(type), GLDebug.getDebugSeverity(severity), message));
            GL43.glDebugMessageControl((int)4352, (int)4352, (int)37190, null, (boolean)true);
            GL43.glDebugMessageControl((int)4352, (int)4352, (int)37191, null, (boolean)false);
            GL43.glDebugMessageControl((int)4352, (int)4352, (int)37192, null, (boolean)false);
            GL43.glDebugMessageControl((int)4352, (int)4352, (int)33387, null, (boolean)false);
            GL43.glDebugMessageCallback((KHRDebugCallback)proc);
            GL11.glEnable((int)33346);
            if ((GL11.glGetInteger((int)33310) & 2) == 0) {
                AngelicaTweaker.LOGGER.warn("[GL] Warning: A non-debug context may not produce any debug output.");
                GL11.glEnable((int)37600);
                return 2;
            }
            return 1;
        }
        if (GLStateManager.capabilities.GL_ARB_debug_output) {
            AngelicaTweaker.LOGGER.info("[GL] Using ARB_debug_output for error logging.");
            ARBDebugOutputCallback proc = new ARBDebugOutputCallback((source, type, id, severity, message) -> GLDebug.logDebugMessage(id, GLDebug.getSourceARB(source), GLDebug.getTypeARB(type), GLDebug.getSeverityARB(severity), message));
            ARBDebugOutput.glDebugMessageControlARB((int)4352, (int)4352, (int)37190, null, (boolean)true);
            ARBDebugOutput.glDebugMessageControlARB((int)4352, (int)4352, (int)37191, null, (boolean)false);
            ARBDebugOutput.glDebugMessageControlARB((int)4352, (int)4352, (int)37192, null, (boolean)false);
            ARBDebugOutput.glDebugMessageControlARB((int)4352, (int)4352, (int)33387, null, (boolean)false);
            ARBDebugOutput.glDebugMessageCallbackARB((ARBDebugOutputCallback)proc);
            GL11.glEnable((int)33346);
            return 1;
        }
        if (GLStateManager.capabilities.GL_AMD_debug_output) {
            AngelicaTweaker.LOGGER.info("[GL] Using AMD_debug_output for error logging.");
            AMDDebugOutputCallback proc = new AMDDebugOutputCallback((id, category, severity, message) -> GLDebug.logDebugMessageAMD(id, GLDebug.getCategoryAMD(category), GLDebug.getSeverityAMD(severity), message));
            AMDDebugOutput.glDebugMessageEnableAMD((int)0, (int)37190, null, (boolean)true);
            AMDDebugOutput.glDebugMessageEnableAMD((int)0, (int)37191, null, (boolean)false);
            AMDDebugOutput.glDebugMessageEnableAMD((int)0, (int)37192, null, (boolean)false);
            AMDDebugOutput.glDebugMessageEnableAMD((int)0, (int)33387, null, (boolean)false);
            AMDDebugOutput.glDebugMessageCallbackAMD((AMDDebugOutputCallback)proc);
            return 1;
        }
        AngelicaTweaker.LOGGER.info("[GL] No debug output implementation is available, cannot return debug info.");
        return 0;
    }

    public static int disableDebugMessages() {
        if (GLStateManager.capabilities.OpenGL43) {
            GL43.glDebugMessageCallback(null);
            return 1;
        }
        if (GLStateManager.capabilities.GL_KHR_debug) {
            KHRDebug.glDebugMessageCallback(null);
            if (GLStateManager.capabilities.OpenGL30 && (GL11.glGetInteger((int)33310) & 2) == 0) {
                GL11.glDisable((int)37600);
            }
            return 1;
        }
        if (GLStateManager.capabilities.GL_ARB_debug_output) {
            ARBDebugOutput.glDebugMessageCallbackARB(null);
            return 1;
        }
        if (GLStateManager.capabilities.GL_AMD_debug_output) {
            AMDDebugOutput.glDebugMessageCallbackAMD(null);
            return 1;
        }
        AngelicaTweaker.LOGGER.info("[GL] No debug output implementation is available, cannot disable debug info.");
        return 0;
    }

    private static String getDebugSource(int source) {
        String string;
        switch (source) {
            case 33350: {
                string = "API";
                break;
            }
            case 33351: {
                string = "WINDOW SYSTEM";
                break;
            }
            case 33352: {
                string = "SHADER COMPILER";
                break;
            }
            case 33353: {
                string = "THIRD PARTY";
                break;
            }
            case 33354: {
                string = "APPLICATION";
                break;
            }
            case 33355: {
                string = "OTHER";
                break;
            }
            default: {
                string = String.format("Unknown [0x%X]", source);
            }
        }
        return string;
    }

    private static String getDebugType(int type) {
        String string;
        switch (type) {
            case 33356: {
                string = "ERROR";
                break;
            }
            case 33357: {
                string = "DEPRECATED BEHAVIOR";
                break;
            }
            case 33358: {
                string = "UNDEFINED BEHAVIOR";
                break;
            }
            case 33359: {
                string = "PORTABILITY";
                break;
            }
            case 33360: {
                string = "PERFORMANCE";
                break;
            }
            case 33361: {
                string = "OTHER";
                break;
            }
            case 33384: {
                string = "MARKER";
                break;
            }
            default: {
                string = String.format("Unknown [0x%X]", type);
            }
        }
        return string;
    }

    private static String getDebugSeverity(int severity) {
        String string;
        switch (severity) {
            case 33387: {
                string = "NOTIFICATION";
                break;
            }
            case 37190: {
                string = "HIGH";
                break;
            }
            case 37191: {
                string = "MEDIUM";
                break;
            }
            case 37192: {
                string = "LOW";
                break;
            }
            default: {
                string = String.format("Unknown [0x%X]", severity);
            }
        }
        return string;
    }

    private static String getSourceARB(int source) {
        String string;
        switch (source) {
            case 33350: {
                string = "API";
                break;
            }
            case 33351: {
                string = "WINDOW SYSTEM";
                break;
            }
            case 33352: {
                string = "SHADER COMPILER";
                break;
            }
            case 33353: {
                string = "THIRD PARTY";
                break;
            }
            case 33354: {
                string = "APPLICATION";
                break;
            }
            case 33355: {
                string = "OTHER";
                break;
            }
            default: {
                string = String.format("Unknown [0x%X]", source);
            }
        }
        return string;
    }

    private static String getTypeARB(int type) {
        String string;
        switch (type) {
            case 33356: {
                string = "ERROR";
                break;
            }
            case 33357: {
                string = "DEPRECATED BEHAVIOR";
                break;
            }
            case 33358: {
                string = "UNDEFINED BEHAVIOR";
                break;
            }
            case 33359: {
                string = "PORTABILITY";
                break;
            }
            case 33360: {
                string = "PERFORMANCE";
                break;
            }
            case 33361: {
                string = "OTHER";
                break;
            }
            default: {
                string = String.format("Unknown [0x%X]", type);
            }
        }
        return string;
    }

    private static String getSeverityARB(int severity) {
        String string;
        switch (severity) {
            case 37190: {
                string = "HIGH";
                break;
            }
            case 37191: {
                string = "MEDIUM";
                break;
            }
            case 37192: {
                string = "LOW";
                break;
            }
            default: {
                string = String.format("Unknown [0x%X]", severity);
            }
        }
        return string;
    }

    private static String getCategoryAMD(int category) {
        String string;
        switch (category) {
            case 37193: {
                string = "API ERROR";
                break;
            }
            case 37194: {
                string = "WINDOW SYSTEM";
                break;
            }
            case 37195: {
                string = "DEPRECATION";
                break;
            }
            case 37196: {
                string = "UNDEFINED BEHAVIOR";
                break;
            }
            case 37197: {
                string = "PERFORMANCE";
                break;
            }
            case 37198: {
                string = "SHADER COMPILER";
                break;
            }
            case 37199: {
                string = "APPLICATION";
                break;
            }
            case 37200: {
                string = "OTHER";
                break;
            }
            default: {
                string = String.format("Unknown [0x%X]", category);
            }
        }
        return string;
    }

    private static String getSeverityAMD(int severity) {
        String string;
        switch (severity) {
            case 37190: {
                string = "HIGH";
                break;
            }
            case 37191: {
                string = "MEDIUM";
                break;
            }
            case 37192: {
                string = "LOW";
                break;
            }
            default: {
                string = String.format("Unknown [0x%X]", severity);
            }
        }
        return string;
    }

    public static String getMatrixModeName(int mode) {
        String string;
        switch (mode) {
            case 5888: {
                string = "MODELVIEW";
                break;
            }
            case 5889: {
                string = "PROJECTION";
                break;
            }
            case 5890: {
                string = "TEXTURE";
                break;
            }
            case 6144: {
                string = "COLOR";
                break;
            }
            default: {
                string = String.format("0x%X", mode);
            }
        }
        return string;
    }

    public static String getCapabilityName(int cap) {
        String string;
        switch (cap) {
            case 3008: {
                string = "ALPHA_TEST";
                break;
            }
            case 3042: {
                string = "BLEND";
                break;
            }
            case 2903: {
                string = "COLOR_MATERIAL";
                break;
            }
            case 2884: {
                string = "CULL_FACE";
                break;
            }
            case 2929: {
                string = "DEPTH_TEST";
                break;
            }
            case 2912: {
                string = "FOG";
                break;
            }
            case 2896: {
                string = "LIGHTING";
                break;
            }
            case 2848: {
                string = "LINE_SMOOTH";
                break;
            }
            case 2977: {
                string = "NORMALIZE";
                break;
            }
            case 2832: {
                string = "POINT_SMOOTH";
                break;
            }
            case 32823: {
                string = "POLYGON_OFFSET_FILL";
                break;
            }
            case 10754: {
                string = "POLYGON_OFFSET_LINE";
                break;
            }
            case 2881: {
                string = "POLYGON_SMOOTH";
                break;
            }
            case 32826: {
                string = "RESCALE_NORMAL";
                break;
            }
            case 3089: {
                string = "SCISSOR_TEST";
                break;
            }
            case 2960: {
                string = "STENCIL_TEST";
                break;
            }
            case 3552: {
                string = "TEXTURE_1D";
                break;
            }
            case 3553: {
                string = "TEXTURE_2D";
                break;
            }
            case 16384: {
                string = "LIGHT0";
                break;
            }
            case 16385: {
                string = "LIGHT1";
                break;
            }
            case 16386: {
                string = "LIGHT2";
                break;
            }
            case 16387: {
                string = "LIGHT3";
                break;
            }
            case 16388: {
                string = "LIGHT4";
                break;
            }
            case 16389: {
                string = "LIGHT5";
                break;
            }
            case 16390: {
                string = "LIGHT6";
                break;
            }
            case 16391: {
                string = "LIGHT7";
                break;
            }
            default: {
                string = String.format("0x%X", cap);
            }
        }
        return string;
    }

    public static String getComparisonFuncName(int func) {
        String string;
        switch (func) {
            case 512: {
                string = "NEVER";
                break;
            }
            case 513: {
                string = "LESS";
                break;
            }
            case 514: {
                string = "EQUAL";
                break;
            }
            case 515: {
                string = "LEQUAL";
                break;
            }
            case 516: {
                string = "GREATER";
                break;
            }
            case 517: {
                string = "NOTEQUAL";
                break;
            }
            case 518: {
                string = "GEQUAL";
                break;
            }
            case 519: {
                string = "ALWAYS";
                break;
            }
            default: {
                string = String.format("0x%X", func);
            }
        }
        return string;
    }

    public static String getBlendFactorName(int factor) {
        String string;
        switch (factor) {
            case 0: {
                string = "ZERO";
                break;
            }
            case 1: {
                string = "ONE";
                break;
            }
            case 768: {
                string = "SRC_COLOR";
                break;
            }
            case 769: {
                string = "ONE_MINUS_SRC_COLOR";
                break;
            }
            case 774: {
                string = "DST_COLOR";
                break;
            }
            case 775: {
                string = "ONE_MINUS_DST_COLOR";
                break;
            }
            case 770: {
                string = "SRC_ALPHA";
                break;
            }
            case 771: {
                string = "ONE_MINUS_SRC_ALPHA";
                break;
            }
            case 772: {
                string = "DST_ALPHA";
                break;
            }
            case 773: {
                string = "ONE_MINUS_DST_ALPHA";
                break;
            }
            case 32769: {
                string = "CONSTANT_COLOR";
                break;
            }
            case 32770: {
                string = "ONE_MINUS_CONSTANT_COLOR";
                break;
            }
            case 32771: {
                string = "CONSTANT_ALPHA";
                break;
            }
            case 32772: {
                string = "ONE_MINUS_CONSTANT_ALPHA";
                break;
            }
            case 776: {
                string = "SRC_ALPHA_SATURATE";
                break;
            }
            default: {
                string = String.format("0x%X", factor);
            }
        }
        return string;
    }

    public static String getShadeModelName(int mode) {
        String string;
        switch (mode) {
            case 7424: {
                string = "FLAT";
                break;
            }
            case 7425: {
                string = "SMOOTH";
                break;
            }
            default: {
                string = String.format("0x%X", mode);
            }
        }
        return string;
    }

    public static String getTextureTargetName(int target) {
        String string;
        switch (target) {
            case 3552: {
                string = "TEXTURE_1D";
                break;
            }
            case 3553: {
                string = "TEXTURE_2D";
                break;
            }
            case 32879: {
                string = "TEXTURE_3D";
                break;
            }
            case 34067: {
                string = "TEXTURE_CUBE_MAP";
                break;
            }
            default: {
                string = String.format("0x%X", target);
            }
        }
        return string;
    }

    public static String getTexturePnameName(int pname) {
        String string;
        switch (pname) {
            case 10241: {
                string = "TEXTURE_MIN_FILTER";
                break;
            }
            case 10240: {
                string = "TEXTURE_MAG_FILTER";
                break;
            }
            case 10242: {
                string = "TEXTURE_WRAP_S";
                break;
            }
            case 10243: {
                string = "TEXTURE_WRAP_T";
                break;
            }
            case 32882: {
                string = "TEXTURE_WRAP_R";
                break;
            }
            case 33082: {
                string = "TEXTURE_MIN_LOD";
                break;
            }
            case 33083: {
                string = "TEXTURE_MAX_LOD";
                break;
            }
            case 33084: {
                string = "TEXTURE_BASE_LEVEL";
                break;
            }
            case 33085: {
                string = "TEXTURE_MAX_LEVEL";
                break;
            }
            case 4100: {
                string = "TEXTURE_BORDER_COLOR";
                break;
            }
            case 32870: {
                string = "TEXTURE_PRIORITY";
                break;
            }
            case 34049: {
                string = "TEXTURE_LOD_BIAS";
                break;
            }
            case 33169: {
                string = "GENERATE_MIPMAP";
                break;
            }
            default: {
                string = String.format("0x%X", pname);
            }
        }
        return string;
    }

    public static String getTextureFormatName(int format) {
        String string;
        switch (format) {
            case 6403: {
                string = "RED";
                break;
            }
            case 6404: {
                string = "GREEN";
                break;
            }
            case 6405: {
                string = "BLUE";
                break;
            }
            case 6406: {
                string = "ALPHA";
                break;
            }
            case 6407: {
                string = "RGB";
                break;
            }
            case 6408: {
                string = "RGBA";
                break;
            }
            case 6409: {
                string = "LUMINANCE";
                break;
            }
            case 6410: {
                string = "LUMINANCE_ALPHA";
                break;
            }
            case 32992: {
                string = "BGR";
                break;
            }
            case 32993: {
                string = "BGRA";
                break;
            }
            case 6402: {
                string = "DEPTH_COMPONENT";
                break;
            }
            case 6401: {
                string = "STENCIL_INDEX";
                break;
            }
            case 34041: {
                string = "DEPTH_STENCIL";
                break;
            }
            case 32849: {
                string = "RGB8";
                break;
            }
            case 32856: {
                string = "RGBA8";
                break;
            }
            case 32828: {
                string = "ALPHA8";
                break;
            }
            case 32832: {
                string = "LUMINANCE8";
                break;
            }
            case 32837: {
                string = "LUMINANCE8_ALPHA8";
                break;
            }
            default: {
                string = String.format("0x%X", format);
            }
        }
        return string;
    }

    public static String getDataTypeName(int type) {
        String string;
        switch (type) {
            case 5121: {
                string = "UNSIGNED_BYTE";
                break;
            }
            case 5120: {
                string = "BYTE";
                break;
            }
            case 5123: {
                string = "UNSIGNED_SHORT";
                break;
            }
            case 5122: {
                string = "SHORT";
                break;
            }
            case 5125: {
                string = "UNSIGNED_INT";
                break;
            }
            case 5124: {
                string = "INT";
                break;
            }
            case 5126: {
                string = "FLOAT";
                break;
            }
            case 5130: {
                string = "DOUBLE";
                break;
            }
            case 32818: {
                string = "UNSIGNED_BYTE_3_3_2";
                break;
            }
            case 32819: {
                string = "UNSIGNED_SHORT_4_4_4_4";
                break;
            }
            case 32820: {
                string = "UNSIGNED_SHORT_5_5_5_1";
                break;
            }
            case 32821: {
                string = "UNSIGNED_INT_8_8_8_8";
                break;
            }
            case 32822: {
                string = "UNSIGNED_INT_10_10_10_2";
                break;
            }
            default: {
                string = String.format("0x%X", type);
            }
        }
        return string;
    }

    public static String getLightName(int light) {
        String string;
        switch (light) {
            case 16384: {
                string = "LIGHT0";
                break;
            }
            case 16385: {
                string = "LIGHT1";
                break;
            }
            case 16386: {
                string = "LIGHT2";
                break;
            }
            case 16387: {
                string = "LIGHT3";
                break;
            }
            case 16388: {
                string = "LIGHT4";
                break;
            }
            case 16389: {
                string = "LIGHT5";
                break;
            }
            case 16390: {
                string = "LIGHT6";
                break;
            }
            case 16391: {
                string = "LIGHT7";
                break;
            }
            default: {
                string = String.format("0x%X", light);
            }
        }
        return string;
    }

    public static String getLightPnameName(int pname) {
        String string;
        switch (pname) {
            case 4608: {
                string = "AMBIENT";
                break;
            }
            case 4609: {
                string = "DIFFUSE";
                break;
            }
            case 4610: {
                string = "SPECULAR";
                break;
            }
            case 4611: {
                string = "POSITION";
                break;
            }
            case 4612: {
                string = "SPOT_DIRECTION";
                break;
            }
            case 4613: {
                string = "SPOT_EXPONENT";
                break;
            }
            case 4614: {
                string = "SPOT_CUTOFF";
                break;
            }
            case 4615: {
                string = "CONSTANT_ATTENUATION";
                break;
            }
            case 4616: {
                string = "LINEAR_ATTENUATION";
                break;
            }
            case 4617: {
                string = "QUADRATIC_ATTENUATION";
                break;
            }
            default: {
                string = String.format("0x%X", pname);
            }
        }
        return string;
    }

    public static String getMaterialPnameName(int pname) {
        String string;
        switch (pname) {
            case 4608: {
                string = "AMBIENT";
                break;
            }
            case 4609: {
                string = "DIFFUSE";
                break;
            }
            case 4610: {
                string = "SPECULAR";
                break;
            }
            case 5632: {
                string = "EMISSION";
                break;
            }
            case 5633: {
                string = "SHININESS";
                break;
            }
            case 5634: {
                string = "AMBIENT_AND_DIFFUSE";
                break;
            }
            case 5635: {
                string = "COLOR_INDEXES";
                break;
            }
            default: {
                string = String.format("0x%X", pname);
            }
        }
        return string;
    }

    public static String getFaceName(int face) {
        String string;
        switch (face) {
            case 1028: {
                string = "FRONT";
                break;
            }
            case 1029: {
                string = "BACK";
                break;
            }
            case 1032: {
                string = "FRONT_AND_BACK";
                break;
            }
            default: {
                string = String.format("0x%X", face);
            }
        }
        return string;
    }

    public static String getColorMaterialModeName(int mode) {
        String string;
        switch (mode) {
            case 4608: {
                string = "AMBIENT";
                break;
            }
            case 4609: {
                string = "DIFFUSE";
                break;
            }
            case 4610: {
                string = "SPECULAR";
                break;
            }
            case 5632: {
                string = "EMISSION";
                break;
            }
            case 5634: {
                string = "AMBIENT_AND_DIFFUSE";
                break;
            }
            default: {
                string = String.format("0x%X", mode);
            }
        }
        return string;
    }

    public static String getFogPnameName(int pname) {
        String string;
        switch (pname) {
            case 2917: {
                string = "FOG_MODE";
                break;
            }
            case 2914: {
                string = "FOG_DENSITY";
                break;
            }
            case 2915: {
                string = "FOG_START";
                break;
            }
            case 2916: {
                string = "FOG_END";
                break;
            }
            case 2913: {
                string = "FOG_INDEX";
                break;
            }
            case 2918: {
                string = "FOG_COLOR";
                break;
            }
            default: {
                string = String.format("0x%X", pname);
            }
        }
        return string;
    }

    public static String getLightModelPnameName(int pname) {
        String string;
        switch (pname) {
            case 2899: {
                string = "LIGHT_MODEL_AMBIENT";
                break;
            }
            case 2897: {
                string = "LIGHT_MODEL_LOCAL_VIEWER";
                break;
            }
            case 2898: {
                string = "LIGHT_MODEL_TWO_SIDE";
                break;
            }
            case 33272: {
                string = "LIGHT_MODEL_COLOR_CONTROL";
                break;
            }
            default: {
                string = String.format("0x%X", pname);
            }
        }
        return string;
    }

    public static String getClearMaskString(int mask) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        if ((mask & 0x4000) != 0) {
            sb.append("COLOR");
            first = false;
        }
        if ((mask & 0x100) != 0) {
            if (!first) {
                sb.append("|");
            }
            sb.append("DEPTH");
            first = false;
        }
        if ((mask & 0x400) != 0) {
            if (!first) {
                sb.append("|");
            }
            sb.append("STENCIL");
            first = false;
        }
        if ((mask & 0x200) != 0) {
            if (!first) {
                sb.append("|");
            }
            sb.append("ACCUM");
        }
        return sb.toString();
    }

    public static String getCullFaceName(int mode) {
        String string;
        switch (mode) {
            case 1028: {
                string = "FRONT";
                break;
            }
            case 1029: {
                string = "BACK";
                break;
            }
            case 1032: {
                string = "FRONT_AND_BACK";
                break;
            }
            default: {
                string = String.format("0x%X", mode);
            }
        }
        return string;
    }

    public static String getLogicOpName(int opcode) {
        String string;
        switch (opcode) {
            case 5376: {
                string = "CLEAR";
                break;
            }
            case 5377: {
                string = "AND";
                break;
            }
            case 5378: {
                string = "AND_REVERSE";
                break;
            }
            case 5379: {
                string = "COPY";
                break;
            }
            case 5380: {
                string = "AND_INVERTED";
                break;
            }
            case 5381: {
                string = "NOOP";
                break;
            }
            case 5382: {
                string = "XOR";
                break;
            }
            case 5383: {
                string = "OR";
                break;
            }
            case 5384: {
                string = "NOR";
                break;
            }
            case 5385: {
                string = "EQUIV";
                break;
            }
            case 5386: {
                string = "INVERT";
                break;
            }
            case 5387: {
                string = "OR_REVERSE";
                break;
            }
            case 5388: {
                string = "COPY_INVERTED";
                break;
            }
            case 5389: {
                string = "OR_INVERTED";
                break;
            }
            case 5390: {
                string = "NAND";
                break;
            }
            case 5391: {
                string = "SET";
                break;
            }
            default: {
                string = String.format("0x%X", opcode);
            }
        }
        return string;
    }

    public static String getFramebufferStatusName(int status) {
        String string;
        switch (status) {
            case 36053: {
                string = "COMPLETE";
                break;
            }
            case 36054: {
                string = "INCOMPLETE_ATTACHMENT";
                break;
            }
            case 36055: {
                string = "INCOMPLETE_MISSING_ATTACHMENT";
                break;
            }
            case 36059: {
                string = "INCOMPLETE_DRAW_BUFFER";
                break;
            }
            case 36060: {
                string = "INCOMPLETE_READ_BUFFER";
                break;
            }
            case 36061: {
                string = "UNSUPPORTED";
                break;
            }
            case 36182: {
                string = "INCOMPLETE_MULTISAMPLE";
                break;
            }
            case 0: {
                string = "NO_FRAMEBUFFER_BOUND";
                break;
            }
            default: {
                string = String.format("UNKNOWN(0x%X)", status);
            }
        }
        return string;
    }

    public static String getInternalFormatName(int format) {
        String string;
        switch (format) {
            case 6408: {
                string = "RGBA";
                break;
            }
            case 6407: {
                string = "RGB";
                break;
            }
            case 33321: {
                string = "R8";
                break;
            }
            case 33323: {
                string = "RG8";
                break;
            }
            case 32849: {
                string = "RGB8";
                break;
            }
            case 32856: {
                string = "RGBA8";
                break;
            }
            case 36756: {
                string = "R8_SNORM";
                break;
            }
            case 36757: {
                string = "RG8_SNORM";
                break;
            }
            case 36758: {
                string = "RGB8_SNORM";
                break;
            }
            case 36759: {
                string = "RGBA8_SNORM";
                break;
            }
            case 33322: {
                string = "R16";
                break;
            }
            case 33324: {
                string = "RG16";
                break;
            }
            case 32852: {
                string = "RGB16";
                break;
            }
            case 32859: {
                string = "RGBA16";
                break;
            }
            case 33325: {
                string = "R16F";
                break;
            }
            case 33327: {
                string = "RG16F";
                break;
            }
            case 34843: {
                string = "RGB16F";
                break;
            }
            case 34842: {
                string = "RGBA16F";
                break;
            }
            case 33326: {
                string = "R32F";
                break;
            }
            case 33328: {
                string = "RG32F";
                break;
            }
            case 34837: {
                string = "RGB32F";
                break;
            }
            case 34836: {
                string = "RGBA32F";
                break;
            }
            case 35898: {
                string = "R11F_G11F_B10F";
                break;
            }
            case 32857: {
                string = "RGB10_A2";
                break;
            }
            default: {
                string = String.format("0x%X", format);
            }
        }
        return string;
    }

    public static void initDebugState() {
        debugState = GLStateManager.capabilities.GL_KHR_debug || GLStateManager.capabilities.OpenGL43 ? new KHRDebugState() : new UnsupportedDebugState();
    }

    public static void nameObject(int id, int object, String name) {
        if (debugState != null && Thread.currentThread() == GLStateManager.getMainThread()) {
            debugState.nameObject(id, object, name);
        }
    }

    public static void pushGroup(String group) {
        if (debugState != null && Thread.currentThread() == GLStateManager.getMainThread()) {
            debugState.pushGroup(group);
        }
    }

    public static void popGroup() {
        if (debugState != null && Thread.currentThread() == GLStateManager.getMainThread()) {
            debugState.popGroup();
        }
    }

    public static void debugMessage(String message) {
        if (debugState != null && Thread.currentThread() == GLStateManager.getMainThread()) {
            debugState.debugMessage(message);
        }
    }

    public static String getObjectLabel(int glProgram, int program) {
        if (debugState != null && Thread.currentThread() == GLStateManager.getMainThread()) {
            return debugState.getObjectLabel(glProgram, program);
        }
        return "";
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=GLDebug.class)
    private static class KHRDebugState
    implements DebugState {
        private static final int ID = 0;
        private int depth = 0;
        private static final int maxDepth = GL11.glGetInteger((int)33388);
        private static final int maxNameLength = GL11.glGetInteger((int)33512);

        KHRDebugState() {
        }

        @Override
        public void nameObject(int id, int object, String name) {
            KHRDebug.glObjectLabel((int)id, (int)object, (CharSequence)name);
        }

        @Override
        public void pushGroup(String name) {
            ++this.depth;
            if (this.depth > maxDepth) {
                throw new RuntimeException("Stack overflow");
            }
            KHRDebug.glPushDebugGroup((int)33354, (int)0, (CharSequence)name);
        }

        @Override
        public void popGroup() {
            --this.depth;
            if (this.depth < 0) {
                throw new RuntimeException("Stack underflow");
            }
            KHRDebug.glPopDebugGroup();
        }

        @Override
        public void debugMessage(String message) {
            KHRDebug.glDebugMessageInsert((int)33354, (int)33384, (int)0, (int)33387, (CharSequence)message);
        }

        @Override
        public String getObjectLabel(int glProgram, int program) {
            if (program == 0) {
                return "";
            }
            return KHRDebug.glGetObjectLabel((int)glProgram, (int)program, (int)maxNameLength);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=GLDebug.class)
    private static interface DebugState {
        public void nameObject(int var1, int var2, String var3);

        public void pushGroup(String var1);

        public void popGroup();

        public void debugMessage(String var1);

        public String getObjectLabel(int var1, int var2);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=GLDebug.class)
    private static class UnsupportedDebugState
    implements DebugState {
        UnsupportedDebugState() {
        }

        @Override
        public void nameObject(int id, int object, String name) {
        }

        @Override
        public void pushGroup(String name) {
        }

        @Override
        public void popGroup() {
        }

        @Override
        public void debugMessage(String name) {
        }

        @Override
        public String getObjectLabel(int glProgram, int program) {
            return "";
        }
    }
}

