/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.glsm;

import com.google.common.collect.ImmutableSet;
import com.gtnewhorizon.gtnhlib.client.renderer.stacks.IStateStack;
import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.glsm.stacks.BooleanStateStack;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Feature {
    private static final int[] supportedAttribs;
    static final Int2ObjectMap<List<IStateStack<?>>> maskToFeaturesMap;
    static final Int2ObjectMap<IStateStack<?>[]> maskToNonBooleanStacksMap;
    private static final Map<Integer, Set<IStateStack<?>>> attribToFeatures;

    static List<IStateStack<?>> maskToFeatures(int mask) {
        if (maskToFeaturesMap.containsKey(mask)) {
            return (List)maskToFeaturesMap.get(mask);
        }
        HashSet features = new HashSet();
        for (int attrib : supportedAttribs) {
            if ((mask & attrib) != attrib) continue;
            features.addAll(Feature.getFeatures(attrib));
        }
        ArrayList asList = new ArrayList(features);
        maskToFeaturesMap.put(mask, asList);
        return asList;
    }

    static IStateStack<?>[] maskToNonBooleanStacks(int mask) {
        IStateStack[] cached = (IStateStack[])maskToNonBooleanStacksMap.get(mask);
        if (cached != null) {
            return cached;
        }
        List<IStateStack<?>> all = Feature.maskToFeatures(mask);
        ArrayList nonBooleans = new ArrayList();
        for (int i = 0; i < all.size(); ++i) {
            IStateStack<?> stack = all.get(i);
            if (stack instanceof BooleanStateStack) continue;
            nonBooleans.add(stack);
        }
        cached = nonBooleans.toArray(new IStateStack[0]);
        maskToNonBooleanStacksMap.put(mask, (Object)cached);
        return cached;
    }

    private static void addTextureGenStates(Set<IStateStack<?>> collection) {
        for (int i = 0; i < GLStateManager.MAX_TEXTURE_UNITS; ++i) {
            collection.add(GLStateManager.textures.getTexGenSStates(i));
            collection.add(GLStateManager.textures.getTexGenTStates(i));
            collection.add(GLStateManager.textures.getTexGenRStates(i));
            collection.add(GLStateManager.textures.getTexGenQStates(i));
        }
    }

    public static Set<IStateStack<?>> getFeatures(int attrib) {
        return attribToFeatures.getOrDefault(attrib, Collections.emptySet());
    }

    static {
        int i;
        supportedAttribs = new int[]{512, 16384, 1, 256, 8192, 65536, 128, 32768, 64, 4, 131072, 0x20000000, 32, 2, 8, 16, 524288, 1024, 262144, 4096, 2048};
        maskToFeaturesMap = new Int2ObjectOpenHashMap();
        maskToNonBooleanStacksMap = new Int2ObjectOpenHashMap();
        attribToFeatures = new HashMap();
        attribToFeatures.put(16384, (Set<IStateStack<?>>)ImmutableSet.of((Object)GLStateManager.alphaTest, (Object)GLStateManager.alphaState, (Object)GLStateManager.blendMode, (Object)GLStateManager.blendState, (Object)GLStateManager.colorLogicOpState, (Object)GLStateManager.ditherState, (Object[])new IStateStack[]{GLStateManager.drawBuffer, GLStateManager.indexLogicOpState, GLStateManager.colorMask, GLStateManager.clearColor}));
        attribToFeatures.put(1, (Set<IStateStack<?>>)ImmutableSet.of((Object)GLStateManager.color));
        attribToFeatures.put(256, (Set<IStateStack<?>>)ImmutableSet.of((Object)GLStateManager.depthTest, (Object)GLStateManager.depthState));
        HashSet enableBits = new HashSet((Collection<IStateStack<?>>)ImmutableSet.of((Object)GLStateManager.alphaTest, (Object)GLStateManager.autoNormalState, (Object)GLStateManager.blendMode, (Object)GLStateManager.colorLogicOpState, (Object)GLStateManager.colorMaterial, (Object)GLStateManager.cullState, (Object[])new BooleanStateStack[]{GLStateManager.depthTest, GLStateManager.ditherState, GLStateManager.fogMode, GLStateManager.indexLogicOpState, GLStateManager.lightStates[0], GLStateManager.lightStates[1], GLStateManager.lightStates[2], GLStateManager.lightStates[3], GLStateManager.lightStates[4], GLStateManager.lightStates[5], GLStateManager.lightStates[6], GLStateManager.lightStates[7], GLStateManager.lightingState, GLStateManager.lineSmoothState, GLStateManager.lineStippleState, GLStateManager.map1Color4State, GLStateManager.map1IndexState, GLStateManager.map1NormalState, GLStateManager.map1TextureCoord1State, GLStateManager.map1TextureCoord2State, GLStateManager.map1TextureCoord3State, GLStateManager.map1TextureCoord4State, GLStateManager.map1Vertex3State, GLStateManager.map1Vertex4State, GLStateManager.map2Color4State, GLStateManager.map2IndexState, GLStateManager.map2NormalState, GLStateManager.map2TextureCoord1State, GLStateManager.map2TextureCoord2State, GLStateManager.map2TextureCoord3State, GLStateManager.map2TextureCoord4State, GLStateManager.map2Vertex3State, GLStateManager.map2Vertex4State, GLStateManager.multisampleState, GLStateManager.normalizeState, GLStateManager.pointSmoothState, GLStateManager.polygonOffsetPointState, GLStateManager.polygonOffsetLineState, GLStateManager.polygonOffsetFillState, GLStateManager.polygonSmoothState, GLStateManager.polygonStippleState, GLStateManager.rescaleNormalState, GLStateManager.sampleAlphaToCoverageState, GLStateManager.sampleAlphaToOneState, GLStateManager.sampleCoverageState, GLStateManager.scissorTest, GLStateManager.stencilTest}));
        for (i = 0; i < GLStateManager.clipPlaneStates.length; ++i) {
            enableBits.add(GLStateManager.clipPlaneStates[i]);
        }
        for (i = 0; i < GLStateManager.MAX_TEXTURE_UNITS; ++i) {
            enableBits.add(GLStateManager.textures.getTexture1DStates(i));
            enableBits.add(GLStateManager.textures.getTextureUnitStates(i));
            enableBits.add(GLStateManager.textures.getTexture3DStates(i));
        }
        Feature.addTextureGenStates(enableBits);
        attribToFeatures.put(8192, enableBits);
        attribToFeatures.put(65536, (Set<IStateStack<?>>)ImmutableSet.of());
        attribToFeatures.put(128, (Set<IStateStack<?>>)ImmutableSet.of((Object)GLStateManager.fogMode, (Object)GLStateManager.fogState));
        attribToFeatures.put(32768, (Set<IStateStack<?>>)ImmutableSet.of());
        attribToFeatures.put(64, (Set<IStateStack<?>>)ImmutableSet.of((Object)GLStateManager.colorMaterial, (Object)GLStateManager.colorMaterialFace, (Object)GLStateManager.colorMaterialParameter, (Object)GLStateManager.lightModel, (Object)GLStateManager.lightingState, (Object)GLStateManager.lightStates[0], (Object[])new IStateStack[]{GLStateManager.lightStates[1], GLStateManager.lightStates[2], GLStateManager.lightStates[3], GLStateManager.lightStates[4], GLStateManager.lightStates[5], GLStateManager.lightStates[6], GLStateManager.lightStates[7], GLStateManager.lightDataStates[0], GLStateManager.lightDataStates[1], GLStateManager.lightDataStates[2], GLStateManager.lightDataStates[3], GLStateManager.lightDataStates[4], GLStateManager.lightDataStates[5], GLStateManager.lightDataStates[6], GLStateManager.lightDataStates[7], GLStateManager.frontMaterial, GLStateManager.backMaterial, GLStateManager.shadeModelState}));
        attribToFeatures.put(4, (Set<IStateStack<?>>)ImmutableSet.of((Object)GLStateManager.lineSmoothState, (Object)GLStateManager.lineStippleState, (Object)GLStateManager.lineState));
        attribToFeatures.put(131072, (Set<IStateStack<?>>)ImmutableSet.of());
        attribToFeatures.put(0x20000000, (Set<IStateStack<?>>)ImmutableSet.of());
        attribToFeatures.put(32, (Set<IStateStack<?>>)ImmutableSet.of());
        attribToFeatures.put(2, (Set<IStateStack<?>>)ImmutableSet.of((Object)GLStateManager.pointSmoothState, (Object)GLStateManager.pointState));
        attribToFeatures.put(8, (Set<IStateStack<?>>)ImmutableSet.of((Object)GLStateManager.cullState, (Object)GLStateManager.polygonSmoothState, (Object)GLStateManager.polygonStippleState, (Object)GLStateManager.polygonOffsetFillState, (Object)GLStateManager.polygonOffsetLineState, (Object)GLStateManager.polygonOffsetPointState, (Object[])new IStateStack[]{GLStateManager.polygonState}));
        attribToFeatures.put(16, (Set<IStateStack<?>>)ImmutableSet.of());
        attribToFeatures.put(524288, (Set<IStateStack<?>>)ImmutableSet.of((Object)GLStateManager.scissorTest));
        attribToFeatures.put(1024, (Set<IStateStack<?>>)ImmutableSet.of((Object)GLStateManager.stencilTest, (Object)GLStateManager.stencilState));
        HashSet textureAttribs = new HashSet((Collection<IStateStack<?>>)ImmutableSet.of((Object)GLStateManager.activeTextureUnit));
        for (int i2 = 0; i2 < GLStateManager.MAX_TEXTURE_UNITS; ++i2) {
            textureAttribs.add(GLStateManager.textures.getTextureUnitBindings(i2));
        }
        Feature.addTextureGenStates(textureAttribs);
        attribToFeatures.put(262144, textureAttribs);
        attribToFeatures.put(4096, (Set<IStateStack<?>>)ImmutableSet.of((Object)GLStateManager.matrixMode, (Object)GLStateManager.normalizeState, (Object)GLStateManager.rescaleNormalState));
        attribToFeatures.put(2048, (Set<IStateStack<?>>)ImmutableSet.of((Object)GLStateManager.viewportState));
    }
}

