/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.glsm;

import com.gtnewhorizons.angelica.glsm.recording.AccumulatedDraw;
import com.gtnewhorizons.angelica.glsm.recording.CommandBuffer;
import com.gtnewhorizons.angelica.glsm.recording.CommandBufferProcessor;
import java.util.List;

public final class CommandBufferBuilder {
    private CommandBufferBuilder() {
    }

    public static void buildFromRawBuffer(CommandBuffer rawBuffer, List<AccumulatedDraw> accumulatedDraws, CommandBuffer finalBuffer) {
        rawBuffer.resetRead();
        int cmdIndex = 0;
        int rangeIndex = 0;
        while (rawBuffer.hasRemaining()) {
            CommandBufferProcessor.copyCommand(rawBuffer, finalBuffer);
            while (rangeIndex < accumulatedDraws.size()) {
                AccumulatedDraw draw = accumulatedDraws.get(rangeIndex);
                if (draw.commandIndex != cmdIndex) break;
                CommandBufferBuilder.emitDrawRangeToBuffer(draw, finalBuffer, rangeIndex);
                ++rangeIndex;
            }
            ++cmdIndex;
        }
        while (rangeIndex < accumulatedDraws.size()) {
            CommandBufferBuilder.emitDrawRangeToBuffer(accumulatedDraws.get(rangeIndex), finalBuffer, rangeIndex);
            ++rangeIndex;
        }
    }

    private static void emitDrawRangeToBuffer(AccumulatedDraw draw, CommandBuffer out, int vboIdx) {
        if (draw.restoreData != null) {
            out.writeDrawRangeRestore(vboIdx, draw.restoreData);
            return;
        }
        out.writeDrawRange(vboIdx);
    }
}

