/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.glsm;

import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.mitchej123.glsm.RenderSystemService;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL20;
import xyz.wagyourtail.jvmdg.j9.stub.java_base.J_N_Buffer;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class AngelicaRenderSystemService
implements RenderSystemService {
    private final int[] shaderTextures = new int[16];
    private final float[] shaderColor = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    private final float[] shaderFogColor = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    private float shaderFogStart = 0.0f;
    private float shaderFogEnd = 0.0f;
    private int fogShape = 0;
    private float shaderLineWidth = 1.0f;
    private final Matrix4f projectionMatrix = new Matrix4f();
    private final FloatBuffer projectionMatrixBuffer = BufferUtils.createFloatBuffer((int)16);

    @Override
    public int getPriority() {
        return 100;
    }

    @Override
    public void glActiveTexture(int texture) {
        GLStateManager.glActiveTexture(texture);
    }

    @Override
    public void bindTexture(int texture) {
        GLStateManager.glBindTexture(3553, texture);
    }

    @Override
    public void enableCullFace() {
        GLStateManager.enableCull();
    }

    @Override
    public void disableCullFace() {
        GLStateManager.disableCull();
    }

    @Override
    public void enableBlend() {
        GLStateManager.enableBlend();
    }

    @Override
    public void disableBlend() {
        GLStateManager.disableBlend();
    }

    @Override
    public void defaultBlendFunc() {
        GLStateManager.defaultBlendFunc();
    }

    @Override
    public void blendFuncSeparate(int srcRGB, int dstRGB, int srcAlpha, int dstAlpha) {
        GLStateManager.tryBlendFuncSeparate(srcRGB, dstRGB, srcAlpha, dstAlpha);
    }

    @Override
    public void setUnknownBlendState() {
    }

    @Override
    public void enableDepthTest() {
        GLStateManager.enableDepthTest();
    }

    @Override
    public void disableDepthTest() {
        GLStateManager.disableDepthTest();
    }

    @Override
    public void depthFunc(int depthFunc) {
        GLStateManager.glDepthFunc(depthFunc);
    }

    @Override
    public void depthMask(boolean flag) {
        GLStateManager.glDepthMask(flag);
    }

    @Override
    public void glViewport(int x, int y, int width, int height) {
        GLStateManager.glViewport(x, y, width, height);
    }

    @Override
    public void glClearColor(float red, float green, float blue, float alpha) {
        GLStateManager.glClearColor(red, green, blue, alpha);
    }

    @Override
    public void clear(int mask, boolean checkError) {
        GLStateManager.glClear(mask);
    }

    @Override
    public void glUniform1i(int location, int value) {
        GL20.glUniform1i((int)location, (int)value);
    }

    @Override
    public void glUniformMatrix3(int location, boolean transpose, FloatBuffer value) {
        GL20.glUniformMatrix3((int)location, (boolean)transpose, (FloatBuffer)value);
    }

    @Override
    public void glUniformMatrix4(int location, boolean transpose, FloatBuffer value) {
        GL20.glUniformMatrix4((int)location, (boolean)transpose, (FloatBuffer)value);
    }

    @Override
    public void assertOnRenderThread() {
    }

    @Override
    public void assertOnRenderThreadOrInit() {
    }

    @Override
    public void setShaderTexture(int shaderTexture, int textureId) {
        if (shaderTexture >= 0 && shaderTexture < 16) {
            this.shaderTextures[shaderTexture] = textureId;
        }
    }

    @Override
    public int getShaderTexture(int shaderTexture) {
        return shaderTexture >= 0 && shaderTexture < 16 ? this.shaderTextures[shaderTexture] : 0;
    }

    @Override
    public void setShaderColor(float red, float green, float blue, float alpha) {
        this.shaderColor[0] = red;
        this.shaderColor[1] = green;
        this.shaderColor[2] = blue;
        this.shaderColor[3] = alpha;
    }

    @Override
    public float[] getShaderColor() {
        return (float[])this.shaderColor.clone();
    }

    @Override
    public void setShaderLineWidth(float lineWidth) {
        this.shaderLineWidth = lineWidth;
    }

    @Override
    public float getShaderLineWidth() {
        return this.shaderLineWidth;
    }

    @Override
    public void setShaderFogColor(float red, float green, float blue, float alpha) {
        this.shaderFogColor[0] = red;
        this.shaderFogColor[1] = green;
        this.shaderFogColor[2] = blue;
        this.shaderFogColor[3] = alpha;
    }

    @Override
    public float[] getShaderFogColor() {
        return (float[])this.shaderFogColor.clone();
    }

    @Override
    public void setShaderFogStart(float start) {
        this.shaderFogStart = start;
    }

    @Override
    public float getShaderFogStart() {
        return this.shaderFogStart;
    }

    @Override
    public void setShaderFogEnd(float end) {
        this.shaderFogEnd = end;
    }

    @Override
    public float getShaderFogEnd() {
        return this.shaderFogEnd;
    }

    @Override
    public void setFogShape(int shape) {
        this.fogShape = shape;
    }

    @Override
    public int getFogShape() {
        return this.fogShape;
    }

    @Override
    public Matrix4f getProjectionMatrix() {
        return new Matrix4f((Matrix4fc)this.projectionMatrix);
    }

    @Override
    public void setProjectionMatrixOrth(Matrix4f m) {
        this.projectionMatrix.set((Matrix4fc)m);
        GLStateManager.glMatrixMode(5889);
        this.projectionMatrix.get(this.projectionMatrixBuffer);
        FloatBuffer cfr_ignored_0 = (FloatBuffer)J_N_Buffer.rewind((Buffer)this.projectionMatrixBuffer);
        GLStateManager.glLoadMatrix(this.projectionMatrixBuffer);
    }

    @Override
    public void setProjectionMatrixOrigin(Matrix4f m) {
        this.setProjectionMatrixOrth(m);
    }
}

