/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.dynamiclights.config;

import com.gtnewhorizon.gtnhlib.concurrent.cas.CasMap;
import com.gtnewhorizons.angelica.dynamiclights.IDynamicLightSource;
import com.gtnewhorizons.angelica.dynamiclights.config.EntityTypeEntry;
import cpw.mods.fml.common.registry.EntityRegistry;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public final class EntityLightConfig {
    private static final Logger LOGGER = LogManager.getLogger((String)"Angelica/DynamicLights");
    private static final Set<String> disabledClassNames = ConcurrentHashMap.newKeySet();
    private static final CasMap<Class<?>, Boolean> enabledCache = new CasMap();
    private static File configFile;
    private static boolean initialized;

    private EntityLightConfig() {
    }

    public static void init(@NotNull File configDir) {
        if (initialized) {
            return;
        }
        configFile = new File(configDir, "angelica-dynamiclights-entities.txt");
        EntityLightConfig.load();
        initialized = true;
    }

    public static boolean isEntityTypeEnabled(@NotNull IDynamicLightSource source) {
        if (!initialized) {
            return true;
        }
        return EntityLightConfig.isEntityTypeEnabled(source.getClass());
    }

    public static boolean isEntityTypeEnabled(@NotNull Class<?> entityClass) {
        if (!initialized) {
            return true;
        }
        Boolean cached = (Boolean)enabledCache.get(entityClass);
        if (cached != null) {
            return cached;
        }
        boolean enabled = !disabledClassNames.contains(entityClass.getName());
        Boolean existing = (Boolean)enabledCache.putIfAbsent(entityClass, (Object)enabled);
        return existing != null ? existing : enabled;
    }

    public static void setEntityTypeEnabled(@NotNull Class<?> entityClass, boolean enabled) {
        enabledCache.put(entityClass, (Object)enabled);
        String className = entityClass.getName();
        if (enabled) {
            disabledClassNames.remove(className);
        } else {
            disabledClassNames.add(className);
        }
    }

    public static List<EntityTypeEntry> getAllEntityTypes() {
        ArrayList<EntityTypeEntry> entries = new ArrayList<EntityTypeEntry>();
        HashSet<String> seenClasses = new HashSet<String>();
        Map stringToClass = EntityList.field_75625_b;
        for (Map.Entry entry : stringToClass.entrySet()) {
            String entityId = (String)entry.getKey();
            Class entityClass = (Class)entry.getValue();
            String className = entityClass.getName();
            if (seenClasses.contains(className)) continue;
            seenClasses.add(className);
            String modId = EntityLightConfig.getModIdForEntity(entityClass, entityId);
            String displayName = EntityLightConfig.getDisplayName(entityId, entityClass);
            boolean enabled = !disabledClassNames.contains(className);
            entries.add(new EntityTypeEntry(displayName, className, modId, enabled));
        }
        entries.sort((a, b) -> {
            int modCompare = a.getModId().compareToIgnoreCase(b.getModId());
            if (modCompare != 0) {
                return modCompare;
            }
            return a.getDisplayName().compareToIgnoreCase(b.getDisplayName());
        });
        return entries;
    }

    private static String getModIdForEntity(Class<?> entityClass, String entityId) {
        EntityRegistry.EntityRegistration registration;
        if (Entity.class.isAssignableFrom(entityClass) && (registration = EntityRegistry.instance().lookupModSpawn(entityClass, false)) != null && registration.getContainer() != null) {
            return registration.getContainer().getModId();
        }
        if (!entityId.contains(".")) {
            return "minecraft";
        }
        int dotIndex = entityId.indexOf(46);
        if (dotIndex > 0) {
            return entityId.substring(0, dotIndex);
        }
        return "unknown";
    }

    private static String getDisplayName(String entityId, Class<?> entityClass) {
        String simpleName = entityClass.getSimpleName();
        if (simpleName.isEmpty()) {
            return entityId;
        }
        return simpleName;
    }

    public static void load() {
        if (configFile == null || !configFile.exists()) {
            return;
        }
        disabledClassNames.clear();
        enabledCache.clear();
        try (BufferedReader reader = new BufferedReader(new FileReader(configFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                disabledClassNames.add(line);
            }
            LOGGER.info("Loaded {} disabled entity types from config", new Object[]{disabledClassNames.size()});
        }
        catch (IOException e) {
            LOGGER.warn("Failed to load entity light config: {}", new Object[]{e.getMessage()});
        }
    }

    public static void save() {
        if (configFile == null) {
            return;
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(configFile));){
            writer.write("# Angelica Dynamic Lights - Disabled Entity Types");
            writer.newLine();
            writer.write("# Each line is a fully qualified class name of an entity type that is DISABLED.");
            writer.newLine();
            writer.write("# Remove a line to re-enable dynamic lighting for that entity type.");
            writer.newLine();
            writer.newLine();
            ArrayList<String> sorted = new ArrayList<String>(disabledClassNames);
            Collections.sort(sorted);
            for (String className : sorted) {
                writer.write(className);
                writer.newLine();
            }
            LOGGER.info("Saved {} disabled entity types to config", new Object[]{disabledClassNames.size()});
        }
        catch (IOException e) {
            LOGGER.warn("Failed to save entity light config: {}", new Object[]{e.getMessage()});
        }
    }

    static {
        initialized = false;
    }
}

