/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.dynamiclights;

import baubles.common.container.InventoryBaubles;
import baubles.common.lib.PlayerHandler;
import com.gtnewhorizon.gtnhlib.blockpos.BlockPos;
import com.gtnewhorizon.gtnhlib.blockpos.IBlockPos;
import com.gtnewhorizon.gtnhlib.util.CoordinatePacker;
import com.gtnewhorizons.angelica.api.IDynamicLightProducer;
import com.gtnewhorizons.angelica.compat.ModStatus;
import com.gtnewhorizons.angelica.compat.backhand.BackhandReflectionCompat;
import com.gtnewhorizons.angelica.compat.battlegear2.Battlegear2Compat;
import com.gtnewhorizons.angelica.config.AngelicaConfig;
import com.gtnewhorizons.angelica.dynamiclights.AdaptiveTickCalculator;
import com.gtnewhorizons.angelica.dynamiclights.AdaptiveTickMode;
import com.gtnewhorizons.angelica.dynamiclights.ChunkRebuildManager;
import com.gtnewhorizons.angelica.dynamiclights.DynamicLightsMode;
import com.gtnewhorizons.angelica.dynamiclights.IDynamicLightSource;
import com.gtnewhorizons.angelica.dynamiclights.IDynamicLightWorldRenderer;
import com.gtnewhorizons.angelica.dynamiclights.config.EntityLightConfig;
import com.gtnewhorizons.angelica.mixins.interfaces.PrimedEntityAccessor;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import mods.battlegear2.api.core.IBattlePlayer;
import net.irisshaders.iris.api.v0.IrisApi;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import org.embeddedt.embeddium.impl.render.viewport.Viewport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamicLights {
    private static DynamicLights instance;
    private static IDynamicLightWorldRenderer activeRenderer;
    public static DynamicLightsMode Mode;
    public static boolean ShaderForce;
    public static boolean FrustumCullingEnabled;
    public static boolean AdaptiveTickingEnabled;
    public static final boolean configEnabled;
    private static final double MAX_RADIUS = 7.75;
    private static final double MAX_RADIUS_SQUARED = 60.0625;
    private final Set<IDynamicLightSource> dynamicLightSources = new ObjectOpenHashSet();
    private final ReentrantReadWriteLock lightSourcesLock = new ReentrantReadWriteLock();
    private volatile int lightSourceCount = 0;
    private final ChunkRebuildManager chunkRebuildManager = new ChunkRebuildManager();
    private long lastUpdate = System.currentTimeMillis();
    private int lastUpdateCount = 0;

    public static DynamicLights get() {
        if (instance == null) {
            instance = new DynamicLights();
        }
        return instance;
    }

    public static boolean isEnabled() {
        return configEnabled && Mode.isEnabled() && (ShaderForce || !IrisApi.getInstance().isShaderPackInUse());
    }

    public boolean hasLightSources() {
        return this.lightSourceCount > 0;
    }

    public static IDynamicLightWorldRenderer getActiveRenderer() {
        return activeRenderer;
    }

    public static void setActiveRenderer(IDynamicLightWorldRenderer renderer) {
        activeRenderer = renderer;
    }

    public void updateAll(@NotNull IDynamicLightWorldRenderer renderer) {
        if (!DynamicLights.isEnabled()) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now >= this.lastUpdate + (long)Mode.getDelay()) {
            this.lastUpdate = now;
            this.lastUpdateCount = 0;
            double cameraX = 0.0;
            double cameraY = 0.0;
            double cameraZ = 0.0;
            double lookDirX = 0.0;
            double lookDirZ = 1.0;
            int worldTick = 0;
            if (AdaptiveTickingEnabled) {
                Minecraft mc = Minecraft.func_71410_x();
                if (mc.field_71441_e != null && mc.field_71451_h != null) {
                    cameraX = mc.field_71451_h.field_70165_t;
                    cameraY = mc.field_71451_h.field_70163_u + (double)mc.field_71451_h.func_70047_e();
                    cameraZ = mc.field_71451_h.field_70161_v;
                    worldTick = (int)(mc.field_71441_e.func_82737_E() & Integer.MAX_VALUE);
                    float yaw = mc.field_71451_h.field_70177_z;
                    double yawRad = Math.toRadians(yaw);
                    lookDirX = -Math.sin(yawRad);
                    lookDirZ = Math.cos(yawRad);
                }
            }
            this.lightSourcesLock.readLock().lock();
            for (IDynamicLightSource lightSource : this.dynamicLightSources) {
                AdaptiveTickMode mode;
                if (!EntityLightConfig.isEntityTypeEnabled(lightSource) || AdaptiveTickingEnabled && !(mode = AdaptiveTickCalculator.calculate(lightSource, cameraX, cameraY, cameraZ, lookDirX, lookDirZ)).shouldTickThisFrame(worldTick, lightSource.hashCode()) || !lightSource.angelica$updateDynamicLight(renderer)) continue;
                ++this.lastUpdateCount;
            }
            this.lightSourcesLock.readLock().unlock();
        }
    }

    public int getLastUpdateCount() {
        return this.lastUpdateCount;
    }

    public void addLightSource(IDynamicLightSource lightSource) {
        this.lightSourcesLock.writeLock().lock();
        if (this.dynamicLightSources.add(lightSource)) {
            this.lightSourceCount = this.dynamicLightSources.size();
        }
        this.lightSourcesLock.writeLock().unlock();
    }

    public void removeLightSource(@NotNull IDynamicLightSource lightSource) {
        this.lightSourcesLock.writeLock().lock();
        Iterator<IDynamicLightSource> dynamicLightSources = this.dynamicLightSources.iterator();
        while (dynamicLightSources.hasNext()) {
            IDynamicLightSource it = dynamicLightSources.next();
            if (!it.equals(lightSource)) continue;
            dynamicLightSources.remove();
            this.lightSourceCount = this.dynamicLightSources.size();
            if (activeRenderer == null) break;
            lightSource.angelica$scheduleTrackedChunksRebuild(activeRenderer);
            break;
        }
        this.lightSourcesLock.writeLock().unlock();
    }

    public void removeLightSources(@NotNull Predicate<IDynamicLightSource> filter) {
        this.lightSourcesLock.writeLock().lock();
        Iterator<IDynamicLightSource> dynamicLightSources = this.dynamicLightSources.iterator();
        while (dynamicLightSources.hasNext()) {
            IDynamicLightSource it = dynamicLightSources.next();
            if (!filter.test(it)) continue;
            dynamicLightSources.remove();
            this.lightSourceCount = this.dynamicLightSources.size();
            if (activeRenderer == null) break;
            if (it.angelica$getLuminance() > 0) {
                it.angelica$resetDynamicLight();
            }
            it.angelica$scheduleTrackedChunksRebuild(activeRenderer);
            break;
        }
        this.lightSourcesLock.writeLock().unlock();
    }

    public void clearLightSources() {
        this.lightSourcesLock.writeLock().lock();
        Iterator<IDynamicLightSource> dynamicLightSources = this.dynamicLightSources.iterator();
        while (dynamicLightSources.hasNext()) {
            IDynamicLightSource it = dynamicLightSources.next();
            dynamicLightSources.remove();
            if (activeRenderer == null) continue;
            if (it.angelica$getLuminance() > 0) {
                it.angelica$resetDynamicLight();
            }
            it.angelica$scheduleTrackedChunksRebuild(activeRenderer);
        }
        this.lightSourceCount = 0;
        this.lightSourcesLock.writeLock().unlock();
    }

    public boolean containsLightSource(@NotNull IDynamicLightSource lightSource) {
        this.lightSourcesLock.readLock().lock();
        boolean result = this.dynamicLightSources.contains(lightSource);
        this.lightSourcesLock.readLock().unlock();
        return result;
    }

    public int getLightSourcesCount() {
        this.lightSourcesLock.readLock().lock();
        int result = this.dynamicLightSources.size();
        this.lightSourcesLock.readLock().unlock();
        return result;
    }

    public double getDynamicLightLevel(int x, int y, int z) {
        double result = 0.0;
        this.lightSourcesLock.readLock().lock();
        for (IDynamicLightSource lightSource : this.dynamicLightSources) {
            result = DynamicLights.maxDynamicLightLevel(x, y, z, lightSource, result);
        }
        this.lightSourcesLock.readLock().unlock();
        return MathHelper.func_151237_a((double)result, (double)0.0, (double)15.0);
    }

    public double getDynamicLightLevel(double x, double y, double z) {
        double result = 0.0;
        this.lightSourcesLock.readLock().lock();
        for (IDynamicLightSource lightSource : this.dynamicLightSources) {
            result = DynamicLights.maxDynamicLightLevelExact(x, y, z, lightSource, result);
        }
        this.lightSourcesLock.readLock().unlock();
        return MathHelper.func_151237_a((double)result, (double)0.0, (double)15.0);
    }

    public double getDynamicLightLevel(@NotNull BlockPos pos) {
        return this.getDynamicLightLevel(pos.getX(), pos.getY(), pos.getZ());
    }

    public static double maxDynamicLightLevel(int x, int y, int z, @NotNull IDynamicLightSource lightSource, double currentLightLevel) {
        double multiplier;
        double lightLevel;
        double dz;
        double dy;
        double dx;
        double distanceSquared;
        int luminance = lightSource.angelica$getLuminance();
        if (luminance > 0 && (distanceSquared = (dx = (double)x - lightSource.angelica$getDynamicLightX() + 0.5) * dx + (dy = (double)y - lightSource.angelica$getDynamicLightY() + 0.5) * dy + (dz = (double)z - lightSource.angelica$getDynamicLightZ() + 0.5) * dz) <= 60.0625 && (lightLevel = (multiplier = 1.0 - Math.sqrt(distanceSquared) / 7.75) * (double)luminance) > currentLightLevel) {
            return lightLevel;
        }
        return currentLightLevel;
    }

    public static double maxDynamicLightLevelExact(double x, double y, double z, @NotNull IDynamicLightSource lightSource, double currentLightLevel) {
        double multiplier;
        double lightLevel;
        double dz;
        double dy;
        double dx;
        double distanceSquared;
        int luminance = lightSource.angelica$getLuminance();
        if (luminance > 0 && (distanceSquared = (dx = x - lightSource.angelica$getDynamicLightX()) * dx + (dy = y - lightSource.angelica$getDynamicLightY()) * dy + (dz = z - lightSource.angelica$getDynamicLightZ()) * dz) <= 60.0625 && (lightLevel = (multiplier = 1.0 - Math.sqrt(distanceSquared) / 7.75) * (double)luminance) > currentLightLevel) {
            return lightLevel;
        }
        return currentLightLevel;
    }

    public static double maxDynamicLightLevel(@NotNull BlockPos pos, @NotNull IDynamicLightSource lightSource, double currentLightLevel) {
        return DynamicLights.maxDynamicLightLevel(pos.getX(), pos.getY(), pos.getZ(), lightSource, currentLightLevel);
    }

    public int getLightmapWithDynamicLight(int x, int y, int z, int lightmap) {
        return this.getLightmapWithDynamicLight(this.getDynamicLightLevel(x, y, z), lightmap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IDynamicLightSource> getSourcesForChunk(int chunkMinX, int chunkMinY, int chunkMinZ) {
        double centerX = (double)chunkMinX + 8.0;
        double centerY = (double)chunkMinY + 8.0;
        double centerZ = (double)chunkMinZ + 8.0;
        double searchRadiusSq = 470.0;
        List<IDynamicLightSource> result = null;
        this.lightSourcesLock.readLock().lock();
        try {
            for (IDynamicLightSource source : this.dynamicLightSources) {
                double dz;
                double dy;
                double dx = source.angelica$getDynamicLightX() - centerX;
                double distSq = dx * dx + (dy = source.angelica$getDynamicLightY() - centerY) * dy + (dz = source.angelica$getDynamicLightZ() - centerZ) * dz;
                if (!(distSq <= 470.0)) continue;
                if (result == null) {
                    result = new ArrayList<IDynamicLightSource>();
                }
                result.add(source);
            }
        }
        finally {
            this.lightSourcesLock.readLock().unlock();
        }
        return result != null ? result : Collections.emptyList();
    }

    public double getDynamicLightLevelFromSources(double x, double y, double z, List<IDynamicLightSource> sources) {
        if (sources == null || sources.isEmpty()) {
            return 0.0;
        }
        double result = 0.0;
        int size = sources.size();
        for (int i = 0; i < size; ++i) {
            result = DynamicLights.maxDynamicLightLevelExact(x, y, z, sources.get(i), result);
        }
        return MathHelper.func_151237_a((double)result, (double)0.0, (double)15.0);
    }

    public int getLightmapWithDynamicLight(double dynamicLightLevel, int lightmap) {
        int blockLevel;
        if (dynamicLightLevel > 0.0 && dynamicLightLevel > (double)(blockLevel = (lightmap & 0xFFFF) >> 4)) {
            int luminance = (int)(dynamicLightLevel * 16.0);
            lightmap &= 0xFFF00000;
            lightmap |= luminance & 0xFFFFF;
        }
        return lightmap;
    }

    public static void scheduleChunkRebuild(@NotNull IDynamicLightWorldRenderer renderer, @NotNull IBlockPos chunkPos) {
        DynamicLights.scheduleChunkRebuild(renderer, chunkPos.getX(), chunkPos.getY(), chunkPos.getZ());
    }

    public static void scheduleChunkRebuild(@NotNull IDynamicLightWorldRenderer renderer, long chunkPos) {
        DynamicLights.scheduleChunkRebuild(renderer, CoordinatePacker.unpackX((long)chunkPos), CoordinatePacker.unpackY((long)chunkPos), CoordinatePacker.unpackZ((long)chunkPos));
    }

    public static void scheduleChunkRebuild(@NotNull IDynamicLightWorldRenderer renderer, int x, int y, int z) {
        if (FrustumCullingEnabled && instance != null) {
            DynamicLights.instance.chunkRebuildManager.requestRebuild(x, y, z);
        } else {
            renderer.scheduleRebuildForChunk(x, y, z, false);
        }
    }

    public static void scheduleChunkRebuildForRemoval(@NotNull IDynamicLightWorldRenderer renderer, int x, int y, int z) {
        renderer.scheduleRebuildForChunk(x, y, z, false);
    }

    public static void scheduleChunkRebuildForRemoval(@NotNull IDynamicLightWorldRenderer renderer, long chunkPos) {
        DynamicLights.scheduleChunkRebuildForRemoval(renderer, CoordinatePacker.unpackX((long)chunkPos), CoordinatePacker.unpackY((long)chunkPos), CoordinatePacker.unpackZ((long)chunkPos));
    }

    public void processChunkRebuilds(@Nullable Viewport viewport) {
        if (activeRenderer == null) {
            return;
        }
        this.chunkRebuildManager.processVisible(viewport, activeRenderer);
    }

    public ChunkRebuildManager getChunkRebuildManager() {
        return this.chunkRebuildManager;
    }

    public static void updateTrackedChunks(@NotNull IBlockPos chunkPos, @Nullable LongOpenHashSet old, @Nullable LongOpenHashSet newPos) {
        if (old != null || newPos != null) {
            long pos = chunkPos.asLong();
            if (old != null) {
                old.remove(pos);
            }
            if (newPos != null) {
                newPos.add(pos);
            }
        }
    }

    public static void updateTracking(@NotNull IDynamicLightSource lightSource) {
        boolean enabled = lightSource.angelica$isDynamicLightEnabled();
        int luminance = lightSource.angelica$getLuminance();
        if (!enabled && luminance > 0) {
            lightSource.angelica$setDynamicLightEnabled(true);
        } else if (enabled && luminance < 1) {
            lightSource.angelica$setDynamicLightEnabled(false);
        }
    }

    public static int getLuminanceFromItemStack(@NotNull ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock) {
            ItemBlock itemBlock = (ItemBlock)item;
            Block block = itemBlock.field_150939_a;
            if (block != null) {
                return block.func_149750_m();
            }
        } else if (item instanceof IDynamicLightProducer) {
            IDynamicLightProducer lightProducer = (IDynamicLightProducer)item;
            return lightProducer.getLuminance();
        }
        if (item == Items.field_151129_at) {
            return Blocks.field_150353_l.func_149750_m();
        }
        return 0;
    }

    public static int getLuminanceFromEntity(@NotNull Entity entity) {
        if (entity.func_70027_ad()) {
            return 15;
        }
        boolean inWater = entity.func_70055_a(Material.field_151586_h);
        if (inWater) {
            return 0;
        }
        if (entity instanceof EntityItem) {
            EntityItem item = (EntityItem)entity;
            return DynamicLights.getLuminanceFromItemStack(item.func_92059_d());
        }
        int luminance = 0;
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)entity;
            for (int i = 0; i < 5; ++i) {
                ItemStack itemStack = living.func_71124_b(i);
                if (itemStack == null) continue;
                luminance = Math.max(luminance, DynamicLights.getLuminanceFromItemStack(itemStack));
            }
            if (living instanceof EntityPlayer) {
                InventoryBaubles playerBaubles;
                ItemStack offhand;
                IBattlePlayer battlePlayer;
                EntityPlayer player = (EntityPlayer)living;
                if (ModStatus.isBattlegearLoaded && player instanceof IBattlePlayer && (battlePlayer = (IBattlePlayer)player).battlegear2$isBattlemode()) {
                    offhand = Battlegear2Compat.getBattlegear2Offhand(player);
                    if (offhand != null) {
                        luminance = Math.max(luminance, DynamicLights.getLuminanceFromItemStack(offhand));
                    }
                } else if (ModStatus.isBackhandLoaded) {
                    offhand = BackhandReflectionCompat.getOffhandItem(player);
                    if (offhand != null) {
                        luminance = Math.max(luminance, DynamicLights.getLuminanceFromItemStack(offhand));
                    }
                }
                if (ModStatus.isBaublesLoaded && (playerBaubles = PlayerHandler.getPlayerBaubles((EntityPlayer)player)) != null) {
                    for (int i = 0; i < playerBaubles.func_70302_i_(); ++i) {
                        ItemStack stack = playerBaubles.func_70301_a(i);
                        if (stack == null) continue;
                        luminance = Math.max(luminance, DynamicLights.getLuminanceFromItemStack(stack));
                    }
                }
            }
            return luminance;
        }
        if (entity instanceof PrimedEntityAccessor) {
            PrimedEntityAccessor primedEntity = (PrimedEntityAccessor)entity;
            luminance = Math.max(luminance, primedEntity.angelica$getLuminance());
        }
        return luminance;
    }

    static {
        Mode = DynamicLightsMode.OFF;
        ShaderForce = false;
        FrustumCullingEnabled = true;
        AdaptiveTickingEnabled = true;
        configEnabled = AngelicaConfig.enableDynamicLights;
    }
}

