/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.dynamiclights;

import com.gtnewhorizon.gtnhlib.util.CoordinatePacker;
import com.gtnewhorizons.angelica.dynamiclights.IDynamicLightWorldRenderer;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.embeddedt.embeddium.impl.render.viewport.Viewport;
import org.jetbrains.annotations.NotNull;

public class ChunkRebuildManager {
    private final Long2IntOpenHashMap pendingRebuilds = new Long2IntOpenHashMap();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private static int maxTicksWaiting = 100;
    private final LongArrayList candidates = new LongArrayList();
    private final LongArrayList toRebuild = new LongArrayList();
    private final LongArrayList toIncrement = new LongArrayList();

    public static void setMaxTicksWaiting(int ticks) {
        maxTicksWaiting = Math.max(20, Math.min(ticks, 600));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestRebuild(int x, int y, int z) {
        long packed = CoordinatePacker.pack((int)x, (int)y, (int)z);
        this.lock.writeLock().lock();
        try {
            this.pendingRebuilds.put(packed, 0);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processVisible(Viewport viewport, @NotNull IDynamicLightWorldRenderer renderer) {
        long packed;
        this.candidates.clear();
        this.toRebuild.clear();
        this.toIncrement.clear();
        this.lock.readLock().lock();
        try {
            if (this.pendingRebuilds.isEmpty()) {
                return;
            }
            ObjectIterator iterator = this.pendingRebuilds.long2IntEntrySet().fastIterator();
            while (iterator.hasNext()) {
                Long2IntMap.Entry entry = (Long2IntMap.Entry)iterator.next();
                packed = entry.getLongKey();
                int ticksWaiting = entry.getIntValue();
                if (viewport == null || ticksWaiting >= maxTicksWaiting) {
                    this.toRebuild.add(packed);
                    continue;
                }
                this.candidates.add(packed);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        for (int i = 0; i < this.candidates.size(); ++i) {
            int z;
            int y;
            long packed2 = this.candidates.getLong(i);
            int x = CoordinatePacker.unpackX((long)packed2);
            if (this.isChunkVisible(viewport, x, y = CoordinatePacker.unpackY((long)packed2), z = CoordinatePacker.unpackZ((long)packed2))) {
                this.toRebuild.add(packed2);
                continue;
            }
            this.toIncrement.add(packed2);
        }
        if (!this.toRebuild.isEmpty() || !this.toIncrement.isEmpty()) {
            this.lock.writeLock().lock();
            try {
                LongListIterator rebuildIter = this.toRebuild.iterator();
                while (rebuildIter.hasNext()) {
                    this.pendingRebuilds.remove(rebuildIter.nextLong());
                }
                LongListIterator incIter = this.toIncrement.iterator();
                while (incIter.hasNext()) {
                    packed = incIter.nextLong();
                    int current = this.pendingRebuilds.get(packed);
                    if (!this.pendingRebuilds.containsKey(packed)) continue;
                    this.pendingRebuilds.put(packed, current + 1);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        for (int i = 0; i < this.toRebuild.size(); ++i) {
            long packed3 = this.toRebuild.getLong(i);
            renderer.scheduleRebuildForChunk(CoordinatePacker.unpackX((long)packed3), CoordinatePacker.unpackY((long)packed3), CoordinatePacker.unpackZ((long)packed3), false);
        }
    }

    private boolean isChunkVisible(Viewport viewport, int chunkX, int chunkY, int chunkZ) {
        int blockX = chunkX << 4;
        int blockY = chunkY << 4;
        int blockZ = chunkZ << 4;
        return viewport.isBoxVisible(blockX, blockY, blockZ, blockX + 16, blockY + 16, blockZ + 16);
    }

    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.pendingRebuilds.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public int getPendingCount() {
        this.lock.readLock().lock();
        try {
            int n = this.pendingRebuilds.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

