/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.dynamiclights;

public enum AdaptiveTickMode {
    REAL_TIME(1),
    SLOW(5),
    SLOWER(10),
    BACKGROUND(20);

    private final int delay;

    private AdaptiveTickMode(int delay) {
        this.delay = delay;
    }

    public int getDelay() {
        return this.delay;
    }

    public boolean shouldTickThisFrame(int worldTick, int sourceHash) {
        if (this.delay <= 1) {
            return true;
        }
        return worldTick % this.delay == Math.abs(sourceHash % this.delay);
    }
}

