/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.dynamiclights;

import com.gtnewhorizons.angelica.dynamiclights.AdaptiveTickMode;
import com.gtnewhorizons.angelica.dynamiclights.IDynamicLightSource;
import org.jetbrains.annotations.NotNull;

public final class AdaptiveTickCalculator {
    private static int slowDistance = 32;
    private static int slowerDistance = 64;
    private static int backgroundDistance = 128;
    private static int slowDistanceSq = slowDistance * slowDistance;
    private static int slowerDistanceSq = slowerDistance * slowerDistance;
    private static int backgroundDistanceSq = backgroundDistance * backgroundDistance;

    private AdaptiveTickCalculator() {
    }

    public static AdaptiveTickMode calculate(@NotNull IDynamicLightSource source, double cameraX, double cameraY, double cameraZ, double lookDirX, double lookDirZ) {
        boolean behindCamera;
        double dx = source.angelica$getDynamicLightX() - cameraX;
        double dy = source.angelica$getDynamicLightY() - cameraY;
        double dz = source.angelica$getDynamicLightZ() - cameraZ;
        double distSq = dx * dx + dy * dy + dz * dz;
        double dot = dx * lookDirX + dz * lookDirZ;
        boolean bl = behindCamera = dot < 0.0;
        if (behindCamera) {
            return AdaptiveTickMode.BACKGROUND;
        }
        if (distSq > (double)backgroundDistanceSq) {
            return AdaptiveTickMode.BACKGROUND;
        }
        if (distSq > (double)slowerDistanceSq) {
            return AdaptiveTickMode.SLOWER;
        }
        if (distSq > (double)slowDistanceSq) {
            return AdaptiveTickMode.SLOW;
        }
        return AdaptiveTickMode.REAL_TIME;
    }

    public static void setSlowDistance(int distance) {
        slowDistance = distance;
        slowDistanceSq = distance * distance;
    }

    public static void setSlowerDistance(int distance) {
        slowerDistance = distance;
        slowerDistanceSq = distance * distance;
    }

    public static void setBackgroundDistance(int distance) {
        backgroundDistance = distance;
        backgroundDistanceSq = distance * distance;
    }
}

