/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.debug;

import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.rendering.celeritas.AngelicaRenderSectionManager;
import com.gtnewhorizons.angelica.rendering.celeritas.CeleritasWorldRenderer;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ChunkProviderClient;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.EmptyChunk;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;

public class ChunkDebugMinimap {
    private static final ChunkDebugMinimap INSTANCE = new ChunkDebugMinimap();
    private static volatile boolean enabled = false;
    private static final int RANGE = 32;

    public static synchronized void toggle() {
        if (enabled) {
            ChunkDebugMinimap.disable();
        } else {
            ChunkDebugMinimap.enable();
        }
    }

    public static synchronized void enable() {
        if (enabled) {
            return;
        }
        enabled = true;
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
    }

    public static synchronized void disable() {
        if (!enabled) {
            return;
        }
        enabled = false;
        MinecraftForge.EVENT_BUS.unregister((Object)INSTANCE);
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Text event) {
        CeleritasWorldRenderer renderer;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null || mc.field_71439_g == null) {
            return;
        }
        try {
            renderer = CeleritasWorldRenderer.getInstance();
        }
        catch (IllegalStateException e) {
            return;
        }
        AngelicaRenderSectionManager manager = renderer.getRenderSectionManager();
        if (manager == null) {
            return;
        }
        float partialTicks = event.partialTicks;
        double pX = mc.field_71439_g.field_70169_q + (mc.field_71439_g.field_70165_t - mc.field_71439_g.field_70169_q) * (double)partialTicks;
        double pZ = mc.field_71439_g.field_70166_s + (mc.field_71439_g.field_70161_v - mc.field_71439_g.field_70166_s) * (double)partialTicks;
        int playerChunkX = (int)Math.floor(pX) >> 4;
        int playerChunkZ = (int)Math.floor(pZ) >> 4;
        GLStateManager.glPushAttrib(1048575);
        GLStateManager.glPushMatrix();
        GLStateManager.glScaled(2.0, 2.0, 1.0);
        GLStateManager.glTranslated(32.0, 32.0, 0.0);
        GLStateManager.disableLighting();
        GLStateManager.disableTexture();
        GLStateManager.disableDepthTest();
        GLStateManager.enableBlend();
        GLStateManager.glBlendFunc(770, 771);
        GLStateManager.glBegin(7);
        ChunkProviderClient chunkProvider = (ChunkProviderClient)mc.field_71441_e.func_72863_F();
        for (int x = playerChunkX - 32; x < playerChunkX + 32; ++x) {
            for (int z = playerChunkZ - 32; z < playerChunkZ + 32; ++z) {
                this.drawChunk(x, z, playerChunkX, playerChunkZ, manager, chunkProvider);
            }
        }
        GL11.glEnd();
        GLStateManager.enableLighting();
        GLStateManager.enableDepthTest();
        GLStateManager.disableBlend();
        GLStateManager.glPopMatrix();
        GLStateManager.glPopAttrib();
    }

    private void drawChunk(int chunkX, int chunkZ, int playerChunkX, int playerChunkZ, AngelicaRenderSectionManager manager, ChunkProviderClient chunkProvider) {
        boolean initialized = false;
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        for (int y = 0; y < 16; ++y) {
            if (!manager.isSectionBuilt(chunkX, y, chunkZ) || manager.isSectionVisuallyEmpty(chunkX, y, chunkZ)) continue;
            initialized = true;
            g = 1.0f;
            if (!manager.isSectionVisible(chunkX, y, chunkZ)) continue;
            b = 1.0f;
            break;
        }
        if (!initialized) {
            Chunk chunk = chunkProvider.func_73154_d(chunkX, chunkZ);
            if (chunk instanceof EmptyChunk) {
                r = 1.0f;
            } else {
                b = 1.0f;
            }
        }
        GL11.glColor4f((float)r, (float)g, (float)b, (float)0.8f);
        int xStart = chunkX - playerChunkX;
        int zStart = chunkZ - playerChunkZ;
        int xEnd = xStart + 1;
        int zEnd = zStart + 1;
        GLStateManager.glVertex3d(xStart, zStart, 0.0);
        GLStateManager.glVertex3d(xStart, zEnd, 0.0);
        GLStateManager.glVertex3d(xEnd, zEnd, 0.0);
        GLStateManager.glVertex3d(xEnd, zStart, 0.0);
    }

    @Generated
    public static boolean isEnabled() {
        return enabled;
    }
}

