/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.config;

import com.gtnewhorizon.gtnhlib.config.Config;

@Config(modid="angelica", filename="angelica-modules")
public class AngelicaConfig {
    @Config.Comment(value={"Enable Celeritas terrain rendering"})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean enableCeleritas;
    @Config.Comment(value={"Enable multi-threaded chunk building for improved performance [Requires Celeritas]"})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresWorldRestart
    public static boolean enableThreadedChunkBuilding;
    @Config.Comment(value={"Number of chunk builder threads. 0 = auto-detect, -1 = use single-threaded fallback"})
    @Config.DefaultInt(value=0)
    @Config.RangeInt(min=-1, max=16)
    @Config.RequiresWorldRestart
    public static int chunkBuilderThreadCount;
    @Config.Comment(value={"Enable NotFine Options"})
    @Config.DefaultBoolean(value=false)
    public static boolean enableNotFineOptions;
    @Config.Comment(value={"Enable Reese's Sodium Options"})
    @Config.DefaultBoolean(value=true)
    public static boolean enableReesesSodiumOptions;
    @Config.Comment(value={"Inject BakedModel rendering into some vanilla blocks"})
    @Config.DefaultBoolean(value=false)
    @Config.RequiresMcRestart
    public static boolean injectQPRendering;
    @Config.Comment(value={"Enable Angelica's test blocks"})
    @Config.DefaultBoolean(value=false)
    @Config.Ignore
    public static boolean enableTestBlocks;
    @Config.Comment(value={"Enable Iris Shaders [Requires Celeritas]"})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean enableIris;
    @Config.Comment(value={"Enable MCPatcherForge features, still in Alpha. Individual features are toggled in mcpatcher.json"})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean enableMCPatcherForgeFeatures;
    @Config.Comment(value={"Replace cloud renderer with a VBO version."})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean enableVBOClouds;
    @Config.Comment(value={"Uses cached attributes for VBO rendering, resulting in less CPU overhead. Disable if you notice any graphical issues."})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean enableVAO;
    @Config.Comment(value={"Enable NotFine features"})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean enableNotFineFeatures;
    @Config.Comment(value={"Tweak F3 screen to be closer to modern versions. [From ArchaicFix]"})
    @Config.DefaultBoolean(value=true)
    public static boolean modernizeF3Screen;
    @Config.Comment(value={"Show block registry name and meta value in F3, similar to 1.8+. [From ArchaicFix]"})
    @Config.DefaultBoolean(value=true)
    public static boolean showBlockDebugInfo;
    @Config.DefaultBoolean(value=true)
    @Config.Comment(value={"Hide downloading terrain screen. [From ArchaicFix]"})
    public static boolean hideDownloadingTerrainScreen;
    @Config.Comment(value={"Show memory usage during game load. [From ArchaicFix]"})
    @Config.DefaultBoolean(value=true)
    public static boolean showSplashMemoryBar;
    @Config.Comment(value={"Renders the HUD elements once per 20 frames (by default) and reuses the pixels to improve performance. [Experimental]"})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean enableHudCaching;
    @Config.Comment(value={"Inject a conditional early return into all RenderGameOverlayEvent receivers; Requires enableHudCaching"})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean enableHudCachingEventTransformer;
    @Config.Comment(value={"Enable HUD Caching at runtime. Requires enableHudCaching to be on at startup. [Experimental]"})
    @Config.DefaultBoolean(value=false)
    public static boolean hudCachingActive;
    @Config.Comment(value={"The amount of frames to wait before updating the HUD elements. [Experimental]"})
    @Config.DefaultInt(value=20)
    @Config.RangeInt(min=1, max=60)
    public static int hudCachingFPS;
    @Config.Comment(value={"Batch drawScreen fonts"})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean enableFontRenderer;
    @Config.Comment(value={"Enable Dynamic Lights"})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean enableDynamicLights;
    @Config.Comment(value={"Optimize world update light. [From Hodgepodge]"})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean optimizeWorldUpdateLight;
    @Config.Comment(value={"Speedup Animations. [From Hodgepodge]"})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean speedupAnimations;
    @Config.Comment(value={"Optimize Texture Loading. [From Hodgepodge]"})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean optimizeTextureLoading;
    @Config.Comment(value={"Fix RenderBlockFluid reading the block type from the world access multiple times"})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean fixFluidRendererCheckingBlockAgain;
    @Config.Comment(value={"Dynamically modifies the render distance of dropped items entities to preserve performance. It starts reducing the render distance when exceeding the threshold set below."})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean dynamicItemRenderDistance;
    @Config.Comment(value={"Max amount of dropped item rendered"})
    @Config.DefaultInt(value=256)
    @Config.RangeInt(min=32, max=2048)
    public static int droppedItemLimit;
    @Config.Comment(value={"Use total world time instead of normal world time. Allows most shader animations to play when doDaylightCycle is off, but causes shader animations to desync from time of day."})
    @Config.DefaultBoolean(value=false)
    public static boolean useTotalWorldTime;
    @Config.Comment(value={"Enable Debug Logging"})
    @Config.DefaultBoolean(value=false)
    @Config.RequiresMcRestart
    public static boolean enableDebugLogging;
    @Config.Comment(value={"Enables PBR atlas dumping"})
    @Config.DefaultBoolean(value=false)
    @Config.Name(value="Enable PBR Debug")
    public static boolean enablePBRDebug;
    @Config.Comment(value={"Enable Zoom"})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean enableZoom;
    @Config.Comment(value={"Optimizes in-world item rendering"})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean optimizeInWorldItemRendering;
    @Config.Comment(value={"Upper limit for the amount of VBO's to cache for optimized item rendering. Higher number can potentially use more VRAM."})
    @Config.DefaultInt(value=512)
    @Config.RangeInt(min=256, max=1024)
    public static int itemRendererCacheSize;
    @Config.Comment(value={"Render distance for the spinning mob inside mod spawners"})
    @Config.DefaultDouble(value=16.0)
    @Config.RangeDouble(min=16.0, max=64.0)
    public static double mobSpawnerRenderDistance;
    @Config.Comment(value={"Switches to an alternate FPS limiter that gives more stable frametimes, in exchange for slightly more latency. Will never introduce more than one frame of latency, and has a lower impact at higher framerates."})
    @Config.DefaultBoolean(value=false)
    public static boolean sleepBeforeSwap;
    @Config.Comment(value={"Allows unicode languages to use an odd gui scale"})
    @Config.DefaultBoolean(value=true)
    public static boolean removeUnicodeEvenScaling;
    @Config.Comment(value={"Block corners and edges between chunks might have \"cracks\" (various lines/dots) in them.", "While using \"Compact Vertex Format\" makes the situation even worse.", "This option fixes it.", "Requires texture reloading (F3 + T) after changing this option to take effect"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixBlockCrack;
    @Config.Comment(value={"The \"epsilon\" value for the fixBlockCrack option. ", "Set this a bit higher if you can still see lines/dots between solid blocks in dark areas.", "May cause intense flickering (z-fighting) between blocks if the value is too high"})
    @Config.RangeDouble(min=0.0, max=0.005)
    @Config.DefaultDouble(value=0.001)
    public static double blockCrackFixEpsilon;
    @Config.Comment(value={"Block classes that have bugs when rendering with the fixBlockCrack can be put here to avoid manipulating them"})
    @Config.DefaultStringList(value={"net.minecraft.block.BlockCauldron", "net.minecraft.block.BlockStairs"})
    public static String[] blockCrackFixBlacklist;
    @Config.Comment(value={"Block classes that have render pass other than 0 but still need to be manipulated.", "Add a block class here if you see flickering (z-fighting) with fixBlockCrack enabled"})
    @Config.DefaultStringList(value={"gregtech.common.blocks.BlockOres", "gregtech.common.blocks.GTBlockOre", "shukaro.artifice.block.world.BlockOre", "bartworks.system.material.BWMetaGeneratedOres", "gtPlusPlus.core.block.base.BlockBaseOre", "org.pfaa.geologica.block.BrokenGeoBlock", "org.pfaa.geologica.block.BrickGeoBlock"})
    public static String[] blockCrackFixRenderPassWhitelist__;
    @Config.Comment(value={"Register HardcodedCustomUniforms in Iris Shaders. May help with compatibility in certain shader packs"})
    @Config.DefaultBoolean(value=false)
    public static boolean enableHardcodedCustomUniforms;
    @Config.Comment(value={"Define IS_IRIS in shader macros."})
    @Config.DefaultBoolean(value=true)
    public static boolean defineIsIris;
    @Config.Comment(value={"Renders chunks before neighbors are ready. Improves loading at render distance edges, useful for low render distance servers."})
    @Config.DefaultBoolean(value=false)
    public static boolean useVanillaChunkTracking;
    @Config.Comment(value={"Disables additional F3 information added by Angelica."})
    @Config.DefaultBoolean(value=false)
    public static boolean disableF3Additions;

    static {
        hudCachingFPS = 20;
    }
}

