/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.compat.toremove;

import com.gtnewhorizons.angelica.AngelicaMod;
import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.shadow.javax.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={Transparency.class, Alpha.class, ShadeModel.class, Texture.class, Texturing.class, Toggleable.class, Lightmap.class, DiffuseLighting.class, Cull.class, DepthTest.class, WriteMaskState.class, Layering.class, Fog.class, Target.class})
public abstract class RenderPhase {
    protected final String name;
    protected Runnable beginAction;
    private final Runnable endAction;
    protected static final Transparency NO_TRANSPARENCY = new Transparency("no_transparency", GLStateManager::disableBlend, () -> {});
    protected static final Transparency ADDITIVE_TRANSPARENCY = new Transparency("additive_transparency", () -> {
        GLStateManager.enableBlend();
        GLStateManager.glBlendFunc(1, 1);
    }, () -> {
        GLStateManager.disableBlend();
        GLStateManager.defaultBlendFunc();
    });
    protected static final Transparency LIGHTNING_TRANSPARENCY = new Transparency("lightning_transparency", () -> {
        GLStateManager.enableBlend();
        GLStateManager.glBlendFunc(770, 1);
    }, () -> {
        GLStateManager.disableBlend();
        GLStateManager.defaultBlendFunc();
    });
    protected static final Transparency GLINT_TRANSPARENCY = new Transparency("glint_transparency", () -> {
        GLStateManager.enableBlend();
        GLStateManager.tryBlendFuncSeparate(768, 1, 0, 1);
    }, () -> {
        GLStateManager.disableBlend();
        GLStateManager.defaultBlendFunc();
    });
    protected static final Transparency CRUMBLING_TRANSPARENCY = new Transparency("crumbling_transparency", () -> {
        GLStateManager.enableBlend();
        GLStateManager.tryBlendFuncSeparate(774, 768, 1, 0);
    }, () -> {
        GLStateManager.disableBlend();
        GLStateManager.defaultBlendFunc();
    });
    protected static final Transparency TRANSLUCENT_TRANSPARENCY = new Transparency("translucent_transparency", () -> {
        GLStateManager.enableBlend();
        GLStateManager.tryBlendFuncSeparate(770, 771, 1, 771);
    }, () -> {
        GLStateManager.disableBlend();
        GLStateManager.defaultBlendFunc();
    });
    protected static final Alpha ZERO_ALPHA = new Alpha(0.0f);
    protected static final Alpha ONE_TENTH_ALPHA = new Alpha(0.003921569f);
    protected static final Alpha HALF_ALPHA = new Alpha(0.5f);
    protected static final ShadeModel SHADE_MODEL = new ShadeModel(false);
    protected static final ShadeModel SMOOTH_SHADE_MODEL = new ShadeModel(true);
    protected static final Texture MIPMAP_BLOCK_ATLAS_TEXTURE;
    protected static final Texture BLOCK_ATLAS_TEXTURE;
    protected static final Texture NO_TEXTURE;
    protected static final Texturing DEFAULT_TEXTURING;
    protected static final Lightmap ENABLE_LIGHTMAP;
    protected static final Lightmap DISABLE_LIGHTMAP;
    protected static final DiffuseLighting ENABLE_DIFFUSE_LIGHTING;
    protected static final DiffuseLighting DISABLE_DIFFUSE_LIGHTING;
    protected static final Cull ENABLE_CULLING;
    protected static final Cull DISABLE_CULLING;
    protected static final DepthTest ALWAYS_DEPTH_TEST;
    protected static final DepthTest EQUAL_DEPTH_TEST;
    protected static final DepthTest LEQUAL_DEPTH_TEST;
    protected static final WriteMaskState ALL_MASK;
    protected static final WriteMaskState COLOR_MASK;
    protected static final WriteMaskState DEPTH_MASK;
    protected static final Layering NO_LAYERING;
    protected static final Fog NO_FOG;
    protected static final Fog FOG;
    protected static final Fog BLACK_FOG;
    protected static final Target MAIN_TARGET;
    protected static final Target OUTLINE_TARGET;
    protected static final Target TRANSLUCENT_TARGET;
    private static ResourceLocation ATLAS;

    public RenderPhase(String name, Runnable beginAction, Runnable endAction) {
        this.name = name;
        this.beginAction = beginAction;
        this.endAction = endAction;
    }

    public void startDrawing() {
        this.beginAction.run();
    }

    public void endDrawing() {
        this.endAction.run();
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            RenderPhase lv = (RenderPhase)object;
            return this.name.equals(lv.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    static {
        ATLAS = TextureMap.field_110575_b;
        MIPMAP_BLOCK_ATLAS_TEXTURE = new Texture(ATLAS, false, true);
        BLOCK_ATLAS_TEXTURE = new Texture(ATLAS, false, false);
        NO_TEXTURE = new Texture();
        DEFAULT_TEXTURING = new Texturing("default_texturing", () -> {}, () -> {});
        ENABLE_LIGHTMAP = new Lightmap(true);
        DISABLE_LIGHTMAP = new Lightmap(false);
        ENABLE_DIFFUSE_LIGHTING = new DiffuseLighting(true);
        DISABLE_DIFFUSE_LIGHTING = new DiffuseLighting(false);
        ENABLE_CULLING = new Cull(true);
        DISABLE_CULLING = new Cull(false);
        ALWAYS_DEPTH_TEST = new DepthTest("always", 519);
        EQUAL_DEPTH_TEST = new DepthTest("==", 514);
        LEQUAL_DEPTH_TEST = new DepthTest("<=", 515);
        ALL_MASK = new WriteMaskState(true, true);
        COLOR_MASK = new WriteMaskState(true, false);
        DEPTH_MASK = new WriteMaskState(false, true);
        NO_LAYERING = new Layering("no_layering", () -> {}, () -> {});
        NO_FOG = new Fog("no_fog", () -> {}, () -> {});
        FOG = new Fog("fog", () -> {
            AngelicaMod.LOGGER.debug("Fog - Not setting level fog color");
            GLStateManager.enableFog();
        }, GLStateManager::disableFog);
        BLACK_FOG = new Fog("black_fog", () -> {
            GLStateManager.fogColor(0.0f, 0.0f, 0.0f, 1.0f);
            GLStateManager.enableFog();
        }, () -> {
            AngelicaMod.LOGGER.debug("Fog - Not setting level fog color");
            GLStateManager.disableFog();
        });
        MAIN_TARGET = new Target("main_target", () -> {}, () -> {});
        OUTLINE_TARGET = new Target("outline_target", () -> AngelicaMod.LOGGER.debug("NOT enabling the entity outline framebuffer"), () -> Minecraft.func_71410_x().func_147110_a().func_147610_a(false));
        TRANSLUCENT_TARGET = new Target("translucent_target", () -> {
            if (Minecraft.func_71375_t()) {
                AngelicaMod.LOGGER.debug("NOT enabling the translucent framebuffer");
            }
        }, () -> {
            if (Minecraft.func_71375_t()) {
                Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
            }
        });
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=RenderPhase.class)
    public static class Transparency
    extends RenderPhase {
        public Transparency(String string, Runnable runnable, Runnable runnable2) {
            super(string, runnable, runnable2);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=RenderPhase.class)
    public static class Alpha
    extends RenderPhase {
        private final float alpha;

        public Alpha(float alpha) {
            super("alpha", () -> {
                if (alpha > 0.0f) {
                    GLStateManager.enableAlphaTest();
                    GLStateManager.glAlphaFunc(516, alpha);
                } else {
                    GLStateManager.disableAlphaTest();
                }
            }, () -> {
                GLStateManager.disableAlphaTest();
                GLStateManager.glAlphaFunc(516, 0.1f);
            });
            this.alpha = alpha;
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (this == object) {
                return true;
            }
            if (object != null && this.getClass() == object.getClass()) {
                if (!super.equals(object)) {
                    return false;
                }
                return this.alpha == ((Alpha)object).alpha;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), Float.valueOf(this.alpha));
        }

        @Override
        public String toString() {
            return Alpha.jvmdowngrader$concat$toString$1(this.name, this.alpha);
        }

        private static /* synthetic */ String jvmdowngrader$concat$toString$1(String string, float f) {
            return string + "[" + f + "]";
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=RenderPhase.class)
    public static class ShadeModel
    extends RenderPhase {
        private final boolean smooth;

        public ShadeModel(boolean smooth) {
            super("shade_model", () -> GLStateManager.glShadeModel(smooth ? 7425 : 7424), () -> GLStateManager.glShadeModel(7424));
            this.smooth = smooth;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object != null && this.getClass() == object.getClass()) {
                ShadeModel lv = (ShadeModel)object;
                return this.smooth == lv.smooth;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Boolean.hashCode(this.smooth);
        }

        @Override
        public String toString() {
            return ShadeModel.jvmdowngrader$concat$toString$1(this.name, this.smooth ? "smooth" : "flat");
        }

        private static /* synthetic */ String jvmdowngrader$concat$toString$1(String string, String string2) {
            return string + "[" + string2 + "]";
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=RenderPhase.class)
    public static class Texture
    extends RenderPhase {
        private final Optional<ResourceLocation> id;
        protected boolean bilinear;
        protected boolean mipmap;

        public Texture(ResourceLocation id, boolean bilinear, boolean mipmap) {
            super("texture", () -> {
                GLStateManager.enableTexture();
                TextureManager lv = Minecraft.func_71410_x().func_110434_K();
                lv.func_110577_a(id);
            }, () -> {});
            this.id = Optional.of(id);
            this.bilinear = bilinear;
            this.mipmap = mipmap;
        }

        public Texture() {
            super("texture", GLStateManager::disableTexture, GLStateManager::enableTexture);
            this.id = Optional.empty();
            this.bilinear = false;
            this.mipmap = false;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object != null && this.getClass() == object.getClass()) {
                Texture lv = (Texture)object;
                return this.id.equals(lv.id) && this.bilinear == lv.bilinear && this.mipmap == lv.mipmap;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.id.hashCode();
        }

        @Override
        public String toString() {
            return Texture.jvmdowngrader$concat$toString$1(this.name, String.valueOf(this.id), this.bilinear, this.mipmap);
        }

        protected Optional<ResourceLocation> getId() {
            return this.id;
        }

        private static /* synthetic */ String jvmdowngrader$concat$toString$1(String string, String string2, boolean bl, boolean bl2) {
            return string + "[" + string2 + "(blur=" + bl + ", mipmap=" + bl2 + ")]";
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=RenderPhase.class)
    public static class Texturing
    extends RenderPhase {
        public Texturing(String string, Runnable runnable, Runnable runnable2) {
            super(string, runnable, runnable2);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=RenderPhase.class)
    public static class Lightmap
    extends Toggleable {
        public Lightmap(boolean lightmap) {
            super("lightmap", () -> {
                if (lightmap) {
                    AngelicaMod.LOGGER.debug("Lightmap - enable (not implemented)");
                }
            }, () -> {
                if (lightmap) {
                    AngelicaMod.LOGGER.debug("Lightmap - disable (not implemented)");
                }
            }, lightmap);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=RenderPhase.class)
    public static class DiffuseLighting
    extends Toggleable {
        public DiffuseLighting(boolean guiLighting) {
            super("diffuse_lighting", () -> {
                if (guiLighting) {
                    throw new RuntimeException("Not Implemented Yet");
                }
            }, () -> {
                if (guiLighting) {
                    throw new RuntimeException("Not Implemented Yet");
                }
            }, guiLighting);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=RenderPhase.class)
    public static class Cull
    extends Toggleable {
        public Cull(boolean culling) {
            super("cull", () -> {
                if (!culling) {
                    GLStateManager.disableCull();
                }
            }, () -> {
                if (!culling) {
                    GLStateManager.enableCull();
                }
            }, culling);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=RenderPhase.class)
    public static class DepthTest
    extends RenderPhase {
        private final String depthFunction;
        private final int func;

        public DepthTest(String string, int i) {
            super("depth_test", () -> {
                if (i != 519) {
                    GLStateManager.enableDepthTest();
                    GLStateManager.glDepthFunc(i);
                }
            }, () -> {
                if (i != 519) {
                    GLStateManager.disableDepthTest();
                    GLStateManager.glDepthFunc(515);
                }
            });
            this.depthFunction = string;
            this.func = i;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object != null && this.getClass() == object.getClass()) {
                DepthTest lv = (DepthTest)object;
                return this.func == lv.func;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Integer.hashCode(this.func);
        }

        @Override
        public String toString() {
            return DepthTest.jvmdowngrader$concat$toString$1(this.name, this.depthFunction);
        }

        private static /* synthetic */ String jvmdowngrader$concat$toString$1(String string, String string2) {
            return string + "[" + string2 + "]";
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=RenderPhase.class)
    public static class WriteMaskState
    extends RenderPhase {
        private final boolean color;
        private final boolean depth;

        public WriteMaskState(boolean color, boolean depth) {
            super("write_mask_state", () -> {
                if (!depth) {
                    GLStateManager.glDepthMask(depth);
                }
                if (!color) {
                    GLStateManager.glColorMask(color, color, color, color);
                }
            }, () -> {
                if (!depth) {
                    GLStateManager.glDepthMask(true);
                }
                if (!color) {
                    GLStateManager.glColorMask(true, true, true, true);
                }
            });
            this.color = color;
            this.depth = depth;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object != null && this.getClass() == object.getClass()) {
                WriteMaskState lv = (WriteMaskState)object;
                return this.color == lv.color && this.depth == lv.depth;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.color, this.depth);
        }

        @Override
        public String toString() {
            return WriteMaskState.jvmdowngrader$concat$toString$1(this.name, this.color, this.depth);
        }

        private static /* synthetic */ String jvmdowngrader$concat$toString$1(String string, boolean bl, boolean bl2) {
            return string + "[writeColor=" + bl + ", writeDepth=" + bl2 + "]";
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=RenderPhase.class)
    public static class Layering
    extends RenderPhase {
        public Layering(String string, Runnable runnable, Runnable runnable2) {
            super(string, runnable, runnable2);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=RenderPhase.class)
    public static class Fog
    extends RenderPhase {
        public Fog(String string, Runnable runnable, Runnable runnable2) {
            super(string, runnable, runnable2);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=RenderPhase.class)
    public static class Target
    extends RenderPhase {
        public Target(String string, Runnable runnable, Runnable runnable2) {
            super(string, runnable, runnable2);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=RenderPhase.class)
    static class Toggleable
    extends RenderPhase {
        private final boolean enabled;

        public Toggleable(String string, Runnable runnable, Runnable runnable2, boolean bl) {
            super(string, runnable, runnable2);
            this.enabled = bl;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object != null && this.getClass() == object.getClass()) {
                Toggleable lv = (Toggleable)object;
                return this.enabled == lv.enabled;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Boolean.hashCode(this.enabled);
        }

        @Override
        public String toString() {
            return Toggleable.jvmdowngrader$concat$toString$1(this.name, this.enabled);
        }

        private static /* synthetic */ String jvmdowngrader$concat$toString$1(String string, boolean bl) {
            return string + "[" + bl + "]";
        }
    }
}

