/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.compat.toremove;

import com.google.common.collect.Queues;
import java.util.Deque;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j21.stub.java_base.J_U_SequencedCollection;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={Entry.class})
public class MatrixStack {
    private final Deque<Entry> matrixStack = Queues.newArrayDeque();

    public MatrixStack() {
        this.matrixStack.add(new Entry(new Matrix4f().identity(), new Matrix3f().identity()));
    }

    public MatrixStack(Matrix4f initial) {
        Matrix3f normal = new Matrix3f();
        this.matrixStack.add(new Entry(initial, initial.normal(normal)));
    }

    public Entry peek() {
        return (Entry)J_U_SequencedCollection.getLast(this.matrixStack);
    }

    public void push() {
        Entry lv = (Entry)J_U_SequencedCollection.getLast(this.matrixStack);
        J_U_SequencedCollection.addLast(this.matrixStack, (Object)new Entry(new Matrix4f((Matrix4fc)lv.jvmdowngrader$nest$com_gtnewhorizons_angelica_compat_toremove_MatrixStack$Entry$get$model()), new Matrix3f((Matrix3fc)lv.jvmdowngrader$nest$com_gtnewhorizons_angelica_compat_toremove_MatrixStack$Entry$get$normal())));
    }

    public void pop() {
        J_U_SequencedCollection.removeLast(this.matrixStack);
    }

    public boolean isEmpty() {
        return this.matrixStack.size() == 1;
    }

    public void reset() {
        while (this.matrixStack.size() > 1) {
            J_U_SequencedCollection.removeLast(this.matrixStack);
        }
        this.loadIdentity();
    }

    public void translate(double d, double e, double f) {
        Entry lv = (Entry)J_U_SequencedCollection.getLast(this.matrixStack);
        lv.jvmdowngrader$nest$com_gtnewhorizons_angelica_compat_toremove_MatrixStack$Entry$get$model().translate((float)d, (float)e, (float)f);
    }

    public void rotateX(float f) {
        Entry lv = (Entry)J_U_SequencedCollection.getLast(this.matrixStack);
        lv.jvmdowngrader$nest$com_gtnewhorizons_angelica_compat_toremove_MatrixStack$Entry$get$model().rotateX(f);
        lv.jvmdowngrader$nest$com_gtnewhorizons_angelica_compat_toremove_MatrixStack$Entry$get$normal().rotateX(f);
    }

    public void rotateY(float f) {
        Entry lv = (Entry)J_U_SequencedCollection.getLast(this.matrixStack);
        lv.jvmdowngrader$nest$com_gtnewhorizons_angelica_compat_toremove_MatrixStack$Entry$get$model().rotateY(f);
        lv.jvmdowngrader$nest$com_gtnewhorizons_angelica_compat_toremove_MatrixStack$Entry$get$normal().rotateY(f);
    }

    public void rotateZ(float f) {
        Entry lv = (Entry)J_U_SequencedCollection.getLast(this.matrixStack);
        lv.jvmdowngrader$nest$com_gtnewhorizons_angelica_compat_toremove_MatrixStack$Entry$get$model().rotateZ(f);
        lv.jvmdowngrader$nest$com_gtnewhorizons_angelica_compat_toremove_MatrixStack$Entry$get$normal().rotateZ(f);
    }

    public void scale(float f, float g, float h) {
        Entry lv = (Entry)J_U_SequencedCollection.getLast(this.matrixStack);
        lv.jvmdowngrader$nest$com_gtnewhorizons_angelica_compat_toremove_MatrixStack$Entry$get$model().scale(f, g, h);
        if (f == g && g == h) {
            if (f > 0.0f) {
                return;
            }
            lv.jvmdowngrader$nest$com_gtnewhorizons_angelica_compat_toremove_MatrixStack$Entry$get$normal().scale(-1.0f);
        }
        float i = 1.0f / f;
        float j = 1.0f / g;
        float k = 1.0f / h;
        float l = MatrixStack.invSqrt(i * j * k);
        lv.jvmdowngrader$nest$com_gtnewhorizons_angelica_compat_toremove_MatrixStack$Entry$get$normal().scale(l * i, l * j, l * k);
    }

    public void multiply(Quaternionf quaternion) {
        Entry entry = (Entry)J_U_SequencedCollection.getLast(this.matrixStack);
        entry.jvmdowngrader$nest$com_gtnewhorizons_angelica_compat_toremove_MatrixStack$Entry$get$model().rotate((Quaternionfc)quaternion);
        entry.jvmdowngrader$nest$com_gtnewhorizons_angelica_compat_toremove_MatrixStack$Entry$get$normal().rotate((Quaternionfc)quaternion);
    }

    public void multiply(Quaternionf quaternion, float originX, float originY, float originZ) {
        Entry entry = (Entry)J_U_SequencedCollection.getLast(this.matrixStack);
        entry.jvmdowngrader$nest$com_gtnewhorizons_angelica_compat_toremove_MatrixStack$Entry$get$model().rotateAround((Quaternionfc)quaternion, originX, originY, originZ);
        entry.jvmdowngrader$nest$com_gtnewhorizons_angelica_compat_toremove_MatrixStack$Entry$get$normal().rotate((Quaternionfc)quaternion);
    }

    public void loadIdentity() {
        Entry entry = (Entry)J_U_SequencedCollection.getLast(this.matrixStack);
        entry.jvmdowngrader$nest$com_gtnewhorizons_angelica_compat_toremove_MatrixStack$Entry$get$model().identity();
        entry.jvmdowngrader$nest$com_gtnewhorizons_angelica_compat_toremove_MatrixStack$Entry$get$normal().identity();
    }

    public void multiplyPositionMatrix(Matrix4f matrix) {
        ((Entry)J_U_SequencedCollection.getLast(this.matrixStack)).jvmdowngrader$nest$com_gtnewhorizons_angelica_compat_toremove_MatrixStack$Entry$get$model().mul((Matrix4fc)matrix);
    }

    private static float invSqrt(float x) {
        float xhalf = 0.5f * x;
        int i = Float.floatToIntBits(x);
        i = 1597463007 - (i >> 1);
        x = Float.intBitsToFloat(i);
        x *= 1.5f - xhalf * x * x;
        return x;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=MatrixStack.class)
    public static final class Entry {
        private final Matrix4f model;
        private final Matrix3f normal;

        Entry(Matrix4f model, Matrix3f normal) {
            this.model = model;
            this.normal = normal;
        }

        public Matrix4f getModel() {
            return this.model;
        }

        public Matrix3f getNormal() {
            return this.normal;
        }

        public /* synthetic */ Matrix3f jvmdowngrader$nest$com_gtnewhorizons_angelica_compat_toremove_MatrixStack$Entry$get$normal() {
            return this.normal;
        }

        public /* synthetic */ void jvmdowngrader$nest$com_gtnewhorizons_angelica_compat_toremove_MatrixStack$Entry$set$normal(Matrix3f matrix3f) {
            this.normal = matrix3f;
        }

        public /* synthetic */ Matrix4f jvmdowngrader$nest$com_gtnewhorizons_angelica_compat_toremove_MatrixStack$Entry$get$model() {
            return this.model;
        }

        public /* synthetic */ void jvmdowngrader$nest$com_gtnewhorizons_angelica_compat_toremove_MatrixStack$Entry$set$model(Matrix4f matrix4f) {
            this.model = matrix4f;
        }
    }
}

