/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.compat.mojang;

import com.gtnewhorizon.gtnhlib.bytebuf.MemoryUtilities;
import com.gtnewhorizons.angelica.compat.mojang.ByteBufferBackedInputStream;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.imageio.ImageIO;
import lombok.Generated;
import net.coderbot.iris.Iris;
import org.lwjgl.opengl.GL11;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={Format.class})
public class NativeImage
extends BufferedImage {
    private final Format format;
    private final int width;
    private final int height;
    private final int size;

    public NativeImage(int width, int height, boolean useStb) {
        this(Format.RGBA, width, height, useStb);
    }

    public NativeImage(Format format, int width, int height, boolean useStb) {
        super(width, height, 2);
        this.format = format;
        this.width = width;
        this.height = height;
        this.size = width * height * format.jvmdowngrader$nest$com_gtnewhorizons_angelica_compat_mojang_NativeImage$Format$get$components();
    }

    public NativeImage(Format format, int width, int height, BufferedImage image) {
        super(image.getColorModel(), image.getRaster(), image.isAlphaPremultiplied(), null);
        this.format = format;
        this.width = width;
        this.height = height;
        this.size = width * height * format.jvmdowngrader$nest$com_gtnewhorizons_angelica_compat_mojang_NativeImage$Format$get$components();
    }

    public static NativeImage read(ByteBuffer buf) throws IOException {
        return NativeImage.read(new ByteBufferBackedInputStream(buf));
    }

    public static NativeImage read(InputStream inputStream) throws IOException {
        BufferedImage image = ImageIO.read(inputStream);
        return new NativeImage(Format.RGBA, image.getWidth(), image.getHeight(), image);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadTexture(int level, boolean bl) {
        GL11.glPixelStorei((int)3333, (int)this.format.jvmdowngrader$nest$com_gtnewhorizons_angelica_compat_mojang_NativeImage$Format$get$components());
        IntBuffer buffer = MemoryUtilities.memAllocInt((int)this.size);
        try {
            GL11.glGetTexImage((int)3553, (int)level, (int)this.format.jvmdowngrader$nest$com_gtnewhorizons_angelica_compat_mojang_NativeImage$Format$get$glFormat(), (int)33639, (IntBuffer)buffer);
            int[] data = new int[this.size];
            buffer.get(data);
            this.setRGB(0, 0, this.width, this.height, data, 0, this.width);
        }
        finally {
            MemoryUtilities.memFree((IntBuffer)buffer);
        }
    }

    public void writeToFile(File file) throws IOException {
        try {
            ImageIO.write((RenderedImage)this, "png", file);
        }
        catch (IOException ioexception) {
            Iris.logger.info("[TextureDump] Unable to write: ", ioexception);
        }
    }

    public static int combine(int i, int j, int k, int l) {
        return (i & 0xFF) << 24 | (j & 0xFF) << 16 | (k & 0xFF) << 8 | l & 0xFF;
    }

    public static int getA(int i) {
        return i >> 24 & 0xFF;
    }

    public static int getR(int i) {
        return i >> 0 & 0xFF;
    }

    public static int getG(int i) {
        return i >> 8 & 0xFF;
    }

    public static int getB(int i) {
        return i >> 16 & 0xFF;
    }

    public int getPixelRGBA(int x, int y) {
        return this.getRGB(x, y);
    }

    public void setPixelRGBA(int x, int y, int rgb) {
        this.setRGB(x, y, rgb);
    }

    @Generated
    public Format getFormat() {
        return this.format;
    }

    @Override
    @Generated
    public int getWidth() {
        return this.width;
    }

    @Override
    @Generated
    public int getHeight() {
        return this.height;
    }

    @Generated
    public int getSize() {
        return this.size;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=NativeImage.class)
    public static enum Format {
        RGBA(4, 6408),
        RGB(3, 6407);

        private final int components;
        private final int glFormat;

        private Format(int components, int glFormat) {
            this.components = components;
            this.glFormat = glFormat;
        }

        public /* synthetic */ int jvmdowngrader$nest$com_gtnewhorizons_angelica_compat_mojang_NativeImage$Format$get$components() {
            return this.components;
        }

        public /* synthetic */ void jvmdowngrader$nest$com_gtnewhorizons_angelica_compat_mojang_NativeImage$Format$set$components(int n) {
            this.components = n;
        }

        public /* synthetic */ int jvmdowngrader$nest$com_gtnewhorizons_angelica_compat_mojang_NativeImage$Format$get$glFormat() {
            return this.glFormat;
        }

        public /* synthetic */ void jvmdowngrader$nest$com_gtnewhorizons_angelica_compat_mojang_NativeImage$Format$set$glFormat(int n) {
            this.glFormat = n;
        }
    }
}

