/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.compat.iris;

import com.gtnewhorizons.angelica.compat.ModStatus;
import java.util.LinkedHashMap;
import java.util.Map;
import net.coderbot.iris.parsing.BiomeCategories;
import net.minecraft.world.biome.BiomeGenBase;

public class ModdedBiomeDetector {
    private static boolean initialized = false;
    private static Class<?> bopEndBiomeClass = null;
    private static Class<?> bopNetherBiomeClass = null;
    private static Class<?> bopOceanBiomeClass = null;
    private static final Map<Class<?>, BiomeCategories> rwgClassMap = new LinkedHashMap();
    private static Class<?> lotrBiomeClass = null;

    private static synchronized void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        ModdedBiomeDetector.initializeBOP();
        ModdedBiomeDetector.initializeRWG();
        ModdedBiomeDetector.initializeLOTR();
    }

    private static void initializeBOP() {
        try {
            bopEndBiomeClass = Class.forName("biomesoplenty.common.biome.BOPEndBiome");
            bopNetherBiomeClass = Class.forName("biomesoplenty.common.biome.BOPNetherBiome");
            bopOceanBiomeClass = Class.forName("biomesoplenty.common.biome.BOPOceanBiome");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private static void initializeRWG() {
        ModdedBiomeDetector.tryAddRWGClass("rwg.biomes.base.BaseBiomeOcean", BiomeCategories.OCEAN);
        ModdedBiomeDetector.tryAddRWGClass("rwg.biomes.base.BaseBiomeRiver", BiomeCategories.RIVER);
        ModdedBiomeDetector.tryAddRWGClass("rwg.biomes.base.BaseBiomePlains", BiomeCategories.PLAINS);
        ModdedBiomeDetector.tryAddRWGClass("rwg.biomes.base.BaseBiomeColdPlains", BiomeCategories.PLAINS);
        ModdedBiomeDetector.tryAddRWGClass("rwg.biomes.base.BaseBiomeHotPlains", BiomeCategories.PLAINS);
        ModdedBiomeDetector.tryAddRWGClass("rwg.biomes.base.BaseBiomeHotDesert", BiomeCategories.DESERT);
        ModdedBiomeDetector.tryAddRWGClass("rwg.biomes.base.BaseBiomeSnowDesert", BiomeCategories.DESERT);
        ModdedBiomeDetector.tryAddRWGClass("rwg.biomes.base.BaseBiomeJungle", BiomeCategories.JUNGLE);
        ModdedBiomeDetector.tryAddRWGClass("rwg.biomes.base.BaseBiomeTropicalIsland", BiomeCategories.JUNGLE);
        ModdedBiomeDetector.tryAddRWGClass("rwg.biomes.base.BaseBiomeRedwood", BiomeCategories.FOREST);
        ModdedBiomeDetector.tryAddRWGClass("rwg.biomes.base.BaseBiomeTemperateForest", BiomeCategories.FOREST);
        ModdedBiomeDetector.tryAddRWGClass("rwg.biomes.base.BaseBiomeColdForest", BiomeCategories.TAIGA);
        ModdedBiomeDetector.tryAddRWGClass("rwg.biomes.base.BaseBiomeHotForest", BiomeCategories.FOREST);
        ModdedBiomeDetector.tryAddRWGClass("rwg.biomes.base.BaseBiomeSnowForest", BiomeCategories.TAIGA);
    }

    private static void initializeLOTR() {
        if (ModStatus.isLotrLoaded) {
            try {
                lotrBiomeClass = Class.forName("lotr.common.world.biome.LOTRBiome");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    private static void tryAddRWGClass(String className, BiomeCategories category) {
        try {
            Class<?> clazz = Class.forName(className);
            rwgClassMap.put(clazz, category);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static BiomeCategories detectModdedBiome(BiomeGenBase biome) {
        if (!initialized) {
            ModdedBiomeDetector.initialize();
        }
        if (bopEndBiomeClass != null && bopEndBiomeClass.isInstance(biome)) {
            return BiomeCategories.THE_END;
        }
        if (bopNetherBiomeClass != null && bopNetherBiomeClass.isInstance(biome)) {
            return BiomeCategories.NETHER;
        }
        if (bopOceanBiomeClass != null && bopOceanBiomeClass.isInstance(biome)) {
            return BiomeCategories.OCEAN;
        }
        if (biome.func_150562_l().getName().contains("rwg.biomes")) {
            for (Map.Entry<Class<?>, BiomeCategories> entry : rwgClassMap.entrySet()) {
                if (!entry.getKey().isInstance(biome)) continue;
                return entry.getValue();
            }
        }
        if (lotrBiomeClass != null && lotrBiomeClass.isInstance(biome)) {
            return ModdedBiomeDetector.detectLOTRBiome(biome);
        }
        return null;
    }

    private static BiomeCategories detectLOTRBiome(BiomeGenBase biome) {
        BiomeCategories biomeCategories;
        switch (biome.field_76791_y) {
            case "river": 
            case "farHaradJungleLake": 
            case "lake": {
                biomeCategories = BiomeCategories.RIVER;
                break;
            }
            case "rohan": 
            case "rivendell": 
            case "rhunIsland": 
            case "rhunLandHills": 
            case "rhunLandSteppe": 
            case "rhunLand": 
            case "andrast": 
            case "blackrootVale": 
            case "lamedon": 
            case "imlothMelui": 
            case "towerHills": 
            case "dorwinion": 
            case "dale": 
            case "shireMoors": 
            case "wold": 
            case "anduinVale": 
            case "rhun": 
            case "lebennin": 
            case "pertorogwaith": 
            case "breeland": 
            case "island": 
            case "pinnathGelin": 
            case "minhiriath": 
            case "pelennor": 
            case "adornland": 
            case "nanCurunir": 
            case "ithilienWasteland": 
            case "fangornClearing": 
            case "barrowDowns": 
            case "dorEnErnilHills": 
            case "dorEnErnil": 
            case "nurn": 
            case "wilderland": 
            case "eastBight": 
            case "lindon": 
            case "eregion": 
            case "enedwaith": 
            case "meneltarma": 
            case "anduinHills": 
            case "eriador": 
            case "angle": 
            case "loneLandsHills": 
            case "loneLands": 
            case "pelargir": 
            case "rohanUrukHighlands": 
            case "celebrant": 
            case "gondor": 
            case "shire": 
            case "nurnen": 
            case "farHarad": {
                biomeCategories = BiomeCategories.PLAINS;
                break;
            }
            case "mistyMountains": 
            case "windMountains": 
            case "farHaradVolcano": 
            case "redMountains": 
            case "haradMountains": 
            case "angmarMountains": 
            case "blueMountains": 
            case "greyMountains": 
            case "whiteMountains": 
            case "mordorMountains": {
                biomeCategories = BiomeCategories.MOUNTAIN;
                break;
            }
            case "shireWoodlands": 
            case "rhunIslandForest": 
            case "rhunRedForest": 
            case "pukel": 
            case "lossarnach": 
            case "gulfHaradForest": 
            case "nearHaradFertileForest": 
            case "dolGuldur": 
            case "rhunForest": 
            case "tauredainClearing": 
            case "umbarForest": 
            case "farHaradForest": 
            case "chetwood": 
            case "woodlandRealmHills": 
            case "mirkwoodNorth": 
            case "whiteDowns": 
            case "ithilienHills": 
            case "gondorWoodlands": 
            case "rohanWoodlands": 
            case "fangornWasteland": 
            case "mirkwoodMountains": 
            case "lindonWoodlands": 
            case "lothlorienEdge": 
            case "erynVorn": 
            case "oldForest": 
            case "fangorn": 
            case "dunland": 
            case "ithilien": 
            case "mirkwoodCorrupted": 
            case "woodlandRealm": 
            case "trollshaws": 
            case "lothlorien": 
            case "farHaradKanuka": {
                biomeCategories = BiomeCategories.FOREST;
                break;
            }
            case "mordor": 
            case "lastDesert": 
            case "harnedor": 
            case "easternDesolation": 
            case "morgulVale": 
            case "gorgoroth": 
            case "udun": 
            case "nearHaradRedDesert": 
            case "nearHaradSemiDesert": 
            case "lostladen": 
            case "nearHaradHills": 
            case "nearHarad": 
            case "nanUngol": 
            case "dagorlad": 
            case "brownLands": {
                biomeCategories = BiomeCategories.DESERT;
                break;
            }
            case "ironHills": 
            case "rivendellHills": 
            case "windMountainsFoothills": 
            case "lamedonHills": 
            case "redMountainsFoothills": 
            case "tolfalas": 
            case "dorwinionHills": 
            case "whiteMountainsFoothills": 
            case "blueMountainsFoothills": 
            case "greyMountainsFoothills": 
            case "mistyMountainsFoothills": 
            case "erebor": 
            case "angmar": 
            case "eriadorDowns": 
            case "ettenmoors": 
            case "emynMuil": {
                biomeCategories = BiomeCategories.EXTREME_HILLS;
                break;
            }
            case "deadMarshes": 
            case "shireMarshes": 
            case "farHaradMangrove": 
            case "farHaradSwamp": 
            case "swanfleet": 
            case "nindalf": 
            case "longMarshes": 
            case "entwashMouth": 
            case "nurnMarshes": 
            case "gladdenFields": 
            case "midgewater": 
            case "anduinMouth": {
                biomeCategories = BiomeCategories.SWAMP;
                break;
            }
            case "harondor": 
            case "nearHaradOasis": 
            case "nearHaradRiverbank": 
            case "farHaradBushlandHills": 
            case "farHaradBushland": 
            case "gulfHarad": 
            case "nearHaradFertile": 
            case "umbarHills": 
            case "umbar": 
            case "farHaradAridHills": 
            case "farHaradArid": {
                biomeCategories = BiomeCategories.SAVANNA;
                break;
            }
            case "ocean": {
                biomeCategories = BiomeCategories.OCEAN;
                break;
            }
            case "forodwaith": 
            case "forodwaithGlacier": 
            case "tundra": 
            case "forodwaithMountains": {
                biomeCategories = BiomeCategories.ICY;
                break;
            }
            case "lindonCoast": 
            case "beachWhite": 
            case "farHaradCoast": 
            case "forodwaithCoast": 
            case "beachGravel": 
            case "beach": {
                biomeCategories = BiomeCategories.BEACH;
                break;
            }
            case "coldfells": 
            case "wilderlandNorth": 
            case "taiga": {
                biomeCategories = BiomeCategories.TAIGA;
                break;
            }
            case "farHaradJungle": 
            case "halfTrollForest": 
            case "farHaradJungleMountains": 
            case "farHaradCloudForest": 
            case "farHaradJungleEdge": {
                biomeCategories = BiomeCategories.JUNGLE;
                break;
            }
            case "utumno": {
                biomeCategories = BiomeCategories.NONE;
                break;
            }
            default: {
                biomeCategories = null;
            }
        }
        return biomeCategories;
    }
}

