/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.compat.holoinventory;

import com.gtnewhorizons.angelica.compat.ModStatus;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class HoloInventoryReflectionCompat {
    private static final String RENDERER_CLASS = "net.dries007.holoInventory.client.Renderer";
    private static boolean isLoaded;
    private static final MethodHandle renderEventPostMethod;
    private static final MethodHandle renderEventMethod;
    private static final MethodHandle angelicaOverrideSetter;

    public static void renderEvent(RenderGameOverlayEvent event) {
        if (!isLoaded) {
            return;
        }
        try {
            if (event instanceof RenderGameOverlayEvent.Post && renderEventPostMethod != null) {
                renderEventPostMethod.invokeExact((RenderGameOverlayEvent.Post)event);
            } else {
                renderEventMethod.invokeExact(event);
            }
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            ModStatus.LOGGER.error("Failed to invoke HoloInventory renderEvent", t);
            isLoaded = false;
        }
    }

    public static void setAngelicaOverride(boolean value) {
        if (!isLoaded) {
            return;
        }
        try {
            angelicaOverrideSetter.invokeExact(value);
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            ModStatus.LOGGER.error("Failed to invoke HoloInventory renderEvent", t);
            isLoaded = false;
        }
    }

    static {
        MethodHandle renderEventPostMethodTemp = null;
        MethodHandle renderEventMethodTemp = null;
        MethodHandle angelicaOverrideSetterTemp = null;
        try {
            Class<?> rendererClass = Class.forName(RENDERER_CLASS);
            Field instanceField = rendererClass.getDeclaredField("INSTANCE");
            instanceField.setAccessible(true);
            Object rendererInstance = instanceField.get(null);
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            try {
                renderEventPostMethodTemp = lookup.findVirtual(rendererClass, "renderEvent", MethodType.methodType(Void.TYPE, RenderGameOverlayEvent.Post.class));
            }
            catch (NoSuchMethodException e) {
                renderEventMethodTemp = lookup.findVirtual(rendererClass, "renderEvent", MethodType.methodType(Void.TYPE, RenderGameOverlayEvent.class));
            }
            Field angelicaOverrideField = rendererClass.getDeclaredField("angelicaOverride");
            angelicaOverrideField.setAccessible(true);
            angelicaOverrideSetterTemp = lookup.unreflectSetter(angelicaOverrideField);
            if (rendererInstance != null) {
                if (renderEventPostMethodTemp != null) {
                    renderEventPostMethodTemp = renderEventPostMethodTemp.bindTo(rendererInstance);
                }
                if (renderEventMethodTemp != null) {
                    renderEventMethodTemp = renderEventMethodTemp.bindTo(rendererInstance);
                }
                angelicaOverrideSetterTemp = angelicaOverrideSetterTemp.bindTo(rendererInstance);
            }
            isLoaded = true;
            ModStatus.LOGGER.info("Successfully initialized HoloInventory compatibility layer");
        }
        catch (Exception e) {
            ModStatus.LOGGER.warn("Failed to initialize HoloInventory compatibility layer", (Throwable)e);
            isLoaded = false;
        }
        renderEventPostMethod = renderEventPostMethodTemp;
        renderEventMethod = renderEventMethodTemp;
        angelicaOverrideSetter = angelicaOverrideSetterTemp;
    }
}

