/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.compat.backhand;

import com.gtnewhorizons.angelica.compat.ModStatus;
import com.gtnewhorizons.angelica.helpers.LoadControllerHelper;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class BackhandReflectionCompat {
    private static final String BACKHAND_CLASS = "xonin.backhand.Backhand";
    private static final String ITEM_RENDERER_HOOKS_CLASS = "xonin.backhand.client.hooks.ItemRendererHooks";
    private static final String BACKHAND_UTILS_CLASS = "xonin.backhand.api.core.BackhandUtils";
    private static boolean isLoaded;
    private static final MethodHandle renderOffhandReturn;
    private static final MethodHandle getOffhandItem;

    public static boolean isBackhandLoaded() {
        return isLoaded;
    }

    public static void renderOffhand(float partialTicks) {
        if (isLoaded && renderOffhandReturn != null) {
            try {
                renderOffhandReturn.invokeExact(partialTicks);
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable t) {
                ModStatus.LOGGER.error("Failed to invoke HoloInventory renderEvent", t);
                isLoaded = false;
            }
        }
    }

    public static ItemStack getOffhandItem(EntityPlayer player) {
        if (isLoaded && getOffhandItem != null) {
            try {
                return getOffhandItem.invokeExact(player);
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable t) {
                ModStatus.LOGGER.error("Failed to invoke HoloInventory renderEvent", t);
                isLoaded = false;
            }
        }
        return null;
    }

    static {
        MethodHandle renderOffhandReturnTemp = null;
        MethodHandle getOffhandItemTemp = null;
        try {
            boolean versionCheck;
            Class backhandClass = ReflectionHelper.getClass((ClassLoader)BackhandReflectionCompat.class.getClassLoader(), (String[])new String[]{BACKHAND_CLASS});
            boolean bl = versionCheck = new DefaultArtifactVersion("1.6.9").compareTo(LoadControllerHelper.getOwningMod(backhandClass).getProcessedVersion()) <= 0;
            if (versionCheck) {
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                Class itemRendererHooksClass = ReflectionHelper.getClass((ClassLoader)BackhandReflectionCompat.class.getClassLoader(), (String[])new String[]{ITEM_RENDERER_HOOKS_CLASS});
                Class backhandUtilsClass = ReflectionHelper.getClass((ClassLoader)BackhandReflectionCompat.class.getClassLoader(), (String[])new String[]{BACKHAND_UTILS_CLASS});
                renderOffhandReturnTemp = lookup.findStatic(itemRendererHooksClass, "renderOffhandReturn", MethodType.methodType(Void.TYPE, Float.TYPE));
                getOffhandItemTemp = lookup.findStatic(backhandUtilsClass, "getOffhandItem", MethodType.methodType(ItemStack.class, EntityPlayer.class));
                isLoaded = true;
                ModStatus.LOGGER.info("Backhand compat loaded");
            }
        }
        catch (Exception e) {
            ModStatus.LOGGER.error("Failed to load Backhand compat", (Throwable)e);
            isLoaded = false;
        }
        renderOffhandReturn = renderOffhandReturnTemp;
        getOffhandItem = getOffhandItemTemp;
    }
}

