/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.compat;

import com.gtnewhorizons.angelica.glsm.GLStateManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;

public class DriverCompatabilityCheck {
    private static final Logger LOGGER = LogManager.getLogger((String)"Angelica");
    private static final boolean DISABLE_NVIDIA_WORKAROUND = Boolean.getBoolean("angelica.disableNvidiaWorkaround");

    public static void checkDriverCompatibility() {
        String vendor = GL11.glGetString((int)7936);
        String renderer = GL11.glGetString((int)7937);
        String version = GL11.glGetString((int)7938);
        LOGGER.info("OpenGL Vendor: {}", new Object[]{vendor});
        LOGGER.info("OpenGL Renderer: {}", new Object[]{renderer});
        LOGGER.info("OpenGL Version: {}", new Object[]{version});
        if (vendor != null && vendor.contains("NVIDIA")) {
            if (DISABLE_NVIDIA_WORKAROUND) {
                LOGGER.info("NVIDIA workaround disabled via -Dangelica.disableNvidiaWorkaround=true");
            } else {
                DriverCompatabilityCheck.applyNvidiaWorkaround();
            }
        }
    }

    private static void applyNvidiaWorkaround() {
        if (!GLStateManager.capabilities.GL_ARB_debug_output) {
            LOGGER.warn("Cannot apply NVIDIA workaround: ARB_debug_output not available");
            return;
        }
        LOGGER.info("Enabling workaround for NVIDIA threaded optimizations");
        GL11.glEnable((int)33346);
    }
}

