/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.client.font;

import com.gtnewhorizons.angelica.client.font.FontProvider;
import com.gtnewhorizons.angelica.client.font.FontStrategist;
import com.gtnewhorizons.angelica.config.FontConfig;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Objects;
import javax.imageio.ImageIO;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={FontAtlas.class, GlyphData.class, InstLoader.class})
public final class FontProviderCustom
implements FontProvider {
    public static final Logger LOGGER = LogManager.getLogger((String)"Angelica");
    public static final String FONT_DIR = "fonts/custom/";
    static final int ATLAS_SIZE = 128;
    static final int ATLAS_COUNT = 512;
    private final byte id;
    private FontAtlas[] fontAtlases = new FontAtlas[512];
    private float currentFontQuality = FontConfig.customFontQuality;
    private Font font;

    FontProviderCustom(byte id) {
        String myFontName;
        this.id = id;
        Font[] availableFonts = FontStrategist.getAvailableFonts();
        switch (this.id) {
            case 0: {
                String string = FontConfig.customFontNamePrimary;
                break;
            }
            case 1: {
                String string = FontConfig.customFontNameFallback;
                break;
            }
            default: {
                String string = myFontName = null;
            }
        }
        if (Objects.equals(myFontName, "(none)")) {
            this.font = null;
            return;
        }
        int fontPos = -1;
        for (int i = 0; i < availableFonts.length; ++i) {
            if (!Objects.equals(myFontName, availableFonts[i].getFontName())) continue;
            fontPos = i;
            break;
        }
        if (fontPos == -1) {
            LOGGER.info("Could not find previously set font \"{}\". ", new Object[]{myFontName});
            this.font = null;
            return;
        }
        this.font = availableFonts[fontPos].deriveFont(this.currentFontQuality);
    }

    public static FontProviderCustom getPrimary() {
        return InstLoader.instance0;
    }

    public static FontProviderCustom getFallback() {
        return InstLoader.instance1;
    }

    public void reloadFont(int fontID) {
        this.currentFontQuality = FontConfig.customFontQuality;
        this.font = FontStrategist.getAvailableFonts()[fontID].deriveFont(this.currentFontQuality);
        File[] files = new File(this.getFontDir()).listFiles();
        if (files != null) {
            for (File f : files) {
                if (Files.isSymbolicLink(f.toPath())) continue;
                f.delete();
            }
        }
        TextureManager tm = Minecraft.func_71410_x().func_110434_K();
        Map mapTextureObjects = tm.field_110585_a;
        for (int i = 0; i < 512; ++i) {
            ResourceLocation key = new ResourceLocation(this.getAtlasResourceName(i));
            if (!mapTextureObjects.containsKey(key)) continue;
            ITextureObject obj = (ITextureObject)mapTextureObjects.get(key);
            TextureUtil.func_147942_a((int)obj.func_110552_b());
            mapTextureObjects.remove(key);
        }
        this.fontAtlases = new FontAtlas[512];
    }

    private String getFontDir() {
        return FontProviderCustom.jvmdowngrader$concat$getFontDir$1(this.id);
    }

    private String getAtlasFilename(int atlasId) {
        return FontProviderCustom.jvmdowngrader$concat$getAtlasFilename$1(this.id, atlasId);
    }

    String getAtlasResourceName(int atlasId) {
        return FontProviderCustom.jvmdowngrader$concat$getAtlasResourceName$1(this.getAtlasFilename(atlasId));
    }

    String getAtlasFullPath(int atlasId) {
        return FontProviderCustom.jvmdowngrader$concat$getAtlasFullPath$1(this.getFontDir(), this.getAtlasFilename(atlasId));
    }

    private FontAtlas getAtlas(char chr) {
        int id = chr / 128;
        FontAtlas fa = this.fontAtlases[id];
        if (fa == null) {
            fa = new FontAtlas(this, id);
            fa.construct(this.font);
        }
        this.fontAtlases[id] = fa;
        return fa;
    }

    @Override
    public boolean isGlyphAvailable(char chr) {
        if (this.font == null) {
            return false;
        }
        return this.getAtlas((char)chr).glyphData[chr % 128] != null;
    }

    @Override
    public char getRandomReplacement(char chr) {
        return chr;
    }

    @Override
    public float getUStart(char chr) {
        return this.getAtlas((char)chr).glyphData[chr % 128].jvmdowngrader$nest$com_gtnewhorizons_angelica_client_font_FontProviderCustom$GlyphData$get$uStart();
    }

    @Override
    public float getVStart(char chr) {
        return this.getAtlas((char)chr).glyphData[chr % 128].jvmdowngrader$nest$com_gtnewhorizons_angelica_client_font_FontProviderCustom$GlyphData$get$vStart();
    }

    @Override
    public float getXAdvance(char chr) {
        return this.getAtlas((char)chr).glyphData[chr % 128].jvmdowngrader$nest$com_gtnewhorizons_angelica_client_font_FontProviderCustom$GlyphData$get$xAdvance() * FontConfig.customFontScale;
    }

    @Override
    public float getGlyphW(char chr) {
        return this.getAtlas((char)chr).glyphData[chr % 128].jvmdowngrader$nest$com_gtnewhorizons_angelica_client_font_FontProviderCustom$GlyphData$get$glyphW() * FontConfig.customFontScale;
    }

    @Override
    public float getUSize(char chr) {
        return this.getAtlas((char)chr).glyphData[chr % 128].jvmdowngrader$nest$com_gtnewhorizons_angelica_client_font_FontProviderCustom$GlyphData$get$uSz();
    }

    @Override
    public float getVSize(char chr) {
        return this.getAtlas((char)chr).glyphData[chr % 128].jvmdowngrader$nest$com_gtnewhorizons_angelica_client_font_FontProviderCustom$GlyphData$get$vSz();
    }

    @Override
    public float getShadowOffset() {
        return FontConfig.fontShadowOffset;
    }

    @Override
    public ResourceLocation getTexture(char chr) {
        return this.getAtlas(chr).jvmdowngrader$nest$com_gtnewhorizons_angelica_client_font_FontProviderCustom$FontAtlas$get$texture();
    }

    @Override
    public float getYScaleMultiplier() {
        return FontConfig.customFontScale;
    }

    @Generated
    public void setFont(Font font) {
        this.font = font;
    }

    public /* synthetic */ String jvmdowngrader$nest$com_gtnewhorizons_angelica_client_font_FontProviderCustom$getFontDir() {
        return this.getFontDir();
    }

    public /* synthetic */ float jvmdowngrader$nest$com_gtnewhorizons_angelica_client_font_FontProviderCustom$get$currentFontQuality() {
        return this.currentFontQuality;
    }

    public /* synthetic */ void jvmdowngrader$nest$com_gtnewhorizons_angelica_client_font_FontProviderCustom$set$currentFontQuality(float f) {
        this.currentFontQuality = f;
    }

    private static /* synthetic */ String jvmdowngrader$concat$getFontDir$1(byte by) {
        return "fonts/custom/f" + by + "/";
    }

    private static /* synthetic */ String jvmdowngrader$concat$getAtlasFilename$1(byte by, int n) {
        return "f" + by + "p" + n;
    }

    private static /* synthetic */ String jvmdowngrader$concat$getAtlasResourceName$1(String string) {
        return "minecraft:angelica_c" + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$getAtlasFullPath$1(String string, String string2) {
        return string + string2 + ".png";
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=FontProviderCustom.class)
    private class FontAtlas {
        GlyphData[] glyphData;
        private ResourceLocation texture;
        private final int id;
        final /* synthetic */ FontProviderCustom this$0;

        FontAtlas(FontProviderCustom fontProviderCustom, int id) {
            FontProviderCustom fontProviderCustom2 = fontProviderCustom;
            Objects.requireNonNull(fontProviderCustom2);
            this.this$0 = fontProviderCustom2;
            this.glyphData = new GlyphData[128];
            this.id = id;
        }

        void construct(Font font) {
            float separator = this.this$0.jvmdowngrader$nest$com_gtnewhorizons_angelica_client_font_FontProviderCustom$get$currentFontQuality() / 3.0f;
            BufferedImage image = new BufferedImage(1, 1, 2);
            Graphics2D g2d = image.createGraphics();
            g2d.setFont(font);
            FontMetrics fm = g2d.getFontMetrics();
            g2d.dispose();
            int width = 0;
            int actualChars = 0;
            for (int i = 0; i < 128; ++i) {
                char ch = (char)(i + 128 * this.id);
                if (!font.canDisplay(ch)) continue;
                width += (int)(separator + (float)fm.charWidth(ch));
                ++actualChars;
            }
            if (actualChars == 0) {
                return;
            }
            int atlasTilesX = (int)Math.ceil(Math.sqrt(actualChars) * 1.5);
            int atlasTilesY = (int)Math.ceil((double)actualChars / (double)atlasTilesX);
            LOGGER.info("constructing custom font atlas (ID {}) of nominal size {} chars, actual: {}, {} rows by {} columns", new Object[]{this.id, 128, actualChars, atlasTilesX, atlasTilesY});
            width = 0;
            actualChars = 0;
            int maxRowWidth = 0;
            for (int i = 0; i < 128; ++i) {
                char ch;
                if (actualChars % atlasTilesX == 0) {
                    maxRowWidth = Math.max(maxRowWidth, width);
                    width = 0;
                }
                if (!font.canDisplay(ch = (char)(i + 128 * this.id))) continue;
                width += (int)(separator + (float)fm.charWidth(ch));
                ++actualChars;
            }
            maxRowWidth = Math.max(maxRowWidth, width);
            int lineHeight = fm.getHeight();
            float desc = fm.getDescent();
            int imageWidth = (int)((float)maxRowWidth + separator);
            int imageHeight = (int)((separator + (float)lineHeight) * (float)atlasTilesY + separator);
            image = new BufferedImage(imageWidth, imageHeight, 2);
            g2d = image.createGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2d.setFont(font);
            fm = g2d.getFontMetrics();
            int tileX = 0;
            int tileY = 0;
            int imgX = (int)separator;
            for (int i = 0; i < 128; ++i) {
                char ch = (char)(i + 128 * this.id);
                if (!font.canDisplay(ch)) continue;
                if (tileX >= atlasTilesX) {
                    tileX = 0;
                    imgX = (int)separator;
                    ++tileY;
                }
                int charWidth = fm.charWidth(ch);
                float charAspectRatio = (float)charWidth / (float)lineHeight;
                float inset = this.this$0.jvmdowngrader$nest$com_gtnewhorizons_angelica_client_font_FontProviderCustom$get$currentFontQuality() / 16.0f;
                g2d.drawString(Character.toString(ch), (float)imgX, ((float)lineHeight + separator) * (float)(tileY + 1) - desc);
                float uStart = ((float)imgX - inset * charAspectRatio) / (float)imageWidth;
                float vStart = (((float)lineHeight + separator) * (float)(tileY + 1) - (float)lineHeight - inset) / (float)imageHeight;
                float xAdvance = charAspectRatio * 8.0f * (float)charWidth / ((float)charWidth + 2.0f * inset * charAspectRatio);
                float glyphW = charAspectRatio * 8.0f + 1.0f;
                float uSz = ((float)charWidth + 2.0f * inset * charAspectRatio) / (float)imageWidth;
                float vSz = ((float)lineHeight + 2.0f * inset) / (float)imageHeight;
                this.glyphData[i] = new GlyphData(this.this$0, uStart, vStart, xAdvance, glyphW, uSz, vSz);
                imgX += (int)((float)charWidth + separator);
                ++tileX;
            }
            g2d.dispose();
            try {
                LOGGER.info("writing custom font atlas texture ({}x{} px) to {}", new Object[]{imageWidth, imageHeight, this.this$0.getAtlasFullPath(this.id)});
                Files.createDirectories(Paths.get(this.this$0.jvmdowngrader$nest$com_gtnewhorizons_angelica_client_font_FontProviderCustom$getFontDir(), new String[0]), new FileAttribute[0]);
                ImageIO.write((RenderedImage)image, "png", new File(this.this$0.getAtlasFullPath(this.id)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.texture = new ResourceLocation(this.this$0.getAtlasResourceName(this.id));
        }

        public /* synthetic */ ResourceLocation jvmdowngrader$nest$com_gtnewhorizons_angelica_client_font_FontProviderCustom$FontAtlas$get$texture() {
            return this.texture;
        }

        public /* synthetic */ void jvmdowngrader$nest$com_gtnewhorizons_angelica_client_font_FontProviderCustom$FontAtlas$set$texture(ResourceLocation resourceLocation) {
            this.texture = resourceLocation;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=FontProviderCustom.class)
    private static class InstLoader {
        static final FontProviderCustom instance0 = new FontProviderCustom(0);
        static final FontProviderCustom instance1 = new FontProviderCustom(1);

        private InstLoader() {
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=FontProviderCustom.class)
    private final class GlyphData {
        private final float uStart;
        private final float vStart;
        private final float xAdvance;
        private final float glyphW;
        private final float uSz;
        private final float vSz;

        @Generated
        public GlyphData(FontProviderCustom fontProviderCustom, float uStart, float vStart, float xAdvance, float glyphW, float uSz, float vSz) {
            Objects.requireNonNull(fontProviderCustom);
            this.uStart = uStart;
            this.vStart = vStart;
            this.xAdvance = xAdvance;
            this.glyphW = glyphW;
            this.uSz = uSz;
            this.vSz = vSz;
        }

        @Generated
        public float getUStart() {
            return this.uStart;
        }

        @Generated
        public float getVStart() {
            return this.vStart;
        }

        @Generated
        public float getXAdvance() {
            return this.xAdvance;
        }

        @Generated
        public float getGlyphW() {
            return this.glyphW;
        }

        @Generated
        public float getUSz() {
            return this.uSz;
        }

        @Generated
        public float getVSz() {
            return this.vSz;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GlyphData)) {
                return false;
            }
            GlyphData other = (GlyphData)o;
            if (Float.compare(this.getUStart(), other.getUStart()) != 0) {
                return false;
            }
            if (Float.compare(this.getVStart(), other.getVStart()) != 0) {
                return false;
            }
            if (Float.compare(this.getXAdvance(), other.getXAdvance()) != 0) {
                return false;
            }
            if (Float.compare(this.getGlyphW(), other.getGlyphW()) != 0) {
                return false;
            }
            if (Float.compare(this.getUSz(), other.getUSz()) != 0) {
                return false;
            }
            return Float.compare(this.getVSz(), other.getVSz()) == 0;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Float.floatToIntBits(this.getUStart());
            result = result * 59 + Float.floatToIntBits(this.getVStart());
            result = result * 59 + Float.floatToIntBits(this.getXAdvance());
            result = result * 59 + Float.floatToIntBits(this.getGlyphW());
            result = result * 59 + Float.floatToIntBits(this.getUSz());
            result = result * 59 + Float.floatToIntBits(this.getVSz());
            return result;
        }

        @Generated
        public String toString() {
            return GlyphData.jvmdowngrader$concat$toString$1(this.getUStart(), this.getVStart(), this.getXAdvance(), this.getGlyphW(), this.getUSz(), this.getVSz());
        }

        public /* synthetic */ float jvmdowngrader$nest$com_gtnewhorizons_angelica_client_font_FontProviderCustom$GlyphData$get$xAdvance() {
            return this.xAdvance;
        }

        public /* synthetic */ void jvmdowngrader$nest$com_gtnewhorizons_angelica_client_font_FontProviderCustom$GlyphData$set$xAdvance(float f) {
            this.xAdvance = f;
        }

        public /* synthetic */ float jvmdowngrader$nest$com_gtnewhorizons_angelica_client_font_FontProviderCustom$GlyphData$get$uStart() {
            return this.uStart;
        }

        public /* synthetic */ void jvmdowngrader$nest$com_gtnewhorizons_angelica_client_font_FontProviderCustom$GlyphData$set$uStart(float f) {
            this.uStart = f;
        }

        public /* synthetic */ float jvmdowngrader$nest$com_gtnewhorizons_angelica_client_font_FontProviderCustom$GlyphData$get$vSz() {
            return this.vSz;
        }

        public /* synthetic */ void jvmdowngrader$nest$com_gtnewhorizons_angelica_client_font_FontProviderCustom$GlyphData$set$vSz(float f) {
            this.vSz = f;
        }

        public /* synthetic */ float jvmdowngrader$nest$com_gtnewhorizons_angelica_client_font_FontProviderCustom$GlyphData$get$uSz() {
            return this.uSz;
        }

        public /* synthetic */ void jvmdowngrader$nest$com_gtnewhorizons_angelica_client_font_FontProviderCustom$GlyphData$set$uSz(float f) {
            this.uSz = f;
        }

        public /* synthetic */ float jvmdowngrader$nest$com_gtnewhorizons_angelica_client_font_FontProviderCustom$GlyphData$get$glyphW() {
            return this.glyphW;
        }

        public /* synthetic */ void jvmdowngrader$nest$com_gtnewhorizons_angelica_client_font_FontProviderCustom$GlyphData$set$glyphW(float f) {
            this.glyphW = f;
        }

        public /* synthetic */ float jvmdowngrader$nest$com_gtnewhorizons_angelica_client_font_FontProviderCustom$GlyphData$get$vStart() {
            return this.vStart;
        }

        public /* synthetic */ void jvmdowngrader$nest$com_gtnewhorizons_angelica_client_font_FontProviderCustom$GlyphData$set$vStart(float f) {
            this.vStart = f;
        }

        private static /* synthetic */ String jvmdowngrader$concat$toString$1(float f, float f2, float f3, float f4, float f5, float f6) {
            return "FontProviderCustom.GlyphData(uStart=" + f + ", vStart=" + f2 + ", xAdvance=" + f3 + ", glyphW=" + f4 + ", uSz=" + f5 + ", vSz=" + f6 + ")";
        }
    }
}

